/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.legacy.ReversibleCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.PrePostProcessingCommandInterceptor;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.LockUtil;
import org.jboss.cache.lock.PessimisticNodeBasedLockManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.PessimisticTransactionContext;
import org.jboss.cache.transaction.TransactionContext;

@Deprecated
public class PessimisticLockInterceptor
extends PrePostProcessingCommandInterceptor {
    private DataContainer dataContainer;
    private PessimisticNodeBasedLockManager lockManager;
    private CommandsFactory commandsFactory;

    @Inject
    public void injectDependencies(DataContainer dataContainer, LockManager lockManager, CommandsFactory commandsFactory) {
        this.dataContainer = dataContainer;
        this.lockManager = (PessimisticNodeBasedLockManager)lockManager;
        this.commandsFactory = commandsFactory;
    }

    protected Object handlePutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        return this.handlePutCommand(ctx, command, false);
    }

    protected Object handlePutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handlePutCommand(ctx, command, false);
    }

    protected Object handlePutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.handlePutCommand(ctx, command, true);
    }

    private Object handlePutCommand(InvocationContext ctx, DataCommand command, boolean zeroAcquisitionTimeout) throws Throwable {
        if (ctx.isLockingSuppressed() || this.configuration.getIsolationLevel() == IsolationLevel.NONE) {
            if (this.trace) {
                this.log.trace("Suppressing locking, creating nodes if necessary");
            }
            int treeNodeSize = command.getFqn().size();
            NodeSPI n = this.dataContainer.getRoot();
            for (int i = 0; i < treeNodeSize; ++i) {
                Object childName = command.getFqn().get(i);
                Fqn<Object> childFqn = Fqn.fromElements(childName);
                NodeSPI childNode = n.getChildDirect(childFqn);
                if (childNode == null) {
                    childNode = n.addChildDirect(childFqn);
                }
                LockUtil.manageReverseRemove(ctx, childNode, true, null, this.commandsFactory);
                n = childNode;
            }
        } else {
            this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.WRITE, true, zeroAcquisitionTimeout, false, true, null, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    protected Object handlePrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.commit(ctx.getTransactionContext(), ctx.getGlobalTransaction());
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.lockManager.unlock(ctx);
        return retVal;
    }

    protected Object handleCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        this.commit(ctx.getTransactionContext(), command.getGlobalTransaction());
        if (this.trace) {
            this.log.trace("bypassed locking as method commit() doesn't require locking");
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.lockManager.unlock(ctx);
        return retVal;
    }

    protected Object handleRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (this.trace) {
            this.log.trace("called to rollback cache with GlobalTransaction=" + command.getGlobalTransaction());
        }
        if (transactionContext == null) {
            this.log.error("transactionContext for transaction " + command.getGlobalTransaction() + " not found (transaction has possibly already been rolled back)");
        } else {
            for (Fqn fqn : transactionContext.getRemovedNodes()) {
                this.dataContainer.removeFromDataStructure(fqn, false);
            }
            this.undoOperations((PessimisticTransactionContext)transactionContext);
        }
        if (this.trace) {
            this.log.trace("bypassed locking as method rollback() doesn't require locking");
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.lockManager.unlock(ctx);
        return retVal;
    }

    private void undoOperations(PessimisticTransactionContext transactionContext) {
        List<WriteCommand> modificationList = transactionContext.getAllModifications();
        if (modificationList.isEmpty()) {
            if (this.trace) {
                this.log.trace("Modification list is null, no modifications in this transaction!");
            }
            return;
        }
        if (this.trace) {
            this.log.trace("undoOperations " + modificationList);
        }
        ArrayList<WriteCommand> copy = new ArrayList<WriteCommand>(modificationList);
        RuntimeException exc = null;
        ListIterator<WriteCommand> i = copy.listIterator(copy.size());
        while (i.hasPrevious()) {
            WriteCommand undoOp = i.previous();
            ReversibleCommand txCommand = (ReversibleCommand)undoOp;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Calling rollback() on command " + undoOp);
            }
            try {
                txCommand.rollback();
            }
            catch (RuntimeException re) {
                exc = re;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected Object handleMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        NodeSPI n;
        if (ctx.isLockingSuppressed()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        if (this.trace) {
            this.log.trace("Attempting to get WL on node to be moved [" + command.getFqn() + "]");
        }
        if (command.getFqn() != null && this.configuration.getIsolationLevel() != IsolationLevel.NONE) {
            this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.WRITE, false, false, true, false, null, false);
            if (ctx.getGlobalTransaction() != null) {
                ctx.getTransactionContext().addRemovedNode(command.getFqn());
            }
            this.lockManager.lockAllAndRecord(this.dataContainer.peek(command.getFqn(), true, false), LockType.WRITE, ctx);
        }
        if (command.getTo() != null && this.configuration.getIsolationLevel() != IsolationLevel.NONE) {
            if (this.trace) {
                this.log.trace("Attempting to get RL on new parent [" + command.getTo() + "]");
            }
            this.lockManager.lockPessimistically(ctx, command.getTo(), LockType.READ, false, false, false, false, null, false);
            this.lockManager.lockAllAndRecord(this.dataContainer.peek(command.getTo(), true, false), LockType.READ, ctx);
        }
        Object retValue = this.invokeNextInterceptor(ctx, command);
        if (ctx.getTransaction() == null && (n = this.dataContainer.peek(command.getFqn(), true, false)) != null) {
            this.lockManager.unlockAll(n, (Object)Thread.currentThread());
        }
        return retValue;
    }

    protected Object handleRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        if (ctx.isLockingSuppressed()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        LinkedList<NodeSPI> createdNodes = new LinkedList<NodeSPI>();
        boolean created = this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.WRITE, true, false, true, true, createdNodes, true);
        TransactionContext transactionContext = null;
        if (ctx.getGlobalTransaction() != null) {
            transactionContext = ctx.getTransactionContext();
            transactionContext.addRemovedNode(command.getFqn());
            for (NodeSPI nodeSPI : createdNodes) {
                transactionContext.addRemovedNode(nodeSPI.getFqn());
                nodeSPI.markAsDeleted(true);
            }
        }
        this.lockAllForRemoval(this.dataContainer.peek(command.getFqn(), false, false), ctx, transactionContext);
        if (!createdNodes.isEmpty()) {
            if (this.trace) {
                this.log.trace("There were new nodes created, skipping notification on delete");
            }
            if (this.trace) {
                this.log.trace("Changing 'skipNotification' for command 'remove' from " + command.isSkipSendingNodeEvents() + " to true");
            }
            command.setSkipSendingNodeEvents(true);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (ctx.getGlobalTransaction() == null) {
            for (NodeSPI nodeSPI : createdNodes) {
                this.dataContainer.removeFromDataStructure(nodeSPI.getFqn(), true);
            }
            this.dataContainer.removeFromDataStructure(command.getFqn(), true);
            NodeSPI n = this.dataContainer.peek(command.getFqn(), true, false);
            if (n != null) {
                this.lockManager.unlockAll(n, (Object)Thread.currentThread());
            }
        }
        return created ? Boolean.valueOf(false) : retVal;
    }

    public void lockAllForRemoval(NodeSPI node, InvocationContext ctx, TransactionContext transactionContext) throws InterruptedException {
        if (node == null) {
            return;
        }
        this.lockManager.lockAndRecord(node, LockType.WRITE, ctx);
        if (transactionContext != null) {
            transactionContext.addRemovedNode(node.getFqn());
        }
        Map children = node.getChildrenMapDirect();
        for (NodeSPI nodeSPI : children.values()) {
            this.lockAllForRemoval(nodeSPI, ctx, transactionContext);
        }
    }

    protected Object handleRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.WRITE, false, false, false, false, null, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    protected Object handleClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.WRITE, false, false, false, false, null, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    protected Object handleEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.WRITE, false, true, false, false, null, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    protected Object handleGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.READ, false, false, false, false, null, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    protected Object handleGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.READ, false, false, false, false, null, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    protected Object handleGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.READ, false, false, false, false, null, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    protected Object handleGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        this.lockManager.lockPessimistically(ctx, command.getFqn(), LockType.READ, false, false, false, false, null, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    public void doAfterCall(InvocationContext ctx, VisitableCommand command) {
        if (!ctx.isValidTransaction()) {
            this.lockManager.unlock(ctx);
        }
    }

    private void commit(TransactionContext transactionContext, GlobalTransaction gtx) {
        if (this.trace) {
            this.log.trace("committing cache with gtx " + gtx);
        }
        if (transactionContext == null) {
            this.log.error("transactionContext for transaction " + gtx + " not found (maybe already committed)");
            return;
        }
        for (Fqn fqn : transactionContext.getRemovedNodes()) {
            this.dataContainer.removeFromDataStructure(fqn, false);
        }
    }
}

