/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.SortedEvictionQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSortedEvictionAlgorithm
extends BaseEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(BaseSortedEvictionAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected void processQueues(BlockingQueue<EvictionEvent> queue) throws EvictionException {
        EvictionEvent node;
        boolean evictionNodesModified = false;
        int count = 0;
        block7: while ((node = this.getNextInQueue(queue)) != null) {
            ++count;
            switch (node.getEventType()) {
                case ADD_NODE_EVENT: {
                    this.processAddedNodes(node);
                    evictionNodesModified = true;
                    continue block7;
                }
                case REMOVE_NODE_EVENT: {
                    this.processRemovedNodes(node);
                    continue block7;
                }
                case VISIT_NODE_EVENT: {
                    this.processVisitedNodes(node);
                    evictionNodesModified = true;
                    continue block7;
                }
                case ADD_ELEMENT_EVENT: {
                    this.processAddedElement(node);
                    evictionNodesModified = true;
                    continue block7;
                }
                case REMOVE_ELEMENT_EVENT: {
                    this.processRemovedElement(node);
                    evictionNodesModified = true;
                    continue block7;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + (Object)((Object)node.getEventType()));
        }
        if (trace) {
            log.trace("Eviction nodes visited or added requires resort of queue " + evictionNodesModified);
        }
        this.resortEvictionQueue(evictionNodesModified);
        if (trace) {
            log.trace("processed " + count + " node events");
        }
    }

    protected void resortEvictionQueue(boolean evictionQueueModified) {
        if (!evictionQueueModified) {
            if (log.isDebugEnabled()) {
                log.debug("Eviction queue not modified. Resort unnecessary.");
            }
            return;
        }
        long begin = System.currentTimeMillis();
        ((SortedEvictionQueue)this.evictionQueue).resortEvictionQueue();
        long end = System.currentTimeMillis();
        if (trace) {
            long diff = end - begin;
            log.trace("Took " + diff + "ms to sort queue with " + this.getEvictionQueue().getNumberOfNodes() + " elements");
        }
    }
}

