/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.protocols.AuthHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;

public class AUTH
extends Protocol {
    static final String NAME = "AUTH";
    private AuthToken serverSideToken = null;

    public boolean setProperties(Properties props) {
        String authClassString = props.getProperty("auth_class");
        if (authClassString != null) {
            props.remove("auth_class");
            try {
                Object obj = Class.forName(authClassString).newInstance();
                this.serverSideToken = (AuthToken)obj;
                this.serverSideToken.setAuth(this);
                this.serverSideToken.setValue(props);
            }
            catch (Exception e) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal("Failed to create server side token (" + authClassString + ")");
                    this.log.fatal(e);
                }
                return false;
            }
        }
        if (!props.isEmpty()) {
            if (this.log.isErrorEnabled()) {
                this.log.error("AUTH.setProperties(): the following properties are not recognized: " + props);
            }
            return false;
        }
        return true;
    }

    public final String getName() {
        return NAME;
    }

    private Event createFailureEvent(Address joiner, String message) {
        Message msg = new Message(joiner, null, null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating JoinRsp with failure message - " + message);
        }
        JoinRsp joinRes = new JoinRsp(message);
        GMS.GmsHeader gmsHeader = new GMS.GmsHeader(2, joinRes);
        msg.putHeader("GMS", gmsHeader);
        if (this.log.isDebugEnabled()) {
            this.log.debug("GMSHeader created for failure JOIN_RSP");
        }
        return new Event(1, msg);
    }

    public Object up(Event evt) {
        GMS.GmsHeader hdr = AUTH.isJoinMessage(evt);
        if (hdr != null && hdr.getType() == 1) {
            Message msg;
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTH got up event");
            }
            if ((msg = (Message)evt.getArg()).getHeader(NAME) != null && msg.getHeader(NAME) instanceof AuthHeader) {
                AuthHeader authHeader = (AuthHeader)msg.getHeader(NAME);
                if (authHeader != null) {
                    if (this.serverSideToken.authenticate(authHeader.getToken(), msg)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("AUTH passing up event");
                        }
                        this.up_prot.up(evt);
                    } else {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn("AUTH failed to validate AuthHeader token");
                        }
                        this.sendRejectionMessage(msg.getSrc(), this.createFailureEvent(msg.getSrc(), "Authentication failed"));
                    }
                } else {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("AUTH failed to get valid AuthHeader from Message");
                    }
                    this.sendRejectionMessage(msg.getSrc(), this.createFailureEvent(msg.getSrc(), "Failed to find valid AuthHeader in Message"));
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No AUTH Header Found");
                }
                this.sendRejectionMessage(msg.getSrc(), this.createFailureEvent(msg.getSrc(), "Failed to find an AuthHeader in Message"));
            }
        } else {
            return this.up_prot.up(evt);
        }
        return null;
    }

    private void sendRejectionMessage(Address dest, Event join_rsp) {
        if (dest == null) {
            this.log.error("destination is null, cannot send JOIN rejection message to null destination");
            return;
        }
        this.down_prot.down(join_rsp);
    }

    public Object down(Event evt) {
        GMS.GmsHeader hdr = AUTH.isJoinMessage(evt);
        if (hdr != null && hdr.getType() == 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTH got down event");
            }
            Message msg = (Message)evt.getArg();
            AuthHeader authHeader = new AuthHeader();
            authHeader.setToken(this.serverSideToken);
            msg.putHeader(NAME, authHeader);
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTH passing down event");
            }
        }
        if (hdr != null && hdr.getType() == 2 && this.log.isDebugEnabled()) {
            this.log.debug(hdr.toString());
        }
        return this.down_prot.down(evt);
    }

    private static GMS.GmsHeader isJoinMessage(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader("GMS");
                if (obj == null || !(obj instanceof GMS.GmsHeader)) {
                    return null;
                }
                return (GMS.GmsHeader)obj;
            }
        }
        return null;
    }
}

