/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheStatus {
    INSTANTIATED,
    CREATING,
    CREATED,
    STARTING,
    STARTED,
    STOPPING,
    STOPPED,
    DESTROYING,
    DESTROYED,
    FAILED;

    private static final Log log;

    public boolean createAllowed() {
        switch (this) {
            case CREATING: 
            case CREATED: 
            case STARTING: 
            case STARTED: 
            case STOPPED: 
            case FAILED: 
            case STOPPING: 
            case DESTROYING: {
                return false;
            }
        }
        return true;
    }

    public boolean needToDestroyFailedCache() {
        if (this == FAILED) {
            log.debug("need to call destroy() since current state is " + (Object)((Object)this));
            return true;
        }
        return false;
    }

    public boolean startAllowed() {
        switch (this) {
            case STARTING: 
            case STARTED: 
            case FAILED: 
            case STOPPING: 
            case DESTROYING: 
            case INSTANTIATED: 
            case DESTROYED: {
                return false;
            }
        }
        return true;
    }

    public boolean needCreateBeforeStart() {
        switch (this) {
            case INSTANTIATED: 
            case DESTROYED: {
                log.debug("start() called while current state is " + (Object)((Object)this) + " -- call create() first");
                return true;
            }
        }
        return false;
    }

    public boolean stopAllowed() {
        switch (this) {
            case CREATED: 
            case STOPPED: 
            case STOPPING: 
            case INSTANTIATED: 
            case DESTROYED: {
                log.debug("Ignoring call to stop() as current state is " + (Object)((Object)this));
                return false;
            }
            case CREATING: 
            case STARTING: 
            case DESTROYING: {
                log.warn("Ignoring call to stop() as current state is " + (Object)((Object)this));
                return false;
            }
        }
        return true;
    }

    public boolean destroyAllowed() {
        switch (this) {
            case DESTROYING: 
            case INSTANTIATED: 
            case DESTROYED: {
                log.debug("Ignoring call to destroy() as current state is " + (Object)((Object)this));
                return false;
            }
            case CREATING: 
            case STARTING: 
            case STOPPING: {
                log.warn("Ignoring call to destroy() as current state is " + (Object)((Object)this));
                return false;
            }
            case STARTED: {
                return false;
            }
        }
        return true;
    }

    public boolean needStopBeforeDestroy() {
        if (this == STARTED) {
            log.warn("destroy() called while current state is " + (Object)((Object)this) + " -- call stop() first");
            return true;
        }
        return false;
    }

    public boolean allowInvocations() {
        return this == STARTED;
    }

    static {
        log = LogFactory.getLog(CacheStatus.class);
    }
}

