/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.legacy.write.CreateNodeCommand;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.PessimisticNodeBasedLockManager;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.util.FastCopyHashMap;
import org.jboss.cache.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PessimisticUnversionedNode<K, V>
extends UnversionedNode<K, V> {
    protected volatile transient IdentityLock lock = null;
    protected LockStrategyFactory lockStrategyFactory;
    CommandsFactory commandsFactory;
    protected NodeFactory<K, V> nodeFactory;

    public PessimisticUnversionedNode(Object name, Fqn fqn, Map<K, V> data, CacheSPI<K, V> cache) {
        super(fqn, cache, false);
        if (!fqn.isRoot() && !name.equals(fqn.getLastElement())) {
            throw new IllegalArgumentException("Child " + name + " must be last part of " + fqn);
        }
        if (data != null && !data.isEmpty()) {
            this.setInternalState(data);
        } else {
            this.data = new FastCopyHashMap();
        }
        this.setLockForChildInsertRemove(cache != null && cache.getConfiguration() != null && cache.getConfiguration().isLockParentForChildInsertRemove());
    }

    private ConcurrentMap<Object, Node<K, V>> children() {
        return this.children;
    }

    public void injectLockStrategyFactory(LockStrategyFactory lockStrategyFactory) {
        this.lockStrategyFactory = lockStrategyFactory;
    }

    public void injectDependencies(CacheSPI<K, V> spi, CommandsFactory commandsFactory, NodeFactory<K, V> nodeFactory) {
        this.cache = spi;
        this.commandsFactory = commandsFactory;
        this.nodeFactory = nodeFactory;
    }

    protected synchronized void initLock() {
        if (this.lock == null) {
            this.lock = new IdentityLock(this.lockStrategyFactory, this.delegate);
        }
    }

    @Override
    public IdentityLock getLock() {
        if (this.lock == null) {
            this.initLock();
        }
        return this.lock;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.lock != null) {
            if (this.lock.isReadLocked()) {
                sb.append(" RL");
            }
            if (this.lock.isWriteLocked()) {
                sb.append(" WL");
            }
        }
        return sb.toString();
    }

    @Override
    public InternalNode<K, V> copy() {
        PessimisticUnversionedNode<K, V> n = new PessimisticUnversionedNode<K, V>(this.fqn.getLastElement(), this.fqn, this.data, this.cache);
        this.copyInternals(n);
        n.children = this.children;
        n.lockStrategyFactory = this.lockStrategyFactory;
        n.commandsFactory = this.commandsFactory;
        n.nodeFactory = this.nodeFactory;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildDirect(NodeSPI<K, V> child) {
        Fqn childFqn = child.getFqn();
        if (childFqn.isDirectChildOf(this.fqn)) {
            PessimisticUnversionedNode pessimisticUnversionedNode = this;
            synchronized (pessimisticUnversionedNode) {
                this.children().put(child.getFqn().getLastElement(), child);
            }
        } else {
            throw new CacheException("Attempting to add a child [" + child.getFqn() + "] to [" + this.getFqn() + "].  Can only add direct children.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeSPI<K, V> getOrCreateChild(Object childName, GlobalTransaction gtx, boolean createIfNotExists, boolean notify, PessimisticNodeBasedLockManager.LockAcquirer la) {
        if (childName == null) {
            throw new IllegalArgumentException("null child name");
        }
        NodeSPI<K, V> child = (NodeSPI<K, V>)this.children().get(childName);
        InvocationContext ctx = this.cache.getInvocationContext();
        if (createIfNotExists && child == null) {
            Fqn<Object> childFqn = Fqn.fromRelativeElements(this.fqn, childName);
            NodeSPI<K, V> newChild = this.nodeFactory.createNode(childFqn, this.delegate);
            if (newChild == null) {
                throw new IllegalStateException();
            }
            PessimisticUnversionedNode pessimisticUnversionedNode = this;
            synchronized (pessimisticUnversionedNode) {
                child = (NodeSPI)this.children().get(childName);
                if (child == null) {
                    if (notify) {
                        this.cache.getNotifier().notifyNodeCreated(childFqn, true, ctx);
                    }
                    child = newChild;
                    if (la != null) {
                        la.acquire(child);
                    }
                    this.children().put(childName, child);
                }
            }
            if (newChild == child) {
                if (trace) {
                    log.trace("created child: fqn=" + childFqn);
                }
                if (gtx != null) {
                    CreateNodeCommand createNodeCommand = this.commandsFactory.buildCreateNodeCommand(childFqn);
                    ctx.getTransactionContext().addLocalModification(createNodeCommand);
                }
                if (notify) {
                    this.cache.getNotifier().notifyNodeCreated(childFqn, false, ctx);
                }
            }
        }
        return child;
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Fqn f, boolean notify) {
        if (f.size() == 1) {
            GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
            return this.getOrCreateChild(f.getLastElement(), gtx, true, notify, null);
        }
        throw new UnsupportedOperationException("Cannot directly create children which aren't directly under the current node.");
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Object o, boolean notify) {
        GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
        return this.getOrCreateChild(o, gtx, true, notify, null);
    }

    public NodeSPI<K, V> addChildAndAcquireLock(Object o, boolean notify, PessimisticNodeBasedLockManager.LockAcquirer la) {
        GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
        return this.getOrCreateChild(o, gtx, true, notify, la);
    }

    @Override
    public NodeSPI<K, V> getChildDirect(Fqn fqn) {
        if (fqn.size() == 1) {
            return this.getChildDirect(fqn.getLastElement());
        }
        NodeSPI currentNode = this.delegate;
        for (int i = 0; i < fqn.size(); ++i) {
            Object nextChildName = fqn.get(i);
            if ((currentNode = currentNode.getChildDirect(nextChildName)) != null) continue;
            return null;
        }
        return currentNode;
    }

    @Override
    public NodeSPI<K, V> getChildDirect(Object childName) {
        if (childName == null) {
            return null;
        }
        return (NodeSPI)this.children().get(childName);
    }

    @Override
    public Set<NodeSPI<K, V>> getChildrenDirect() {
        if (this.children == null || this.children.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<NodeSPI<K, V>> exclDeleted = new HashSet();
        for (Node n : this.children().values()) {
            NodeSPI spi = (NodeSPI)n;
            if (spi.isDeleted()) continue;
            exclDeleted.add(spi);
        }
        exclDeleted = Collections.unmodifiableSet(exclDeleted);
        return exclDeleted;
    }

    @Override
    public Map<Object, Node<K, V>> getChildrenMapDirect() {
        return this.children();
    }

    @Override
    public void setChildrenMapDirect(Map<Object, Node<K, V>> children) {
        if (children == null) {
            this.children = null;
        } else {
            this.children.clear();
            this.children().putAll(children);
        }
    }

    @Override
    public void addChildDirect(Object nodeName, Node<K, V> nodeToAdd) {
        if (nodeName != null) {
            this.children().put(nodeName, nodeToAdd);
        }
    }

    @Override
    public Set<NodeSPI<K, V>> getChildrenDirect(boolean includeMarkedForRemoval) {
        if (includeMarkedForRemoval) {
            if (this.children != null && !this.children.isEmpty()) {
                return Immutables.immutableSetConvert(this.children.values());
            }
            return Collections.emptySet();
        }
        return this.getChildrenDirect();
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Fqn f) {
        return this.addChildDirect(f, true);
    }

    @Override
    public NodeSPI<K, V> getOrCreateChild(Object childName, GlobalTransaction gtx) {
        return this.getOrCreateChild(childName, gtx, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsRemoved(boolean marker, boolean recursive) {
        this.setFlag(AbstractNode.NodeFlags.REMOVED, marker);
        if (recursive && this.children != null) {
            PessimisticUnversionedNode pessimisticUnversionedNode = this;
            synchronized (pessimisticUnversionedNode) {
                for (Node child : this.children().values()) {
                    ((NodeSPI)child).markAsDeleted(marker, true);
                }
            }
        }
    }

    @Override
    public void setValid(boolean valid, boolean recursive) {
        this.setFlag(AbstractNode.NodeFlags.VALID, valid);
        if (trace) {
            log.trace("Marking node " + this.getFqn() + " as " + (valid ? "" : "in") + "valid");
        }
        if (recursive) {
            for (Node child : this.children().values()) {
                ((NodeSPI)child).setValid(valid, recursive);
            }
        }
    }

    @Override
    protected void printDetailsInMap(StringBuilder sb, int indent) {
        this.printIndent(sb, indent);
        indent += 2;
        sb.append("/");
        if (!this.fqn.isRoot()) {
            sb.append(this.fqn.getLastElement());
        }
        sb.append("  ");
        sb.append(this.data);
        for (Node n : this.children().values()) {
            sb.append("\n");
            ((NodeSPI)n).printDetails(sb, indent);
        }
    }

    @Override
    public void setFqn(Fqn fqn) {
        if (trace) {
            log.trace(this.getFqn() + " set FQN " + fqn);
        }
        this.fqn = fqn;
        if (this.children == null) {
            return;
        }
        for (Map.Entry me : this.children().entrySet()) {
            NodeSPI n = (NodeSPI)me.getValue();
            Fqn<Object> cfqn = Fqn.fromRelativeElements(fqn, me.getKey());
            n.setFqn(cfqn);
        }
    }

    @Override
    public void releaseObjectReferences(boolean recursive) {
        if (recursive && this.children != null) {
            for (Node child : this.children().values()) {
                child.releaseObjectReferences(recursive);
            }
        }
        if (this.data != null) {
            for (Object key : this.data.keySet()) {
                Object value = this.data.get(key);
                if (key instanceof MarshalledValue) {
                    ((MarshalledValue)key).compact(true, true);
                }
                if (!(value instanceof MarshalledValue)) continue;
                ((MarshalledValue)value).compact(true, true);
            }
        }
    }
}

