/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpirationAlgorithm
extends BaseEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(ExpirationAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();
    private ExpirationAlgorithmConfig config;
    private SortedSet<ExpirationEntry> set = new TreeSet<ExpirationEntry>();

    private void addEvictionEntry(EvictionEvent node) {
        Fqn fqn = node.getFqn();
        this.addEvictionEntry(fqn);
    }

    private void addEvictionEntry(Fqn fqn) {
        Long l = this.getExpiration(fqn);
        if (l == null) {
            return;
        }
        if (l == -1L) {
            if (this.config.isWarnNoExpirationKey() && log.isWarnEnabled()) {
                log.warn("No expiration key '" + this.config.getExpirationKeyName() + "' for Node: " + fqn);
            } else if (log.isDebugEnabled()) {
                log.debug("No expiration key for Node: " + fqn);
            }
        } else {
            this.setExpiration(fqn, l);
        }
    }

    private void setExpiration(Fqn fqn, Long l) {
        ExpirationEntry ee = new ExpirationEntry(fqn, l);
        if (trace) {
            log.trace("adding eviction entry: " + ee);
        }
        this.set.add(ee);
    }

    private Long getExpiration(Fqn fqn) {
        NodeSPI n = this.cache.peek(fqn, false);
        if (n == null) {
            return null;
        }
        Long expiration = (Long)n.getDirect(this.config.getExpirationKeyName());
        if (expiration == null) {
            return -1L;
        }
        return expiration;
    }

    @Override
    protected void processQueues(BlockingQueue<EvictionEvent> queue) throws EvictionException {
        EvictionEvent node;
        int count = 0;
        block6: while ((node = this.getNextInQueue(queue)) != null) {
            ++count;
            switch (node.getEventType()) {
                case ADD_NODE_EVENT: 
                case ADD_ELEMENT_EVENT: {
                    this.addEvictionEntry(node);
                    continue block6;
                }
                case REMOVE_ELEMENT_EVENT: 
                case REMOVE_NODE_EVENT: 
                case UNMARK_USE_EVENT: {
                    continue block6;
                }
                case VISIT_NODE_EVENT: {
                    continue block6;
                }
                case MARK_IN_USE_EVENT: {
                    this.markInUse(node);
                    continue block6;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + (Object)((Object)node.getEventType()));
        }
        if (trace) {
            log.trace("processed " + count + " node events in region: " + this.regionFqn);
        }
    }

    private void markInUse(EvictionEvent node) {
        long expiration = node.getInUseTimeout() + System.currentTimeMillis();
        this.setExpiration(node.getFqn(), expiration);
    }

    @Override
    protected void prune() throws EvictionException {
        if (this.set.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        int max = this.config.getMaxNodes();
        Iterator i = this.set.iterator();
        while (i.hasNext()) {
            ExpirationEntry ee = (ExpirationEntry)i.next();
            Long ce = this.getExpiration(ee.getFqn());
            if (ce == null || ce == -1L || ce > ee.getExpiration()) {
                i.remove();
                continue;
            }
            if (ee.getExpiration() >= now && (max == -1 || this.set.size() <= max)) break;
            i.remove();
            this.evictCacheNode(ee.getFqn());
        }
        if (max != -1 && this.set.size() > max) {
            log.warn("Unable to remove nodes to reduce region size below " + this.config.getMaxNodes() + ".  " + "Set expiration for nodes in this region");
        }
    }

    @Override
    public void resetEvictionQueue() {
        for (ExpirationEntry ee : this.set) {
            this.addEvictionEntry(ee.getFqn());
        }
    }

    @Override
    protected EvictionQueue setupEvictionQueue() throws EvictionException {
        this.config = (ExpirationAlgorithmConfig)this.evictionAlgorithmConfig;
        return new DummyEvictionQueue();
    }

    @Override
    protected boolean shouldEvictNode(NodeEntry ne) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canIgnoreEvent(EvictionEvent.Type eventType) {
        return eventType == EvictionEvent.Type.VISIT_NODE_EVENT;
    }

    @Override
    public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
        return ExpirationAlgorithmConfig.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DummyEvictionQueue
    implements EvictionQueue {
        DummyEvictionQueue() {
        }

        @Override
        public void addNodeEntry(NodeEntry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ExpirationAlgorithm.this.set.clear();
        }

        @Override
        public boolean containsNodeEntry(NodeEntry entry) {
            return false;
        }

        @Override
        public NodeEntry getFirstNodeEntry() {
            return null;
        }

        @Override
        public NodeEntry getNodeEntry(Fqn fqn) {
            return null;
        }

        @Override
        public NodeEntry getNodeEntry(String fqn) {
            return null;
        }

        @Override
        public int getNumberOfElements() {
            return ExpirationAlgorithm.this.set.size();
        }

        @Override
        public int getNumberOfNodes() {
            return ExpirationAlgorithm.this.set.size();
        }

        @Override
        public Iterator<NodeEntry> iterator() {
            return null;
        }

        @Override
        public void modifyElementCount(int difference) {
        }

        @Override
        public void removeNodeEntry(NodeEntry entry) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExpirationEntry
    implements Comparable<ExpirationEntry> {
        private long expiration;
        private Fqn fqn;

        public ExpirationEntry(Fqn fqn) {
            this.fqn = fqn;
        }

        public ExpirationEntry(Fqn fqn, long expiration) {
            this.fqn = fqn;
            this.expiration = expiration;
        }

        @Override
        public int compareTo(ExpirationEntry ee) {
            long n = this.expiration - ee.expiration;
            if (n < 0L) {
                return -1;
            }
            if (n > 0L) {
                return 1;
            }
            return this.fqn.compareTo(ee.fqn);
        }

        public long getExpiration() {
            return this.expiration;
        }

        public Fqn getFqn() {
            return this.fqn;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExpirationEntry)) {
                return false;
            }
            ExpirationEntry ee = (ExpirationEntry)o;
            return this.expiration == ee.expiration && this.fqn.equals(ee.fqn);
        }

        public int hashCode() {
            return (int)this.expiration ^ this.fqn.hashCode();
        }

        public String toString() {
            long now = System.currentTimeMillis();
            long ttl = this.expiration - now;
            String sttl = ttl > 60000L ? ttl / 60000L + "min" : (ttl > 1000L ? ttl / 1000L + "s" : ttl + "ms");
            return "EE fqn=" + this.fqn + " ttl=" + sttl;
        }
    }
}

