/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUAlgorithm
extends BaseEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(LRUAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected EvictionQueue setupEvictionQueue() throws EvictionException {
        return new LRUQueue();
    }

    @Override
    protected boolean shouldEvictNode(NodeEntry entry) {
        LRUAlgorithmConfig config = (LRUAlgorithmConfig)this.evictionAlgorithmConfig;
        if (this.isYoungerThanMinimumTimeToLive(entry)) {
            if (trace) {
                log.trace("Do not evict - is younger than minimum TTL");
            }
            return false;
        }
        if (config.getTimeToLive() < 0L && config.getMaxAge() < 0L) {
            log.trace("No idle or max time limit!");
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (config.getTimeToLive() > -1L) {
            long idleTime = currentTime - entry.getModifiedTimeStamp();
            if (trace) {
                log.trace("Node " + entry.getFqn() + " has been idle for " + idleTime + "ms");
            }
            if (idleTime >= config.getTimeToLive()) {
                if (trace) {
                    log.trace("Node " + entry.getFqn() + " should be evicted because of idle time");
                    log.trace("Time to live in millies is: " + config.getTimeToLive());
                    log.trace("Config instance is: " + System.identityHashCode(config));
                }
                return true;
            }
        }
        if (config.getMaxAge() > -1L) {
            long objectLifeTime = currentTime - entry.getCreationTimeStamp();
            if (trace) {
                log.trace("Node " + entry.getFqn() + " has been alive for " + objectLifeTime + "ms");
            }
            if (objectLifeTime >= config.getMaxAge()) {
                if (trace) {
                    log.trace("Node " + entry.getFqn() + " should be evicted because of max age");
                }
                return true;
            }
        }
        if (trace) {
            log.trace("Node " + entry.getFqn() + " should not be evicted");
        }
        return false;
    }

    @Override
    protected void evict(NodeEntry ne) {
        if (trace) {
            if (ne == null) {
                log.trace("Got a NULL node entry!");
            } else {
                log.trace("About to evict " + ne.getFqn());
            }
        }
        if (ne != null && !this.evictCacheNode(ne.getFqn())) {
            try {
                if (trace) {
                    log.trace("Could not evict " + ne.getFqn() + " so adding to recycle queue");
                }
                this.recycleQueue.put(ne.getFqn());
            }
            catch (InterruptedException e) {
                log.debug("InterruptedException", e);
            }
        }
    }

    @Override
    protected void prune() throws EvictionException {
        int maxNodes;
        NodeEntry ne;
        LRUQueue lruQueue = (LRUQueue)this.evictionQueue;
        Iterator<NodeEntry> it = lruQueue.iterateLRUQueue();
        while (it.hasNext()) {
            ne = it.next();
            if (this.isNodeInUseAndNotTimedOut(ne)) continue;
            if (!this.shouldEvictNode(ne)) break;
            it.remove();
            lruQueue.removeNodeEntryFromMaxAge(ne);
            this.evict(ne);
        }
        it = lruQueue.iterateMaxAgeQueue();
        while (it.hasNext()) {
            ne = it.next();
            if (this.isNodeInUseAndNotTimedOut(ne)) continue;
            if (!this.shouldEvictNode(ne)) break;
            it.remove();
            lruQueue.removeNodeEntryFromLRU(ne);
            this.evict(ne);
        }
        if ((maxNodes = ((LRUAlgorithmConfig)this.evictionAlgorithmConfig).getMaxNodes()) < 0) {
            return;
        }
        it = lruQueue.iterateLRUQueue();
        while (this.evictionQueue.getNumberOfNodes() > maxNodes) {
            ne = it.next();
            if (trace) {
                log.trace("Node " + ne.getFqn() + " will be evicted because of exceeding the maxNode limit." + " maxNode: " + maxNodes + " but current queue size is: " + this.evictionQueue.getNumberOfNodes());
            }
            if (this.isNodeInUseAndNotTimedOut(ne)) continue;
            it.remove();
            lruQueue.removeNodeEntryFromMaxAge(ne);
            this.evict(ne);
        }
    }

    @Override
    public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
        return LRUAlgorithmConfig.class;
    }
}

