/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.ContextObjectInputStream;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Queue;
import org.jgroups.util.Range;
import org.jgroups.util.Streamable;
import org.jgroups.util.UnmodifiableVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static NumberFormat f;
    private static Map PRIMITIVE_TYPES;
    private static final byte TYPE_NULL = 0;
    private static final byte TYPE_STREAMABLE = 1;
    private static final byte TYPE_SERIALIZABLE = 2;
    private static final byte TYPE_BOOLEAN = 10;
    private static final byte TYPE_BYTE = 11;
    private static final byte TYPE_CHAR = 12;
    private static final byte TYPE_DOUBLE = 13;
    private static final byte TYPE_FLOAT = 14;
    private static final byte TYPE_INT = 15;
    private static final byte TYPE_LONG = 16;
    private static final byte TYPE_SHORT = 17;
    private static final byte TYPE_STRING = 18;
    public static final int MAX_PORT = 65535;
    static boolean resolve_dns;
    static boolean JGROUPS_COMPAT;
    private static ThreadGroup GLOBAL_GROUP;

    public static ThreadGroup getGlobalThreadGroup() {
        return GLOBAL_GROUP;
    }

    public static void checkBufferSize(String buf_name, long val) {
        long max_mem = Runtime.getRuntime().maxMemory();
        if (val > max_mem) {
            throw new IllegalArgumentException(buf_name + "(" + Util.printBytes(val) + ") exceeds max memory allocated to VM (" + Util.printBytes(max_mem) + ")");
        }
    }

    public static int keyPress(String msg) {
        System.out.println(msg);
        try {
            return System.in.read();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static void close(InputStream inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(DatagramSocket my_sock) {
        if (my_sock != null) {
            try {
                my_sock.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Channel ch) {
        if (ch != null) {
            try {
                ch.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Channel ... channels) {
        if (channels != null) {
            for (Channel ch : channels) {
                Util.close(ch);
            }
        }
    }

    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        if (JGROUPS_COMPAT) {
            return Util.oldObjectFromByteBuffer(buffer);
        }
        return Util.objectFromByteBuffer(buffer, 0, buffer.length);
    }

    /*
     * Exception decompiling
     */
    public static Object objectFromByteBuffer(byte[] buffer, int offset, int length) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        OutputStream out;
        ByteArrayOutputStream out_stream;
        byte[] result;
        block21: {
            if (JGROUPS_COMPAT) {
                return Util.oldObjectToByteBuffer(obj);
            }
            result = null;
            out_stream = new ByteArrayOutputStream(512);
            if (obj == null) {
                out_stream.write(0);
                out_stream.flush();
                return out_stream.toByteArray();
            }
            out = null;
            try {
                if (obj instanceof Streamable) {
                    out_stream.write(1);
                    out = new DataOutputStream(out_stream);
                    Util.writeGenericStreamable((Streamable)obj, (DataOutputStream)out);
                    break block21;
                }
                Byte type = (Byte)PRIMITIVE_TYPES.get(obj.getClass());
                if (type != null) {
                    out_stream.write(type.byteValue());
                    out = new DataOutputStream(out_stream);
                    switch (type) {
                        case 10: {
                            ((DataOutputStream)out).writeBoolean((Boolean)obj);
                            break;
                        }
                        case 11: {
                            ((DataOutputStream)out).writeByte(((Byte)obj).byteValue());
                            break;
                        }
                        case 12: {
                            ((DataOutputStream)out).writeChar(((Character)obj).charValue());
                            break;
                        }
                        case 13: {
                            ((DataOutputStream)out).writeDouble((Double)obj);
                            break;
                        }
                        case 14: {
                            ((DataOutputStream)out).writeFloat(((Float)obj).floatValue());
                            break;
                        }
                        case 15: {
                            ((DataOutputStream)out).writeInt((Integer)obj);
                            break;
                        }
                        case 16: {
                            ((DataOutputStream)out).writeLong((Long)obj);
                            break;
                        }
                        case 17: {
                            ((DataOutputStream)out).writeShort(((Short)obj).shortValue());
                            break;
                        }
                        case 18: {
                            String str = (String)obj;
                            if (str.length() > Short.MAX_VALUE) {
                                ((DataOutputStream)out).writeBoolean(true);
                                ObjectOutputStream oos = new ObjectOutputStream(out);
                                try {
                                    oos.writeObject(str);
                                    break block21;
                                }
                                finally {
                                    oos.close();
                                }
                            }
                            ((DataOutputStream)out).writeBoolean(false);
                            ((DataOutputStream)out).writeUTF(str);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("type " + type + " is invalid");
                        }
                    }
                    break block21;
                }
                out_stream.write(2);
                out = new ObjectOutputStream(out_stream);
                ((ObjectOutputStream)out).writeObject(obj);
            }
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
        }
        Util.close(out);
        result = out_stream.toByteArray();
        return result;
    }

    public static Object oldObjectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        return Util.oldObjectFromByteBuffer(buffer, 0, buffer.length);
    }

    public static Object oldObjectFromByteBuffer(byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        Object retval = null;
        try {
            ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer, offset, length);
            ContextObjectInputStream in = new ContextObjectInputStream(in_stream);
            retval = in.readObject();
            in.close();
        }
        catch (StreamCorruptedException sce) {
            try {
                ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer, offset, length);
                DataInputStream in = new DataInputStream(in_stream);
                retval = Util.readGenericStreamable(in);
                in.close();
            }
            catch (Exception ee) {
                IOException tmp = new IOException("unmarshalling failed");
                tmp.initCause(ee);
                throw tmp;
            }
        }
        if (retval == null) {
            return null;
        }
        return retval;
    }

    public static byte[] oldObjectToByteBuffer(Object obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
        if (obj instanceof Streamable) {
            DataOutputStream out = new DataOutputStream(out_stream);
            Util.writeGenericStreamable((Streamable)obj, out);
            out.close();
        } else {
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            out.close();
        }
        result = out_stream.toByteArray();
        return result;
    }

    public static Streamable streamableFromByteBuffer(Class cl, byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        Streamable retval = null;
        ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
        DataInputStream in = new DataInputStream(in_stream);
        retval = (Streamable)cl.newInstance();
        retval.readFrom(in);
        in.close();
        return retval;
    }

    public static Streamable streamableFromByteBuffer(Class cl, byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        Streamable retval = null;
        ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(in_stream);
        retval = (Streamable)cl.newInstance();
        retval.readFrom(in);
        in.close();
        return retval;
    }

    public static byte[] streamableToByteBuffer(Streamable obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(out_stream);
        obj.writeTo(out);
        result = out_stream.toByteArray();
        out.close();
        return result;
    }

    public static byte[] collectionToByteBuffer(Collection c) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(out_stream);
        Util.writeAddresses(c, out);
        result = out_stream.toByteArray();
        out.close();
        return result;
    }

    public static int size(Address addr) {
        int retval = 1;
        if (addr != null) {
            retval += addr.size() + 1;
        }
        return retval;
    }

    public static void writeAuthToken(AuthToken token, DataOutputStream out) throws IOException {
        Util.writeString(token.getName(), out);
        token.writeTo(out);
    }

    public static AuthToken readAuthToken(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        try {
            String type = Util.readString(in);
            Object obj = Class.forName(type).newInstance();
            AuthToken token = (AuthToken)obj;
            token.readFrom(in);
            return token;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static void writeAddress(Address addr, DataOutputStream out) throws IOException {
        if (addr == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (addr instanceof IpAddress) {
            out.writeBoolean(true);
            addr.writeTo(out);
        } else {
            out.writeBoolean(false);
            Util.writeOtherAddress(addr, out);
        }
    }

    public static Address readAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Address addr = null;
        if (!in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            addr = new IpAddress();
            addr.readFrom(in);
        } else {
            addr = Util.readOtherAddress(in);
        }
        return addr;
    }

    private static Address readOtherAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        ClassConfigurator conf;
        try {
            conf = ClassConfigurator.getInstance(false);
        }
        catch (ChannelException e) {
            IllegalAccessException new_ex = new IllegalAccessException();
            new_ex.initCause(e);
            throw new_ex;
        }
        int b = in.read();
        Class cl = null;
        if (b == 1) {
            short magic_number = in.readShort();
            cl = conf.get(magic_number);
        } else {
            String classname = in.readUTF();
            cl = conf.get(classname);
        }
        Address addr = (Address)cl.newInstance();
        addr.readFrom(in);
        return addr;
    }

    private static void writeOtherAddress(Address addr, DataOutputStream out) throws IOException {
        int magic_number;
        ClassConfigurator conf = null;
        try {
            conf = ClassConfigurator.getInstance(false);
        }
        catch (ChannelException e) {
            IOException new_ex = new IOException();
            new_ex.initCause(e);
            throw new_ex;
        }
        int n = magic_number = conf != null ? (int)conf.getMagicNumber(addr.getClass()) : -1;
        if (magic_number == -1) {
            out.write(0);
            out.writeUTF(addr.getClass().getName());
        } else {
            out.write(1);
            out.writeShort(magic_number);
        }
        addr.writeTo(out);
    }

    public static void writeAddresses(Collection v, DataOutputStream out) throws IOException {
        if (v == null) {
            out.writeShort(-1);
            return;
        }
        out.writeShort(v.size());
        for (Address addr : v) {
            Util.writeAddress(addr, out);
        }
    }

    public static Collection<Address> readAddresses(DataInputStream in, Class cl) throws IOException, IllegalAccessException, InstantiationException {
        int length = in.readShort();
        if (length < 0) {
            return null;
        }
        Collection retval = (Collection)cl.newInstance();
        for (int i = 0; i < length; ++i) {
            Address addr = Util.readAddress(in);
            retval.add(addr);
        }
        return retval;
    }

    public static long size(Collection addrs) {
        int retval = 2;
        if (addrs != null && !addrs.isEmpty()) {
            Address addr = (Address)addrs.iterator().next();
            retval += Util.size(addr) * addrs.size();
        }
        return retval;
    }

    public static void writeStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        obj.writeTo(out);
    }

    public static Streamable readStreamable(Class clazz, DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Streamable retval = null;
        if (!in.readBoolean()) {
            return null;
        }
        retval = (Streamable)clazz.newInstance();
        retval.readFrom(in);
        return retval;
    }

    public static void writeGenericStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.write(0);
            return;
        }
        try {
            out.write(1);
            short magic_number = ClassConfigurator.getInstance(false).getMagicNumber(obj.getClass());
            if (magic_number == -1) {
                out.writeBoolean(false);
                String classname = obj.getClass().getName();
                out.writeUTF(classname);
            } else {
                out.writeBoolean(true);
                out.writeShort(magic_number);
            }
            obj.writeTo(out);
        }
        catch (ChannelException e) {
            throw new IOException("failed writing object of type " + obj.getClass() + " to stream: " + e.toString());
        }
    }

    public static Streamable readGenericStreamable(DataInputStream in) throws IOException {
        Streamable retval = null;
        int b = in.read();
        if (b == 0) {
            return null;
        }
        boolean use_magic_number = in.readBoolean();
        try {
            Class clazz;
            if (use_magic_number) {
                short magic_number = in.readShort();
                clazz = ClassConfigurator.getInstance(false).get(magic_number);
                if (clazz == null) {
                    throw new ClassNotFoundException("Class for magic number " + magic_number + " cannot be found.");
                }
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.getInstance(false).get(classname);
                if (clazz == null) {
                    throw new ClassNotFoundException(classname);
                }
            }
            retval = (Streamable)clazz.newInstance();
            retval.readFrom(in);
            return retval;
        }
        catch (Exception ex) {
            throw new IOException("failed reading object: " + ex.toString());
        }
    }

    public static void writeObject(Object obj, DataOutputStream out) throws Exception {
        if (obj == null || !(obj instanceof Streamable)) {
            byte[] buf = Util.objectToByteBuffer(obj);
            out.writeShort(buf.length);
            out.write(buf, 0, buf.length);
        } else {
            out.writeShort(-1);
            Util.writeGenericStreamable((Streamable)obj, out);
        }
    }

    public static Object readObject(DataInputStream in) throws Exception {
        short len = in.readShort();
        Object retval = null;
        if (len == -1) {
            retval = Util.readGenericStreamable(in);
        } else {
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            retval = Util.objectFromByteBuffer(buf);
        }
        return retval;
    }

    public static void writeString(String s, DataOutputStream out) throws IOException {
        if (s != null) {
            out.write(1);
            out.writeUTF(s);
        } else {
            out.write(0);
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            return in.readUTF();
        }
        return null;
    }

    public static void writeByteBuffer(byte[] buf, DataOutputStream out) throws IOException {
        if (buf != null) {
            out.write(1);
            out.writeInt(buf.length);
            out.write(buf, 0, buf.length);
        } else {
            out.write(0);
        }
    }

    public static byte[] readByteBuffer(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            b = in.readInt();
            byte[] buf = new byte[b];
            in.read(buf, 0, buf.length);
            return buf;
        }
        return null;
    }

    public static Buffer messageToByteBuffer(Message msg) throws IOException {
        ExposedByteArrayOutputStream output = new ExposedByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(output);
        out.writeBoolean(msg != null);
        if (msg != null) {
            msg.writeTo(out);
        }
        out.flush();
        Buffer retval = new Buffer(output.getRawBuffer(), 0, output.size());
        out.close();
        output.close();
        return retval;
    }

    public static Message byteBufferToMessage(byte[] buffer, int offset, int length) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(input);
        if (!in.readBoolean()) {
            return null;
        }
        Message msg = new Message(false);
        msg.readFrom(in);
        return msg;
    }

    public static Buffer msgListToByteBuffer(List<Message> xmit_list) throws IOException {
        ExposedByteArrayOutputStream output = new ExposedByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(output);
        Buffer retval = null;
        out.writeInt(xmit_list.size());
        for (Message msg : xmit_list) {
            msg.writeTo(out);
        }
        out.flush();
        retval = new Buffer(output.getRawBuffer(), 0, output.size());
        out.close();
        output.close();
        return retval;
    }

    public static List<Message> byteBufferToMessageList(byte[] buffer, int offset, int length) throws Exception {
        LinkedList<Message> retval = null;
        ByteArrayInputStream input = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(input);
        int size = in.readInt();
        if (size == 0) {
            return null;
        }
        retval = new LinkedList<Message>();
        for (int i = 0; i < size; ++i) {
            Message msg = new Message(false);
            msg.readFrom(in);
            retval.add(msg);
        }
        return retval;
    }

    public static boolean match(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2.equals(obj1);
    }

    public static boolean match(long[] a1, long[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1 == a2) {
            return true;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sleep(long timeout, int nanos) {
        try {
            Thread.sleep(timeout, nanos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sleep(long msecs, boolean busy_sleep) {
        if (!busy_sleep) {
            Util.sleep(msecs);
            return;
        }
        long start = System.currentTimeMillis();
        long stop = start + msecs;
        while (stop > start) {
            start = System.currentTimeMillis();
        }
    }

    public static long random(long range) {
        return (long)(Math.random() * (double)range % (double)range) + 1L;
    }

    public static void sleepRandom(long timeout) {
        if (timeout <= 0L) {
            return;
        }
        long r = (int)(Math.random() * 100000.0 % (double)timeout) + 1;
        Util.sleep(r);
    }

    public static void sleepRandom(long floor, long ceiling) {
        if (ceiling - floor <= 0L) {
            return;
        }
        long diff = ceiling - floor;
        long r = (long)((int)(Math.random() * 100000.0 % (double)diff)) + floor;
        Util.sleep(r);
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        long r = Util.random(100L);
        return r < (cutoff = (long)(probability * 100.0));
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public static void dumpStack(boolean exit) {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (exit) {
                System.exit(0);
            }
            return;
        }
    }

    public static String dumpThreads() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] ids = bean.getAllThreadIds();
        ThreadInfo[] threads = bean.getThreadInfo(ids, 20);
        for (int i = 0; i < threads.length; ++i) {
            ThreadInfo info = threads[i];
            if (info == null) continue;
            sb.append(info.getThreadName()).append(":\n");
            StackTraceElement[] stack_trace = info.getStackTrace();
            for (int j = 0; j < stack_trace.length; ++j) {
                StackTraceElement el = stack_trace[j];
                sb.append("at ").append(el.getClassName()).append(".").append(el.getMethodName());
                sb.append("(").append(el.getFileName()).append(":").append(el.getLineNumber()).append(")");
                sb.append("\n");
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static boolean interruptAndWaitToDie(Thread t) {
        return Util.interruptAndWaitToDie(t, 300L);
    }

    public static boolean interruptAndWaitToDie(Thread t, long timeout) {
        if (t == null) {
            throw new IllegalArgumentException("Thread can not be null");
        }
        t.interrupt();
        try {
            t.join(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return t.isAlive();
    }

    public static String dumpQueue(Queue q) {
        StringBuilder sb = new StringBuilder();
        LinkedList values = q.values();
        if (values.isEmpty()) {
            sb.append("empty");
        } else {
            for (Object o : values) {
                String s = null;
                if (o instanceof Event) {
                    Event event = (Event)o;
                    int type = event.getType();
                    s = Event.type2String(type);
                    if (type == 6) {
                        s = s + " " + event.getArg();
                    }
                    if (type == 1) {
                        s = s + " " + event.getArg();
                    }
                    if (type == 1) {
                        s = s + "[";
                        Message m = (Message)event.getArg();
                        HashMap<String, Header> headers = new HashMap<String, Header>(m.getHeaders());
                        Iterator i = headers.keySet().iterator();
                        while (i.hasNext()) {
                            Object headerKey = i.next();
                            Object value = headers.get(headerKey);
                            String headerToString = null;
                            if (value instanceof FD.FdHeader) {
                                headerToString = value.toString();
                            } else if (value instanceof PingHeader) {
                                headerToString = headerKey + "-";
                                headerToString = ((PingHeader)value).type == 1 ? headerToString + "GMREQ" : (((PingHeader)value).type == 2 ? headerToString + "GMRSP" : headerToString + "UNKNOWN");
                            } else {
                                headerToString = headerKey + "-" + (value == null ? "null" : value.toString());
                            }
                            s = s + headerToString;
                            if (!i.hasNext()) continue;
                            s = s + ",";
                        }
                        s = s + "]";
                    }
                } else {
                    s = o.toString();
                }
                sb.append(s).append("\n");
            }
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        return s.toString();
    }

    public static String getStackTrace(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static String print(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static void crash() {
        System.exit(-1);
    }

    public static String printEvent(Event evt) {
        Message msg;
        if (evt.getType() == 1 && (msg = (Message)evt.getArg()) != null) {
            if (msg.getLength() > 0) {
                return Util.printMessage(msg);
            }
            return msg.printObjectHeaders();
        }
        return evt.toString();
    }

    public static String printMessage(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return null;
        }
        try {
            return msg.getObject().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String mapToString(Map<? extends Object, ? extends Object> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append("=");
            if (val == null) {
                sb.append("null");
            } else {
                sb.append(val);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String printMethodCall(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return "";
        }
        try {
            Object obj = msg.getObject();
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void printThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        System.out.println("------- Threads -------");
        for (int i = 0; i < threads.length; ++i) {
            System.out.println("#" + i + ": " + threads[i]);
        }
        System.out.println("------- Threads -------\n");
    }

    public static String activeThreads() {
        StringBuilder sb = new StringBuilder();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        sb.append("------- Threads -------\n");
        for (int i = 0; i < threads.length; ++i) {
            sb.append("#").append(i).append(": ").append(threads[i]).append('\n');
        }
        sb.append("------- Threads -------\n");
        return sb.toString();
    }

    public static String printBytes(long bytes) {
        if (bytes < 1000L) {
            return bytes + "b";
        }
        if (bytes < 1000000L) {
            double tmp = (double)bytes / 1000.0;
            return f.format(tmp) + "KB";
        }
        if (bytes < 1000000000L) {
            double tmp = (double)bytes / 1000000.0;
            return f.format(tmp) + "MB";
        }
        double tmp = (double)bytes / 1.0E9;
        return f.format(tmp) + "GB";
    }

    public static String printBytes(double bytes) {
        if (bytes < 1000.0) {
            return bytes + "b";
        }
        if (bytes < 1000000.0) {
            double tmp = bytes / 1000.0;
            return f.format(tmp) + "KB";
        }
        if (bytes < 1.0E9) {
            double tmp = bytes / 1000000.0;
            return f.format(tmp) + "MB";
        }
        double tmp = bytes / 1.0E9;
        return f.format(tmp) + "GB";
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size, int length) {
        int tmp_size = 0;
        int index = 0;
        int num_frags = length % frag_size == 0 ? length / frag_size : length / frag_size + 1;
        byte[][] retval = new byte[num_frags][];
        for (int accumulated_size = 0; accumulated_size < length; accumulated_size += tmp_size) {
            tmp_size = accumulated_size + frag_size <= length ? frag_size : length - accumulated_size;
            byte[] fragment = new byte[tmp_size];
            System.arraycopy(buf, accumulated_size, fragment, 0, tmp_size);
            retval[index++] = fragment;
        }
        return retval;
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size) {
        return Util.fragmentBuffer(buf, frag_size, buf.length);
    }

    public static List computeFragOffsets(int offset, int length, int frag_size) {
        ArrayList<Range> retval = new ArrayList<Range>();
        long total_size = length + offset;
        int index = offset;
        int tmp_size = 0;
        while ((long)index < total_size) {
            tmp_size = (long)(index + frag_size) <= total_size ? frag_size : (int)(total_size - (long)index);
            Range r = new Range(index, tmp_size);
            retval.add(r);
            index += tmp_size;
        }
        return retval;
    }

    public static List computeFragOffsets(byte[] buf, int frag_size) {
        return Util.computeFragOffsets(0, buf.length, frag_size);
    }

    public static byte[] defragmentBuffer(byte[][] fragments) {
        int i;
        int total_length = 0;
        int index = 0;
        if (fragments == null) {
            return null;
        }
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            total_length += fragments[i].length;
        }
        byte[] ret = new byte[total_length];
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            System.arraycopy(fragments[i], 0, ret, index, fragments[i].length);
            index += fragments[i].length;
        }
        return ret;
    }

    public static void printFragments(byte[][] frags) {
        for (int i = 0; i < frags.length; ++i) {
            System.out.println('\'' + new String(frags[i]) + '\'');
        }
    }

    public static <T> String printListWithDelimiter(Collection<T> list, String delimiter) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (T el : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(el);
        }
        return sb.toString();
    }

    public static String array2String(long[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(short[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(int[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(boolean[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(Object[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static boolean all(Collection c, Object obj) {
        for (Object o : c) {
            if (o.equals(obj)) continue;
            return false;
        }
        return true;
    }

    public static Vector pickSubset(Vector members, double subset_percentage) {
        Vector ret = new Vector();
        int num_mbrs = members.size();
        if (num_mbrs == 0) {
            return ret;
        }
        int subset_size = (int)Math.ceil((double)num_mbrs * subset_percentage);
        Vector tmp_mbrs = (Vector)members.clone();
        for (int i = subset_size; i > 0 && !tmp_mbrs.isEmpty(); --i) {
            int index = (int)(Math.random() * (double)num_mbrs % (double)tmp_mbrs.size());
            ret.addElement(tmp_mbrs.elementAt(index));
            tmp_mbrs.removeElementAt(index);
        }
        return ret;
    }

    public static Object pickRandomElement(List list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        int index = (int)(Math.random() * (double)size * 10.0 % (double)size);
        return list.get(index);
    }

    public static Object pickRandomElement(Object[] array) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        int index = (int)(Math.random() * (double)size * 10.0 % (double)size);
        return array[index];
    }

    public static Vector<Address> determineLeftMembers(Vector<Address> old_mbrs, Vector<Address> new_mbrs) {
        Vector<Address> retval = new Vector<Address>();
        if (old_mbrs == null || new_mbrs == null) {
            return retval;
        }
        for (int i = 0; i < old_mbrs.size(); ++i) {
            Address mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            retval.addElement(mbr);
        }
        return retval;
    }

    public static String printMembers(Vector v) {
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                Object el = v.elementAt(i);
                sb.append(el);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static String printPingRsps(List<PingRsp> rsps) {
        StringBuilder sb = new StringBuilder();
        if (rsps != null) {
            int total = rsps.size();
            int servers = 0;
            int clients = 0;
            int coords = 0;
            for (PingRsp rsp : rsps) {
                if (rsp.isCoord()) {
                    ++coords;
                }
                if (rsp.isServer()) {
                    ++servers;
                    continue;
                }
                ++clients;
            }
            sb.append(total + " total (" + servers + " servers (" + coords + " coord), " + clients + " clients)");
        }
        return sb.toString();
    }

    public static void doubleWrite(byte[] buf, OutputStream out) throws Exception {
        if (buf.length > 1) {
            out.write(buf, 0, 1);
            out.write(buf, 1, buf.length - 1);
        } else {
            out.write(buf, 0, 0);
            out.write(buf);
        }
    }

    public static void doubleWrite(byte[] buf, int offset, int length, OutputStream out) throws Exception {
        if (length > 1) {
            out.write(buf, offset, 1);
            out.write(buf, offset + 1, length - 1);
        } else {
            out.write(buf, offset, 0);
            out.write(buf, offset, length);
        }
    }

    public static void writeFully(ByteBuffer buf, WritableByteChannel out) throws IOException {
        int toWrite = buf.limit();
        for (int written = 0; written < toWrite; written += out.write(buf)) {
        }
    }

    public static long sizeOf(String classname) {
        try {
            Object inst = Util.loadClass(classname, null).newInstance();
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static long sizeOf(Object inst) {
        try {
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static int sizeOf(Streamable inst) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(output);
            inst.writeTo(out);
            out.flush();
            byte[] data = output.toByteArray();
            return data.length;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static Class loadClass(String classname, Class clazz) throws ClassNotFoundException {
        ClassLoader loader;
        try {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                return loader.loadClass(classname);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                loader = clazz.getClassLoader();
                if (loader != null) {
                    return loader.loadClass(classname);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            loader = ClassLoader.getSystemClassLoader();
            if (loader != null) {
                return loader.loadClass(classname);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new ClassNotFoundException(classname);
    }

    public static InputStream getResourceAsStream(String name, Class clazz) {
        ClassLoader loader;
        InputStream retval = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null && (retval = loader.getResourceAsStream(name)) != null) {
                return retval;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                loader = clazz.getClassLoader();
                if (loader != null && (retval = loader.getResourceAsStream(name)) != null) {
                    return retval;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            loader = ClassLoader.getSystemClassLoader();
            if (loader != null) {
                return loader.getResourceAsStream(name);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return retval;
    }

    public static boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    public static boolean fileExists(String fname) {
        return new File(fname).exists();
    }

    public static long[] parseCommaDelimitedLongs(String s) {
        Vector<Long> v = new Vector<Long>();
        long[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Long l = new Long(tok.nextToken());
            v.addElement(l);
        }
        if (v.isEmpty()) {
            return null;
        }
        retval = new long[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retval[i] = (Long)v.elementAt(i);
        }
        return retval;
    }

    public static List<String> parseCommaDelimitedStrings(String l) {
        return Util.parseStringList(l, ",");
    }

    public static List<String> parseStringList(String l, String separator) {
        LinkedList<String> tmp = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(l, separator);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t.trim());
        }
        return tmp;
    }

    public static int parseInt(Properties props, String property, int defaultValue) {
        int result = defaultValue;
        String str = props.getProperty(property);
        if (str != null) {
            result = Integer.parseInt(str);
            props.remove(property);
        }
        return result;
    }

    public static long parseLong(Properties props, String property, long defaultValue) {
        long result = defaultValue;
        String str = props.getProperty(property);
        if (str != null) {
            result = Integer.parseInt(str);
            props.remove(property);
        }
        return result;
    }

    public static boolean parseBoolean(Properties props, String property, boolean defaultValue) {
        boolean result = defaultValue;
        String str = props.getProperty(property);
        if (str != null) {
            result = str.equalsIgnoreCase("true");
            props.remove(property);
        }
        return result;
    }

    public static InetAddress parseBindAddress(Properties props, String property) throws UnknownHostException {
        InetAddress bind_addr = null;
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        String str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        if (str != null) {
            bind_addr = InetAddress.getByName(str);
            props.remove(property);
        }
        return bind_addr;
    }

    public static List<NetworkInterface> parseInterfaceList(String s) throws Exception {
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>(10);
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String interface_name = tok.nextToken();
            NetworkInterface intf = NetworkInterface.getByName(interface_name);
            if (intf == null) {
                intf = NetworkInterface.getByInetAddress(InetAddress.getByName(interface_name));
            }
            if (intf == null) {
                throw new Exception("interface " + interface_name + " not found");
            }
            if (interfaces.contains(intf)) continue;
            interfaces.add(intf);
        }
        return interfaces;
    }

    public static String print(List<NetworkInterface> interfaces) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (NetworkInterface intf : interfaces) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(intf.getName());
        }
        return sb.toString();
    }

    public static String shortName(String hostname) {
        StringBuilder sb = new StringBuilder();
        if (hostname == null) {
            return null;
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index));
        } else {
            sb.append(hostname);
        }
        return sb.toString();
    }

    public static String shortName(InetAddress hostname) {
        if (hostname == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (resolve_dns) {
            sb.append(hostname.getHostName());
        } else {
            sb.append(hostname.getHostAddress());
        }
        return sb.toString();
    }

    public static boolean startFlush(Channel c, List<Address> flushParticipants, int numberOfAttempts, long randomSleepTimeoutFloor, long randomSleepTimeoutCeiling) {
        boolean successfulFlush = false;
        for (int attemptCount = 0; attemptCount < numberOfAttempts && !(successfulFlush = c.startFlush(flushParticipants, false)); ++attemptCount) {
            Util.sleepRandom(randomSleepTimeoutFloor, randomSleepTimeoutCeiling);
        }
        return successfulFlush;
    }

    public static boolean startFlush(Channel c, List<Address> flushParticipants) {
        return Util.startFlush(c, flushParticipants, 4, 1000L, 5000L);
    }

    public static boolean startFlush(Channel c, int numberOfAttempts, long randomSleepTimeoutFloor, long randomSleepTimeoutCeiling) {
        boolean successfulFlush = false;
        for (int attemptCount = 0; attemptCount < numberOfAttempts && !(successfulFlush = c.startFlush(false)); ++attemptCount) {
            Util.sleepRandom(randomSleepTimeoutFloor, randomSleepTimeoutCeiling);
        }
        return successfulFlush;
    }

    public static boolean startFlush(Channel c) {
        return Util.startFlush(c, 4, 1000L, 5000L);
    }

    public static ServerSocket createServerSocket(int start_port) throws IOException {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            break;
        }
        if (ret == null) {
            throw new IOException("Could not create server socket, start port:" + start_port);
        }
        return ret;
    }

    public static ServerSocket createServerSocket(InetAddress bind_addr, int start_port) throws IOException {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port, 50, bind_addr);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            break;
        }
        if (ret == null) {
            throw new IOException("Could not create server socket, start port:" + start_port);
        }
        return ret;
    }

    public static DatagramSocket createDatagramSocket(InetAddress addr, int port) throws Exception {
        DatagramSocket sock = null;
        if (addr == null) {
            if (port == 0) {
                return new DatagramSocket();
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        } else {
            if (port == 0) {
                port = 1024;
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port, addr);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        if (sock == null) {
            throw new IOException("Could not create udp socket, port = " + port);
        }
        return sock;
    }

    public static MulticastSocket createMulticastSocket(int port) throws IOException {
        return Util.createMulticastSocket(null, port, null);
    }

    public static MulticastSocket createMulticastSocket(InetAddress mcast_addr, int port, Log log) throws IOException {
        MulticastSocket retval;
        block5: {
            if (mcast_addr != null && !mcast_addr.isMulticastAddress()) {
                if (log != null && log.isWarnEnabled()) {
                    log.warn("mcast_addr (" + mcast_addr + ") is not a multicast address, will be ignored");
                }
                return new MulticastSocket(port);
            }
            InetSocketAddress saddr = new InetSocketAddress(mcast_addr, port);
            retval = null;
            try {
                retval = new MulticastSocket(saddr);
            }
            catch (IOException ex) {
                if (log == null || !log.isWarnEnabled()) break block5;
                StringBuilder sb = new StringBuilder();
                String type = mcast_addr != null ? (mcast_addr instanceof Inet4Address ? "IPv4" : "IPv6") : "n/a";
                sb.append("could not bind to " + mcast_addr + " (" + type + " address)");
                sb.append("; make sure your mcast_addr is of the same type as the preferred IP stack (IPv4 or IPv6)");
                sb.append(" by checking the value of the system properties java.net.preferIPv4Stack and java.net.preferIPv6Addresses.");
                sb.append("\nWill ignore mcast_addr, but this may lead to cross talking (see http://www.jboss.com/wiki/Edit.jsp?page=CrossTalking for details). ");
                sb.append("\nException was: " + ex);
                log.warn(sb);
            }
        }
        if (retval == null) {
            retval = new MulticastSocket(port);
        }
        return retval;
    }

    public static InetAddress getBindAddress(Properties props) throws UnknownHostException, SocketException {
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        String bind_addr = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        String bind_interface = Util.getProperty(new String[]{"jgroups.bind_interface", null}, props, "bind_interface", ignore_systemprops, null);
        InetAddress retval = null;
        InetAddress bind_addr_host = null;
        if (bind_addr != null) {
            bind_addr_host = InetAddress.getByName(bind_addr);
        }
        if (bind_interface != null) {
            NetworkInterface intf = NetworkInterface.getByName(bind_interface);
            if (intf != null) {
                Enumeration<InetAddress> addresses = intf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (bind_addr == null) {
                        retval = addr;
                    } else if (bind_addr_host != null) {
                        if (!bind_addr_host.equals(addr)) continue;
                        retval = addr;
                    } else {
                        if (!addr.getHostAddress().trim().equalsIgnoreCase(bind_addr)) continue;
                        retval = addr;
                    }
                    break;
                }
            } else {
                throw new UnknownHostException("network interface " + bind_interface + " not found");
            }
        }
        if (retval == null) {
            retval = bind_addr != null ? InetAddress.getByName(bind_addr) : InetAddress.getLocalHost();
        }
        props.remove("bind_addr");
        props.remove("bind_interface");
        return retval;
    }

    public static boolean checkForLinux() {
        return Util.checkForPresence("os.name", "linux");
    }

    public static boolean checkForHp() {
        return Util.checkForPresence("os.name", "hp");
    }

    public static boolean checkForSolaris() {
        return Util.checkForPresence("os.name", "sun");
    }

    public static boolean checkForWindows() {
        return Util.checkForPresence("os.name", "win");
    }

    private static boolean checkForPresence(String key, String value) {
        try {
            String tmp = System.getProperty(key);
            return tmp != null && tmp.trim().toLowerCase().startsWith(value);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void prompt(String s) {
        System.out.println(s);
        System.out.flush();
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        int retval = 0;
        if (version != null) {
            if (version.startsWith("1.2")) {
                return 12;
            }
            if (version.startsWith("1.3")) {
                return 13;
            }
            if (version.startsWith("1.4")) {
                return 14;
            }
            if (version.startsWith("1.5")) {
                return 15;
            }
            if (version.startsWith("5")) {
                return 15;
            }
            if (version.startsWith("1.6")) {
                return 16;
            }
            if (version.startsWith("6")) {
                return 16;
            }
        }
        return retval;
    }

    public static <T> Vector<T> unmodifiableVector(Vector<? extends T> v) {
        if (v == null) {
            return null;
        }
        return new UnmodifiableVector(v);
    }

    public static String memStats(boolean gc) {
        StringBuilder sb = new StringBuilder();
        Runtime rt = Runtime.getRuntime();
        if (gc) {
            rt.gc();
        }
        long free_mem = rt.freeMemory();
        long total_mem = rt.totalMemory();
        long used_mem = total_mem - free_mem;
        sb.append("Free mem: ").append(free_mem).append("\nUsed mem: ").append(used_mem);
        sb.append("\nTotal mem: ").append(total_mem);
        return sb.toString();
    }

    public static InetAddress getFirstNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        boolean preferIpv4 = Boolean.getBoolean("java.net.preferIPv4Stack");
        boolean preferIPv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public static InetAddress getFirstNonLoopbackIPv6Address() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress() || addr instanceof Inet4Address || !(addr instanceof Inet6Address)) continue;
                return addr;
            }
        }
        return null;
    }

    public static List<NetworkInterface> getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> retval = new ArrayList<NetworkInterface>(10);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            retval.add(intf);
        }
        return retval;
    }

    public static String getProperty(String[] system_props, Properties props, String prop_name, boolean ignore_sysprops, String default_value) {
        String retval = null;
        if (props != null && prop_name != null) {
            retval = props.getProperty(prop_name);
            props.remove(prop_name);
        }
        if (!ignore_sysprops && system_props != null) {
            for (int i = 0; i < system_props.length; ++i) {
                String prop = system_props[i];
                if (prop == null) continue;
                try {
                    String tmp = System.getProperty(prop);
                    if (tmp != null) {
                        return tmp;
                    }
                    continue;
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
            }
        }
        if (retval == null) {
            return default_value;
        }
        return retval;
    }

    public static boolean isBindAddressPropertyIgnored() {
        try {
            String tmp = System.getProperty("jgroups.ignore.bind_addr");
            if (tmp == null && (tmp = System.getProperty("ignore.bind.address")) == null) {
                return false;
            }
            return !(tmp = tmp.trim().toLowerCase()).equals("false") && !tmp.equals("no") && !tmp.equals("off") && (tmp.equals("true") || tmp.equals("yes") || tmp.equals("on"));
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers != null && !servers.isEmpty()) {
            for (int i = 0; i < servers.size(); ++i) {
                MBeanServer srv = servers.get(i);
                if (!"jboss".equalsIgnoreCase(srv.getDefaultDomain())) continue;
                return srv;
            }
            return servers.get(0);
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static String getProperty(Protocol prot, String prop_name) {
        if (prot == null) {
            return null;
        }
        String name = prot.getProperties().getProperty(prop_name);
        return name == null ? name : name.trim();
    }

    public static void main(String[] args) throws Exception {
        ClassConfigurator.getInstance(true);
        Message msg = new Message(null, (Address)new IpAddress("127.0.0.1", 4444), (Serializable)((Object)"Bela"));
        int size = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size);
        msg.putHeader("belaban", new NakAckHeader(1, 23L, 34L));
        size = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size);
        msg.putHeader("bla", new UdpHeader("groupname"));
        size = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size);
        IpAddress a1 = new IpAddress(1234);
        IpAddress a2 = new IpAddress("127.0.0.1", 3333);
        a1.setAdditionalData("Bela".getBytes());
        size = Util.sizeOf(a1);
        System.out.println("size=" + a1.size() + ", streamable size of a1=" + size);
        size = Util.sizeOf(a2);
        System.out.println("size=" + a2.size() + ", streamable size of a2=" + size);
    }

    public static String generateList(Collection c, String separator) {
        if (c == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String substituteVariable(String val) {
        if (val == null) {
            return val;
        }
        String retval = val;
        while (retval.contains("${")) {
            String prev = retval;
            if (!(retval = Util._substituteVar(retval)).equals(prev)) continue;
            break;
        }
        return retval;
    }

    private static String _substituteVar(String val) {
        int start_index = val.indexOf("${");
        if (start_index == -1) {
            return val;
        }
        int end_index = val.indexOf("}", start_index + 2);
        if (end_index == -1) {
            throw new IllegalArgumentException("missing \"}\" in " + val);
        }
        String tmp = Util.getProperty(val.substring(start_index + 2, end_index));
        if (tmp == null) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(val.substring(0, start_index));
        sb.append(tmp);
        sb.append(val.substring(end_index + 1));
        return sb.toString();
    }

    private static String getProperty(String s) {
        String retval = null;
        int index = s.indexOf(":");
        if (index >= 0) {
            String var = s.substring(0, index);
            String default_val = s.substring(index + 1);
            retval = System.getProperty(var, default_val);
        } else {
            String var = s;
            retval = System.getProperty(var);
        }
        return retval;
    }

    private static String getString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static String md5(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(source.getBytes());
            return Util.getString(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] bytes = md.digest(source.getBytes());
            return Util.getString(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        PRIMITIVE_TYPES = new HashMap(10);
        resolve_dns = false;
        JGROUPS_COMPAT = false;
        GLOBAL_GROUP = new ThreadGroup("JGroups"){

            public void uncaughtException(Thread t, Throwable e) {
                LogFactory.getLog("org.jgroups").error("uncaught exception in " + t + " (thread group=" + GLOBAL_GROUP + " )", e);
            }
        };
        try {
            resolve_dns = Boolean.valueOf(System.getProperty("resolve.dns", "false"));
        }
        catch (SecurityException ex) {
            resolve_dns = false;
        }
        f = NumberFormat.getNumberInstance();
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
        try {
            String tmp = Util.getProperty(new String[]{"jgroups.marshalling.compatible"}, null, null, false, "false");
            JGROUPS_COMPAT = Boolean.valueOf(tmp);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        PRIMITIVE_TYPES.put(Boolean.class, new Byte(10));
        PRIMITIVE_TYPES.put(Byte.class, new Byte(11));
        PRIMITIVE_TYPES.put(Character.class, new Byte(12));
        PRIMITIVE_TYPES.put(Double.class, new Byte(13));
        PRIMITIVE_TYPES.put(Float.class, new Byte(14));
        PRIMITIVE_TYPES.put(Integer.class, new Byte(15));
        PRIMITIVE_TYPES.put(Long.class, new Byte(16));
        PRIMITIVE_TYPES.put(Short.class, new Byte(17));
        PRIMITIVE_TYPES.put(String.class, new Byte(18));
    }
}

