/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class PutDataMapCommand
extends AbstractVersionedDataCommand {
    public static final int METHOD_ID = 1;
    public static final int ERASE_METHOD_ID = 2;
    public static final int VERSIONED_METHOD_ID = 37;
    public static final int ERASE_VERSIONED_METHOD_ID = 38;
    protected static final Log log = LogFactory.getLog(PutDataMapCommand.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected Map data;
    protected boolean erase;

    public PutDataMapCommand(GlobalTransaction globalTransaction, Fqn fqn, Map data) {
        this.globalTransaction = globalTransaction;
        this.fqn = fqn;
        this.data = data;
    }

    public PutDataMapCommand() {
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI nodeSPI;
        if (trace) {
            log.trace("perform(" + this.globalTransaction + ", \"" + this.fqn + "\", " + this.data + ")");
        }
        if ((nodeSPI = ctx.lookUpNode(this.fqn)) == null) {
            throw new NodeNotExistsException("Node " + this.fqn + " does not exist!");
        }
        Map existingData = nodeSPI.getDataDirect();
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.PUT_MAP, existingData == null ? Collections.emptyMap() : existingData, ctx);
        }
        if (this.erase) {
            nodeSPI.clearDataDirect();
        }
        nodeSPI.putAllDirect(this.data);
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.PUT_MAP, nodeSPI.getDataDirect(), ctx);
        }
        return null;
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutDataMapCommand(ctx, this);
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getCommandId() {
        if (this.isVersioned()) {
            return this.erase ? 38 : 37;
        }
        return this.erase ? 2 : 1;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.globalTransaction, this.fqn, this.data, false, this.dataVersion};
        }
        return new Object[]{this.globalTransaction, this.fqn, this.data, false};
    }

    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.fqn = (Fqn)args[1];
        this.data = (Map)args[2];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[4];
        }
    }

    protected boolean isVersionedId(int id) {
        return id == 37 || id == 38;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutDataMapCommand that = (PutDataMapCommand)o;
        if (this.data != null ? !((Object)this.data).equals(that.data) : that.data != null) {
            return false;
        }
        if (this.erase != that.erase) {
            return false;
        }
        return !(this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.data != null ? ((Object)this.data).hashCode() : 0);
        if (this.erase) {
            ++result;
        }
        return result;
    }

    public void setErase(boolean erase) {
        this.erase = erase;
    }

    public boolean isErase() {
        return this.erase;
    }

    public String toString() {
        return "PutDataMapCommand{fqn=" + this.fqn + ", dataVersion=" + this.dataVersion + ", data=" + this.data + ", globalTransaction=" + this.globalTransaction + ", erase=" + this.erase + '}';
    }
}

