/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Region;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.eviction.EvictionException;

public class EvictionTimerTask {
    private Log log = LogFactory.getLog(EvictionTimerTask.class);
    private RegionRegistry regionsRegistry;
    private static AtomicInteger tcount = new AtomicInteger();
    private long wakeupInterval;
    ScheduledExecutorService scheduledExecutor;
    private Task task = new Task();

    public void init(long wakeupInterval, ThreadFactory evictionThreadFactory, RegionRegistry rr) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating a new eviction listener with wakeupInterval millis set at " + wakeupInterval);
        }
        this.regionsRegistry = rr;
        this.wakeupInterval = wakeupInterval;
        this.start(evictionThreadFactory);
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping eviction timer");
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        this.scheduledExecutor = null;
    }

    private void start(ThreadFactory tf) {
        if (this.wakeupInterval < 1L) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Wakeup Interval set to " + this.wakeupInterval + ".  Not starting an eviction thread!");
            }
            return;
        }
        if (tf == null) {
            tf = new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "EvictionTimer-" + tcount.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            };
        }
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(tf);
        this.scheduledExecutor.scheduleWithFixedDelay(this.task, this.wakeupInterval / 2L, this.wakeupInterval, TimeUnit.MILLISECONDS);
    }

    private void processRegions() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Processing eviction regions " + this.regionsRegistry.keySet());
        }
        for (Region region : this.regionsRegistry.values()) {
            if (region.getEvictionRegionConfig() == null) continue;
            this.handleRegion(region);
        }
    }

    private void handleRegion(Region region) {
        try {
            region.processEvictionQueues();
        }
        catch (EvictionException e) {
            this.log.error("run(): error processing eviction with exception: " + e.toString() + " will reset the eviction queue list.");
            region.resetEvictionQueues();
            this.log.debug("trace", e);
        }
    }

    public class Task
    implements Runnable {
        public void run() {
            try {
                EvictionTimerTask.this.processRegions();
            }
            catch (Throwable t) {
                EvictionTimerTask.this.log.warn("Eviction task encountered an unexpected error", t);
            }
        }
    }
}

