/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RegionManager;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.remote.ClusteredGetCommand;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.ClusteredCacheLoaderConfig;
import org.jboss.cache.lock.StripedLock;
import org.jgroups.Address;
import org.jgroups.blocks.RspFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ClusteredCacheLoader
extends AbstractCacheLoader {
    private static final Log log = LogFactory.getLog(ClusteredCacheLoader.class);
    private static final boolean trace = log.isTraceEnabled();
    private StripedLock lock = new StripedLock();
    private ClusteredCacheLoaderConfig config;
    private CommandsFactory commandsFactory;

    protected boolean isCacheReady() {
        return this.cache.getCacheStatus() == CacheStatus.STARTED;
    }

    @Inject
    public void setCommandsFactory(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof ClusteredCacheLoaderConfig ? (ClusteredCacheLoaderConfig)base : new ClusteredCacheLoaderConfig(base);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getChildrenNames(Fqn fqn) throws Exception {
        if (!this.isCacheReady() || !this.cache.getInvocationContext().isOriginLocal()) {
            return Collections.emptySet();
        }
        this.lock.acquireLock(fqn, true);
        try {
            GetChildrenNamesCommand command = this.commandsFactory.buildGetChildrenNamesCommand(fqn);
            Object resp = this.callRemote(command);
            Set set = (Set)resp;
            return set;
        }
        finally {
            this.lock.releaseLock(fqn);
        }
    }

    private Object callRemote(DataCommand dataCommand) throws Exception {
        if (trace) {
            log.trace("cache=" + this.cache.getLocalAddress() + "; calling with " + dataCommand);
        }
        ClusteredGetCommand clusteredGet = this.commandsFactory.buildClusteredGetCommand(false, dataCommand);
        List<Object> resps = this.cache.getRPCManager().callRemoteMethods(null, clusteredGet, 2, this.config.getTimeout(), new ResponseValidityFilter(this.cache.getMembers(), this.cache.getLocalAddress()), false);
        if (resps == null) {
            if (log.isInfoEnabled()) {
                log.info("No replies to call " + dataCommand + ".  Perhaps we're alone in the cluster?");
            }
            throw new ReplicationException("No replies to call " + dataCommand + ".  Perhaps we're alone in the cluster?");
        }
        Iterator<Object> i = resps.iterator();
        Object result = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Exception) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Found remote exception among responses - removing from responses list", (Exception)o);
                continue;
            }
            if (o != null) {
                List clusteredGetResp = (List)o;
                if (!((Boolean)clusteredGetResp.get(0)).booleanValue()) continue;
                result = clusteredGetResp.get(1);
                break;
            }
            if (this.cache.getConfiguration().isUseRegionBasedMarshalling()) continue;
            throw new IllegalStateException("Received unexpected null response to " + clusteredGet);
        }
        if (trace) {
            log.trace("got responses " + resps);
        }
        return result;
    }

    public Map get(Fqn name) throws Exception {
        return this.get0(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map get0(Fqn name) throws Exception {
        if (!this.isCacheReady() || !this.cache.getInvocationContext().isOriginLocal()) {
            return null;
        }
        this.lock.acquireLock(name, true);
        try {
            GetDataMapCommand command = this.commandsFactory.buildGetDataMapCommand(name);
            Object resp = this.callRemote(command);
            Map map = (Map)resp;
            return map;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Fqn name) throws Exception {
        if (!this.isCacheReady() || !this.cache.getInvocationContext().isOriginLocal()) {
            return false;
        }
        this.lock.acquireLock(name, false);
        try {
            ExistsCommand command = this.commandsFactory.buildExistsNodeCommand(name);
            Object resp = this.callRemote(command);
            boolean bl = resp != null && (Boolean)resp != false;
            return bl;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (!this.isCacheReady() || !this.cache.getInvocationContext().isOriginLocal()) {
            return null;
        }
        this.lock.acquireLock(name, true);
        try {
            NodeSPI n = this.cache.peek(name, false);
            if (n == null) {
                GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(name, key, true);
                Object object = this.callRemote(command);
                return object;
            }
            Object v = n.getDirect(key);
            return v;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    public void put(Fqn name, Map attributes) throws Exception {
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        if (!this.isCacheReady() || !this.cache.getInvocationContext().isOriginLocal()) {
            return false;
        }
        this.lock.acquireLock(name, true);
        try {
            NodeSPI n = this.cache.peek(name, true);
            if (n == null) {
                GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(name, key, true);
                Object object = this.callRemote(command);
                return object;
            }
            Object v = n.getDirect(key);
            return v;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    @Override
    public void remove(Fqn name) throws Exception {
    }

    @Override
    public void removeData(Fqn name) throws Exception {
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
    }

    @Override
    public void commit(Object tx) throws Exception {
    }

    @Override
    public void rollback(Object tx) {
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
    }

    @Override
    public void setRegionManager(RegionManager manager) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResponseValidityFilter
    implements RspFilter {
        private int numValidResponses = 0;
        private List<Address> pendingResponders;

        public ResponseValidityFilter(List<Address> expected, Address localAddress) {
            this.pendingResponders = new ArrayList<Address>(expected);
            this.pendingResponders.remove(localAddress);
        }

        @Override
        public boolean isAcceptable(Object object, Address address) {
            List response;
            Boolean foundResult;
            this.pendingResponders.remove(address);
            if (object instanceof List && (foundResult = (Boolean)(response = (List)object).get(0)).booleanValue()) {
                ++this.numValidResponses;
            }
            return true;
        }

        @Override
        public boolean needMoreResponses() {
            return this.numValidResponses < 1 && this.pendingResponders.size() > 0;
        }
    }
}

