/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VersionedDataCommand;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DataVersioningException;
import org.jboss.cache.transaction.GlobalTransaction;

@Deprecated
public class VersionedInvalidateCommand
extends InvalidateCommand
implements VersionedDataCommand {
    private static final Log log = LogFactory.getLog(VersionedInvalidateCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private TransactionManager transactionManager;
    protected GlobalTransaction globalTransaction;
    private DataVersion dataVersion;

    public VersionedInvalidateCommand(Fqn fqn) {
        super(fqn);
    }

    public VersionedInvalidateCommand() {
    }

    public void initialize(TransactionManager txManager) {
        this.transactionManager = txManager;
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI node = this.enforceNodeLoading();
        if (trace) {
            log.trace("Invalidating fqn:" + this.fqn);
        }
        if (node == null) {
            NodeSPI nodeSPI = this.dataContainer.peek(this.fqn, true, true);
            if (nodeSPI == null) {
                if (this.dataVersion == null) {
                    if (trace) {
                        log.trace("Would have created a tombstone since the node doesn't exist, but the version to invalidate is null and hence cannot create a tombstone!");
                    }
                    return null;
                }
                this.createTombstone(ctx);
                nodeSPI = (NodeSPI)this.dataContainer.getRoot().getChild(this.fqn);
            }
            node = nodeSPI;
        } else {
            if (node.getVersion() == null) {
                throw new NullPointerException("Node " + node.getFqn() + " has a null data version, and is of type " + node.getClass().getSimpleName() + ".  This command expects versioned nodes.");
            }
            if (this.dataVersion != null && node.getVersion().newerThan(this.dataVersion)) {
                String errMsg = "Node found, but version is not equal to or less than the expected [" + this.dataVersion + "].  Is [" + node.getVersion() + "] instead!";
                log.warn(errMsg);
                throw new DataVersioningException(errMsg);
            }
        }
        this.removeData(node, ctx);
        this.invalidateNode(node);
        node.setVersion(this.dataVersion);
        return null;
    }

    protected void createTombstone(InvocationContext ctx) {
        if (trace) {
            log.trace("Node doesn't exist; creating a tombstone with data version " + this.dataVersion);
        }
        Option o = ctx.getOptionOverrides();
        boolean origCacheModeLocal = o.isCacheModeLocal();
        o.setCacheModeLocal(true);
        o.setDataVersion(this.dataVersion);
        try {
            Transaction suspended = null;
            if (this.transactionManager != null) {
                suspended = this.transactionManager.suspend();
            }
            this.spi.put(this.fqn, Collections.emptyMap());
            if (suspended != null) {
                this.transactionManager.resume(suspended);
            }
            ctx.getOptionOverrides().setCacheModeLocal(origCacheModeLocal);
        }
        catch (Exception e) {
            log.error("Unable to create tombstone!", e);
        }
    }

    protected void removeData(NodeSPI n, InvocationContext ctx) throws CacheException {
        this.notifier.notifyNodeInvalidated(this.fqn, true, ctx);
        n.clearDataDirect();
        n.setDataLoaded(false);
        this.notifier.notifyNodeInvalidated(this.fqn, false, ctx);
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction gtx) {
        this.globalTransaction = gtx;
    }

    public boolean isVersioned() {
        return this.dataVersion != null;
    }

    public String toString() {
        return "OptimisticInvalidateCommand{dataVersion=" + this.dataVersion + " ,fqn=" + this.fqn + '}';
    }

    public Object[] getParameters() {
        return new Object[]{this.fqn, this.dataVersion};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.dataVersion = (DataVersion)args[1];
    }
}

