/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class PutKeyValueCommand
extends AbstractVersionedDataCommand {
    public static final int METHOD_ID = 3;
    public static final int VERSIONED_METHOD_ID = 39;
    private static final Log log = LogFactory.getLog(PutKeyValueCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object key;
    protected Object value;

    public PutKeyValueCommand(GlobalTransaction gtx, Fqn fqn, Object key, Object value) {
        this.globalTransaction = gtx;
        this.fqn = fqn;
        this.key = key;
        this.value = value;
    }

    public PutKeyValueCommand() {
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI n;
        if (trace) {
            log.trace("Perform('" + this.globalTransaction + "', '" + this.fqn + "', k='" + this.key + "', v='" + this.value + "')");
        }
        if ((n = ctx.lookUpNode(this.fqn)) == null) {
            throw new NodeNotExistsException("Node " + this.fqn + " does not exist!");
        }
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.PUT_DATA, n.getDataDirect(), ctx);
        }
        Object oldValue = n.putDirect(this.key, this.value);
        if (trace) {
            log.trace("Old value is " + oldValue + ", dataLoaded=" + n.isDataLoaded());
        }
        if (this.notifier.shouldNotifyOnNodeModified()) {
            Map<Object, Object> newData = Collections.singletonMap(this.key, this.value);
            this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.PUT_DATA, newData, ctx);
        }
        return oldValue;
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutKeyValueCommand(ctx, this);
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getCommandId() {
        if (this.isVersioned()) {
            return 39;
        }
        return 3;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.globalTransaction, this.fqn, this.key, this.value, false, this.dataVersion};
        }
        return new Object[]{this.globalTransaction, this.fqn, this.key, this.value, false};
    }

    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.fqn = (Fqn)args[1];
        this.key = args[2];
        this.value = args[3];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[5];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutKeyValueCommand that = (PutKeyValueCommand)o;
        if (this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    protected boolean isVersionedId(int commandId) {
        return commandId == 39;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "fqn=" + this.fqn + ", dataVersion=" + this.dataVersion + ", globalTransaction=" + this.globalTransaction + ", key=" + this.key + ", value=" + this.value + '}';
    }
}

