/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import org.jboss.cache.RPCManager;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.marshall.CommandAwareRpcDispatcher;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.RegionalizedMethodCall;
import org.jboss.cache.marshall.RegionalizedReturnValue;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RpcDispatcher;

public class InactiveRegionAwareRpcDispatcher
extends CommandAwareRpcDispatcher {
    Marshaller requestMarshaller;

    public InactiveRegionAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object serverObj, InvocationContextContainer container, InterceptorChain interceptorChain, ComponentRegistry componentRegistry, RPCManager manager) {
        super(channel, l, l2, serverObj, container, interceptorChain, componentRegistry, manager);
    }

    public void setRequestMarshaller(RpcDispatcher.Marshaller m) {
        super.setRequestMarshaller(m);
        this.requestMarshaller = (Marshaller)m;
    }

    public Object handle(Message req) {
        if (this.isValid(req)) {
            ReplicableCommand command;
            RegionalizedMethodCall rmc;
            try {
                rmc = this.requestMarshaller.regionalizedMethodCallFromByteBuffer(req.getBuffer());
                command = rmc.command;
            }
            catch (Throwable e) {
                if (e instanceof InactiveRegionException) {
                    if (this.trace) {
                        this.log.trace("Exception from marshaller: " + e.getMessage());
                    }
                    return null;
                }
                if (this.trace) {
                    this.log.error("exception unmarshalling object", e);
                }
                return e;
            }
            try {
                Object retVal = this.executeCommand(command, req);
                return new RegionalizedReturnValue(retVal, rmc);
            }
            catch (Throwable x) {
                if (this.trace) {
                    this.log.trace("Problems invoking command", x);
                }
                return x;
            }
        }
        return null;
    }
}

