/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.connector.meta.jdbc.ColumnMetadata;
import org.modeshape.connector.meta.jdbc.JdbcMetadataException;
import org.modeshape.connector.meta.jdbc.JdbcMetadataI18n;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.JdbcMetadataRepository;
import org.modeshape.connector.meta.jdbc.MetadataCollector;
import org.modeshape.connector.meta.jdbc.ProcedureMetadata;
import org.modeshape.connector.meta.jdbc.TableMetadata;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.NodeCachingWorkspace;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.connector.base.cache.NodeCache;
import org.modeshape.graph.connector.base.cache.NodeCachePolicy;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedEvent;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedListener;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;

@NotThreadSafe
class JdbcMetadataWorkspace
extends PathWorkspace<PathNode>
implements NodeCachingWorkspace<Path, PathNode> {
    public static final String TABLES_SEGMENT_NAME = "tables";
    public static final String PROCEDURES_SEGMENT_NAME = "procedures";
    protected final JdbcMetadataRepository repository;
    private NodeCache<Path, PathNode> cache;
    private NodeCachePolicy<Path, PathNode> policy;

    public JdbcMetadataWorkspace(JdbcMetadataRepository repository, String name) {
        super(repository.getContext(), name, repository.source().getRootNodeUuidObject());
        this.repository = repository;
        repository.source().addNodeCachePolicyChangedListener((NodeCachePolicyChangedListener)this);
    }

    public void cachePolicyChanged(NodeCachePolicyChangedEvent<Path, PathNode> event) {
        this.policy = event.getNewPolicy();
        this.cache = this.policy.newCache();
    }

    public NodeCache<Path, PathNode> getCache() {
        return this.cache;
    }

    public PathNode getNode(Path path) {
        assert (path != null);
        PathNode node = null;
        List segments = path.getSegmentsList();
        switch (segments.size()) {
            case 0: {
                node = this.getRootNode();
                break;
            }
            case 1: {
                node = this.catalogNodeFor(segments);
                break;
            }
            case 2: {
                node = this.schemaNodeFor(segments);
                break;
            }
            case 3: {
                if (TABLES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) {
                    node = this.tablesNodeFor(segments);
                    break;
                }
                if (!PROCEDURES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) break;
                node = this.proceduresNodeFor(segments);
                break;
            }
            case 4: {
                if (TABLES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) {
                    node = this.tableNodeFor(segments);
                    break;
                }
                if (!PROCEDURES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) break;
                node = this.procedureNodeFor(segments);
                break;
            }
            case 5: {
                if (!TABLES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) break;
                node = this.columnNodeFor(segments);
                break;
            }
            default: {
                return null;
            }
        }
        return node;
    }

    private PathNode catalogNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
        assert (segments != null);
        assert (segments.size() == 1);
        LinkedList<Path.Segment> schemaNames = new LinkedList<Path.Segment>();
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getPropertyFactory();
        Path nodePath = pathFactory.createAbsolutePath(segments);
        Connection conn = this.repository.getConnection();
        String catalogName = segments.get(0).getName().getLocalName();
        try {
            List<String> catalogNames;
            boolean catalogMatchesDefaultName;
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            if (catalogName.equals(this.repository.source().getDefaultCatalogName())) {
                catalogName = null;
            }
            boolean bl = catalogMatchesDefaultName = (catalogNames = meta.getCatalogNames(conn)).isEmpty() || catalogNames.contains("");
            if (catalogName != null && !catalogNames.contains(catalogName) || catalogName == null && !catalogMatchesDefaultName) {
                PathNode pathNode = null;
                return pathNode;
            }
            ArrayList<String> schemaNamesFromMeta = new ArrayList<String>(meta.getSchemaNames(conn, catalogName));
            for (String schemaName : schemaNamesFromMeta) {
                if (schemaName.length() <= 0) continue;
                schemaNames.add(pathFactory.createSegment(schemaName));
            }
            if (schemaNames.isEmpty()) {
                schemaNames.add(pathFactory.createSegment(this.repository.source().getDefaultSchemaName()));
            }
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
            properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.CATALOG}));
            PathNode pathNode = new PathNode(null, nodePath.getParent(), nodePath.getLastSegment(), properties, schemaNames);
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetSchemaNames.text(new Object[]{catalogName}), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }

    private PathNode schemaNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
        String schemaName;
        assert (segments != null);
        assert (segments.size() == 2);
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getPropertyFactory();
        Path nodePath = pathFactory.createAbsolutePath(segments);
        Connection conn = this.repository.getConnection();
        String catalogName = segments.get(0).getName().getLocalName();
        if (catalogName.equals(this.repository.source().getDefaultCatalogName())) {
            catalogName = null;
        }
        if ((schemaName = segments.get(1).getName().getLocalName()).equals(this.repository.source().getDefaultSchemaName())) {
            schemaName = null;
        }
        try {
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            List<String> schemaNames = meta.getSchemaNames(conn, catalogName);
            if (schemaName != null && !schemaNames.contains(schemaName) || schemaName == null && !schemaNames.isEmpty()) {
                PathNode pathNode = null;
                return pathNode;
            }
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
            properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.SCHEMA}));
            Path.Segment[] children = new Path.Segment[]{pathFactory.createSegment(TABLES_SEGMENT_NAME), pathFactory.createSegment(PROCEDURES_SEGMENT_NAME)};
            PathNode pathNode = new PathNode(null, nodePath.getParent(), nodePath.getLastSegment(), properties, Arrays.asList(children));
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetSchemaNames.text(new Object[]{catalogName}), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }

    private PathNode tablesNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
        String schemaName;
        assert (segments != null);
        assert (segments.size() == 3);
        assert (TABLES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getPropertyFactory();
        Path nodePath = pathFactory.createAbsolutePath(segments);
        Connection conn = this.repository.getConnection();
        String catalogName = segments.get(0).getName().getLocalName();
        if (catalogName.equals(this.repository.source().getDefaultCatalogName())) {
            catalogName = null;
        }
        if ((schemaName = segments.get(1).getName().getLocalName()).equals(this.repository.source().getDefaultSchemaName())) {
            schemaName = null;
        }
        try {
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            List<String> schemaNames = meta.getSchemaNames(conn, catalogName);
            if (schemaName != null && !schemaNames.contains(schemaName) || schemaName == null && !schemaNames.isEmpty()) {
                PathNode pathNode = null;
                return pathNode;
            }
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
            properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.TABLES}));
            List<TableMetadata> tables = meta.getTables(conn, catalogName, schemaName, null);
            ArrayList<Path.Segment> children = new ArrayList<Path.Segment>(tables.size());
            for (TableMetadata table : tables) {
                children.add(pathFactory.createSegment(table.getName()));
            }
            PathNode pathNode = new PathNode(null, nodePath.getParent(), nodePath.getLastSegment(), properties, children);
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetTableNames.text(new Object[]{catalogName, schemaName}), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }

    private PathNode tableNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
        String schemaName;
        assert (segments != null);
        assert (segments.size() == 4);
        assert (TABLES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getPropertyFactory();
        Path nodePath = pathFactory.createAbsolutePath(segments);
        Connection conn = this.repository.getConnection();
        String catalogName = segments.get(0).getName().getLocalName();
        if (catalogName.equals(this.repository.source().getDefaultCatalogName())) {
            catalogName = null;
        }
        if ((schemaName = segments.get(1).getName().getLocalName()).equals(this.repository.source().getDefaultSchemaName())) {
            schemaName = null;
        }
        String tableName = segments.get(3).getName().getLocalName();
        try {
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            List<TableMetadata> tables = meta.getTables(conn, catalogName, schemaName, tableName);
            if (tables.isEmpty()) {
                PathNode pathNode = null;
                return pathNode;
            }
            assert (tables.size() == 1);
            TableMetadata table = tables.get(0);
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            Name propName = JcrLexicon.PRIMARY_TYPE;
            properties.put(propName, propFactory.create(propName, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
            propName = JcrLexicon.MIXIN_TYPES;
            properties.put(propName, propFactory.create(propName, new Object[]{JdbcMetadataLexicon.TABLE}));
            if (table.getType() != null) {
                propName = JdbcMetadataLexicon.TABLE_TYPE;
                properties.put(propName, propFactory.create(propName, new Object[]{table.getType()}));
            }
            if (table.getDescription() != null) {
                propName = JdbcMetadataLexicon.DESCRIPTION;
                properties.put(propName, propFactory.create(propName, new Object[]{table.getDescription()}));
            }
            if (table.getTypeCatalogName() != null) {
                propName = JdbcMetadataLexicon.TYPE_CATALOG_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{table.getTypeCatalogName()}));
            }
            if (table.getTypeSchemaName() != null) {
                propName = JdbcMetadataLexicon.TYPE_SCHEMA_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{table.getTypeSchemaName()}));
            }
            if (table.getTypeName() != null) {
                propName = JdbcMetadataLexicon.TYPE_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{table.getTypeName()}));
            }
            if (table.getSelfReferencingColumnName() != null) {
                propName = JdbcMetadataLexicon.SELF_REFERENCING_COLUMN_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{table.getSelfReferencingColumnName()}));
            }
            if (table.getReferenceGenerationStrategyName() != null) {
                propName = JdbcMetadataLexicon.REFERENCE_GENERATION_STRATEGY_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{table.getReferenceGenerationStrategyName()}));
            }
            List<ColumnMetadata> columns = meta.getColumns(conn, catalogName, schemaName, tableName, null);
            ArrayList<Path.Segment> children = new ArrayList<Path.Segment>(columns.size());
            for (ColumnMetadata column : columns) {
                children.add(pathFactory.createSegment(column.getName()));
            }
            PathNode pathNode = new PathNode(null, nodePath.getParent(), nodePath.getLastSegment(), properties, children);
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetTable.text(new Object[]{catalogName, schemaName, tableName}), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }

    private PathNode proceduresNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
        String schemaName;
        assert (segments != null);
        assert (segments.size() == 3);
        assert (PROCEDURES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getPropertyFactory();
        Path nodePath = pathFactory.createAbsolutePath(segments);
        Connection conn = this.repository.getConnection();
        String catalogName = segments.get(0).getName().getLocalName();
        if (catalogName.equals(this.repository.source().getDefaultCatalogName())) {
            catalogName = null;
        }
        if ((schemaName = segments.get(1).getName().getLocalName()).equals(this.repository.source().getDefaultSchemaName())) {
            schemaName = null;
        }
        try {
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            List<String> schemaNames = meta.getSchemaNames(conn, catalogName);
            if (schemaName != null && !schemaNames.contains(schemaName) || schemaName == null && !schemaNames.isEmpty()) {
                PathNode pathNode = null;
                return pathNode;
            }
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
            properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.PROCEDURES}));
            List<ProcedureMetadata> procedures = meta.getProcedures(conn, catalogName, schemaName, null);
            ArrayList<Path.Segment> children = new ArrayList<Path.Segment>(procedures.size());
            for (ProcedureMetadata procedure : procedures) {
                children.add(pathFactory.createSegment(procedure.getName()));
            }
            PathNode pathNode = new PathNode(null, nodePath.getParent(), nodePath.getLastSegment(), properties, children);
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetProcedureNames.text(new Object[]{catalogName, schemaName}), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }

    private PathNode procedureNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
        String schemaName;
        assert (segments != null);
        assert (segments.size() == 4);
        assert (PROCEDURES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getPropertyFactory();
        Path nodePath = pathFactory.createAbsolutePath(segments);
        Connection conn = this.repository.getConnection();
        String catalogName = segments.get(0).getName().getLocalName();
        if (catalogName.equals(this.repository.source().getDefaultCatalogName())) {
            catalogName = null;
        }
        if ((schemaName = segments.get(1).getName().getLocalName()).equals(this.repository.source().getDefaultSchemaName())) {
            schemaName = null;
        }
        String procedureName = segments.get(3).getName().getLocalName();
        try {
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            List<ProcedureMetadata> procedures = meta.getProcedures(conn, catalogName, schemaName, procedureName);
            if (procedures.isEmpty()) {
                PathNode pathNode = null;
                return pathNode;
            }
            if (segments.get(3).getIndex() > procedures.size()) {
                PathNode pathNode = null;
                return pathNode;
            }
            ProcedureMetadata procedure = procedures.get(segments.get(3).getIndex() - 1);
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            Name propName = JcrLexicon.PRIMARY_TYPE;
            properties.put(propName, propFactory.create(propName, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
            propName = JcrLexicon.MIXIN_TYPES;
            properties.put(propName, propFactory.create(propName, new Object[]{JdbcMetadataLexicon.PROCEDURE}));
            if (procedure.getDescription() != null) {
                propName = JdbcMetadataLexicon.DESCRIPTION;
                properties.put(propName, propFactory.create(propName, new Object[]{procedure.getDescription()}));
            }
            propName = JdbcMetadataLexicon.PROCEDURE_RETURN_TYPE;
            properties.put(propName, propFactory.create(propName, new Object[]{procedure.getType()}));
            PathNode pathNode = new PathNode(null, nodePath.getParent(), nodePath.getLastSegment(), properties, Collections.emptyList());
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetProcedure.text(new Object[]{catalogName, schemaName, procedureName}), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }

    private PathNode columnNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
        String schemaName;
        assert (segments != null);
        assert (segments.size() == 5);
        assert (TABLES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getPropertyFactory();
        Path nodePath = pathFactory.createAbsolutePath(segments);
        Connection conn = this.repository.getConnection();
        String catalogName = segments.get(0).getName().getLocalName();
        if (catalogName.equals(this.repository.source().getDefaultCatalogName())) {
            catalogName = null;
        }
        if ((schemaName = segments.get(1).getName().getLocalName()).equals(this.repository.source().getDefaultSchemaName())) {
            schemaName = null;
        }
        String tableName = segments.get(3).getName().getLocalName();
        String columnName = segments.get(4).getName().getLocalName();
        try {
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            List<ColumnMetadata> columns = meta.getColumns(conn, catalogName, schemaName, tableName, columnName);
            if (columns.isEmpty()) {
                PathNode pathNode = null;
                return pathNode;
            }
            assert (columns.size() == 1) : "Duplicate column named " + columnName;
            ColumnMetadata column = columns.get(0);
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            Name propName = JcrLexicon.PRIMARY_TYPE;
            properties.put(propName, propFactory.create(propName, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
            propName = JcrLexicon.MIXIN_TYPES;
            properties.put(propName, propFactory.create(propName, new Object[]{JdbcMetadataLexicon.COLUMN}));
            propName = JdbcMetadataLexicon.JDBC_DATA_TYPE;
            properties.put(propName, propFactory.create(propName, new Object[]{column.getJdbcDataType()}));
            propName = JdbcMetadataLexicon.TYPE_NAME;
            properties.put(propName, propFactory.create(propName, new Object[]{column.getTypeName()}));
            propName = JdbcMetadataLexicon.COLUMN_SIZE;
            properties.put(propName, propFactory.create(propName, new Object[]{column.getColumnSize()}));
            propName = JdbcMetadataLexicon.DECIMAL_DIGITS;
            properties.put(propName, propFactory.create(propName, new Object[]{column.getDecimalDigits()}));
            propName = JdbcMetadataLexicon.RADIX;
            properties.put(propName, propFactory.create(propName, new Object[]{column.getRadix()}));
            if (column.getNullable() != null) {
                propName = JdbcMetadataLexicon.NULLABLE;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getNullable()}));
            }
            if (column.getDescription() != null) {
                propName = JdbcMetadataLexicon.DESCRIPTION;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getDescription()}));
            }
            if (column.getDefaultValue() != null) {
                propName = JdbcMetadataLexicon.DEFAULT_VALUE;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getDefaultValue()}));
            }
            propName = JdbcMetadataLexicon.LENGTH;
            properties.put(propName, propFactory.create(propName, new Object[]{column.getLength()}));
            propName = JdbcMetadataLexicon.ORDINAL_POSITION;
            properties.put(propName, propFactory.create(propName, new Object[]{column.getOrdinalPosition()}));
            if (column.getScopeCatalogName() != null) {
                propName = JdbcMetadataLexicon.SCOPE_CATALOG_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getScopeCatalogName()}));
            }
            if (column.getScopeSchemaName() != null) {
                propName = JdbcMetadataLexicon.SCOPE_SCHEMA_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getScopeSchemaName()}));
            }
            if (column.getScopeTableName() != null) {
                propName = JdbcMetadataLexicon.SCOPE_TABLE_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getScopeTableName()}));
            }
            if (column.getSourceJdbcDataType() != null) {
                propName = JdbcMetadataLexicon.SOURCE_JDBC_DATA_TYPE;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getSourceJdbcDataType()}));
            }
            PathNode pathNode = new PathNode(null, nodePath.getParent(), nodePath.getLastSegment(), properties, Collections.emptyList());
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetColumn.text(new Object[]{catalogName, schemaName, tableName, columnName}), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }

    public PathNode getRootNode() throws RepositorySourceException {
        LinkedList<Path.Segment> catalogNames = new LinkedList<Path.Segment>();
        ExecutionContext context = this.repository.source().getRepositoryContext().getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Connection conn = this.repository.getConnection();
        try {
            MetadataCollector meta = this.repository.source().getMetadataCollector();
            for (String catalogName : meta.getCatalogNames(conn)) {
                if (catalogName.length() <= 0) continue;
                catalogNames.add(pathFactory.createSegment(catalogName));
            }
            if (catalogNames.isEmpty()) {
                catalogNames.add(pathFactory.createSegment(this.repository.source().getDefaultCatalogName()));
            }
            PathNode pathNode = new PathNode(this.repository.source().getRootNodeUuidObject(), null, null, this.repository.rootNodeProperties(), catalogNames);
            return pathNode;
        }
        catch (JdbcMetadataException se) {
            throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetCatalogNames.text(new Object[0]), (Throwable)se);
        }
        finally {
            this.repository.closeConnection(conn);
        }
    }
}

