/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.meta.jdbc.DatasourceHelper;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.MultiUseAbstractTest;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.federation.FederationManager;

public class JdbcMetadataConnectorTest
extends MultiUseAbstractTest {
    private static final String FOREIGN_KEYS = "foreignKeys";
    private static boolean upperCaseIdentifiers;
    private static boolean lowerCaseIdentifiers;
    private static String catalogName;
    private static String schemaName;

    @BeforeClass
    public static void beforeAll() throws Exception {
        JdbcMetadataConnectorTest.initTestDatabase();
        RepositoryConfiguration config = RepositoryConfiguration.read((String)"config/repo-config-jdbc-meta-federation.json");
        JdbcMetadataConnectorTest.startRepository((RepositoryConfiguration)config);
        Session session = JdbcMetadataConnectorTest.getSession();
        Node testRoot = session.getRootNode().addNode("testRoot");
        session.save();
        FederationManager fedMgr = session.getWorkspace().getFederationManager();
        fedMgr.createProjection(testRoot.getPath(), "jdbc-meta", "/", "database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTestDatabase() throws Exception {
        DataSource testDs = DatasourceHelper.getDataSource();
        DatasourceHelper.executeDdl("create.ddl");
        Connection connection = testDs.getConnection();
        DatabaseMetaData dmd = connection.getMetaData();
        upperCaseIdentifiers = dmd.storesUpperCaseIdentifiers();
        lowerCaseIdentifiers = dmd.storesLowerCaseIdentifiers();
        ResultSet rs = dmd.getTables(null, null, JdbcMetadataConnectorTest.dbString("district"), null);
        try {
            if (!rs.next()) {
                throw new IllegalStateException("Table creation failed -- Can't determine which catalog and schema to use");
            }
            catalogName = rs.getString("TABLE_CAT");
            if (rs.wasNull()) {
                ResultSet catalogsRs = dmd.getCatalogs();
                ArrayList<String> catalogs = new ArrayList<String>();
                while (catalogsRs.next()) {
                    String catalog = catalogsRs.getString("TABLE_CAT");
                    if (StringUtil.isBlank((String)catalog)) continue;
                    catalogs.add(catalog);
                }
                catalogName = catalogs.size() == 1 ? (String)catalogs.get(0) : "default";
            }
            schemaName = rs.getString("TABLE_SCHEM");
            if (rs.wasNull()) {
                schemaName = "default";
            }
            if (rs.next()) {
                throw new IllegalStateException("There is more than one table named DISTRICT in this database -- Can't determine which catalog and schema to use");
            }
        }
        finally {
            rs.close();
            connection.close();
        }
        DatasourceHelper.bindInJNDI("testDS");
    }

    private static String dbString(String string) {
        if (upperCaseIdentifiers) {
            return string.toUpperCase();
        }
        if (lowerCaseIdentifiers) {
            return string.toLowerCase();
        }
        return string;
    }

    @AfterClass
    public static void afterAll() throws Exception {
        MultiUseAbstractTest.afterAll();
        DatasourceHelper.executeDdl("drop.ddl");
        DatasourceHelper.closeDataSource();
    }

    @Test
    public void shouldReadAllJDBCMetadata() throws Exception {
        AbstractJcrNode database = session.getNode("/testRoot/database");
        this.assertDatabaseRoot((Node)database);
        Node catalog = database.getNode(catalogName);
        this.assertCatalog(catalog);
        Node schema = catalog.getNode(schemaName);
        this.assertSchema(schema);
        Node procedures = schema.getNode("procedures");
        this.assertProcedures(procedures);
        Node tables = schema.getNode("tables");
        this.assertChildrenInclude(tables, new String[]{JdbcMetadataConnectorTest.dbString("chain"), JdbcMetadataConnectorTest.dbString("area"), JdbcMetadataConnectorTest.dbString("district"), JdbcMetadataConnectorTest.dbString("sales")});
        this.assertHasMixins(tables, new String[]{"mj:tables"});
        Node chain = tables.getNode(JdbcMetadataConnectorTest.dbString("chain"));
        this.assertTable(chain, JdbcMetadataConnectorTest.dbString("ID"), JdbcMetadataConnectorTest.dbString("NAME"), FOREIGN_KEYS);
        this.assertFKs(chain, new String[0]);
        Node area = tables.getNode(JdbcMetadataConnectorTest.dbString("area"));
        this.assertTable(area, JdbcMetadataConnectorTest.dbString("ID"), JdbcMetadataConnectorTest.dbString("NAME"), JdbcMetadataConnectorTest.dbString("CHAIN_ID"), FOREIGN_KEYS);
        this.assertFKs(area, JdbcMetadataConnectorTest.dbString("CHAIN_ID"));
        Node region = tables.getNode(JdbcMetadataConnectorTest.dbString("region"));
        this.assertTable(region, JdbcMetadataConnectorTest.dbString("ID"), JdbcMetadataConnectorTest.dbString("NAME"), JdbcMetadataConnectorTest.dbString("AREA_ID"), FOREIGN_KEYS);
        this.assertFKs(region, JdbcMetadataConnectorTest.dbString("AREA_ID"));
        Node district = tables.getNode(JdbcMetadataConnectorTest.dbString("district"));
        this.assertTable(district, JdbcMetadataConnectorTest.dbString("ID"), JdbcMetadataConnectorTest.dbString("NAME"), JdbcMetadataConnectorTest.dbString("REGION_ID"), FOREIGN_KEYS);
        this.assertFKs(district, JdbcMetadataConnectorTest.dbString("REGION_ID"));
        Node sales = tables.getNode(JdbcMetadataConnectorTest.dbString("sales"));
        this.assertTable(sales, JdbcMetadataConnectorTest.dbString("ID"), JdbcMetadataConnectorTest.dbString("SALES_DATE"), JdbcMetadataConnectorTest.dbString("DISTRICT_ID"), JdbcMetadataConnectorTest.dbString("AMOUNT"), FOREIGN_KEYS);
        this.assertFKs(sales, new String[0]);
    }

    private void assertProcedures(Node procedures) throws RepositoryException {
        Assert.assertEquals((Object)"nt:unstructured", (Object)procedures.getPrimaryNodeType().getName());
        this.assertHasMixins(procedures, new String[]{"mj:procedures"});
        Assert.assertEquals((long)0L, (long)procedures.getNodes().getSize());
    }

    private void assertFKs(Node table, String ... expectedKeys) throws RepositoryException {
        Node foreignKeys = table.getNode(FOREIGN_KEYS);
        Assert.assertEquals((Object)"nt:unstructured", (Object)foreignKeys.getPrimaryNodeType().getName());
        this.assertHasMixins(foreignKeys, new String[]{"mj:foreignKeys"});
        if (expectedKeys.length == 0) {
            return;
        }
        this.assertChildrenInclude(foreignKeys, expectedKeys);
        for (String fk : expectedKeys) {
            Node foreignKey = foreignKeys.getNode(fk);
            Assert.assertNotNull((Object)foreignKey.getProperty(JdbcMetadataLexicon.PRIMARY_KEY_TABLE_NAME.toString()));
            Assert.assertNotNull((Object)foreignKey.getProperty(JdbcMetadataLexicon.PRIMARY_KEY_COLUMN_NAME.toString()));
            Assert.assertNotNull((Object)foreignKey.getProperty(JdbcMetadataLexicon.FOREIGN_KEY_TABLE_NAME.toString()));
            Assert.assertNotNull((Object)foreignKey.getProperty(JdbcMetadataLexicon.FOREIGN_KEY_COLUMN_NAME.toString()));
        }
    }

    private void assertTable(Node table, String ... expectedChildren) throws RepositoryException {
        Assert.assertEquals((Object)"nt:unstructured", (Object)table.getPrimaryNodeType().getName());
        this.assertHasMixins(table, new String[]{"mj:table"});
        Assert.assertNotNull((Object)table.getProperty(JdbcMetadataLexicon.TABLE_TYPE.toString()));
        this.assertChildrenInclude(table, expectedChildren);
        for (String child : expectedChildren) {
            if (child.equalsIgnoreCase(FOREIGN_KEYS)) continue;
            Node column = table.getNode(child);
            Assert.assertEquals((Object)"nt:unstructured", (Object)column.getPrimaryNodeType().getName());
            this.assertHasMixins(column, new String[]{"mj:column"});
            Assert.assertNotNull((Object)column.getProperty(JdbcMetadataLexicon.JDBC_DATA_TYPE.toString()));
            Assert.assertNotNull((Object)column.getProperty(JdbcMetadataLexicon.COLUMN_SIZE.toString()));
            Assert.assertNotNull((Object)column.getProperty(JdbcMetadataLexicon.DECIMAL_DIGITS.toString()));
            Assert.assertNotNull((Object)column.getProperty(JdbcMetadataLexicon.RADIX.toString()));
            Assert.assertNotNull((Object)column.getProperty(JdbcMetadataLexicon.ORDINAL_POSITION.toString()));
        }
    }

    private void assertSchema(Node schema) throws RepositoryException {
        Assert.assertEquals((Object)"nt:unstructured", (Object)schema.getPrimaryNodeType().getName());
        this.assertHasMixins(schema, new String[]{"mj:schema"});
        this.assertChildrenInclude(schema, new String[]{"tables", "procedures"});
    }

    private void assertCatalog(Node catalog) throws RepositoryException {
        Assert.assertEquals((Object)"nt:unstructured", (Object)catalog.getPrimaryNodeType().getName());
        this.assertHasMixins(catalog, new String[]{"mj:catalog"});
        this.assertChildrenInclude(catalog, new String[]{schemaName});
    }

    private void assertDatabaseRoot(Node database) throws RepositoryException {
        Assert.assertEquals((Object)"nt:unstructured", (Object)database.getPrimaryNodeType().getName());
        this.assertHasMixins(database, new String[]{"mj:databaseRoot"});
        Assert.assertNotNull((Object)database.getProperty(JdbcMetadataLexicon.DATABASE_PRODUCT_NAME.toString()));
        Assert.assertNotNull((Object)database.getProperty(JdbcMetadataLexicon.DATABASE_PRODUCT_VERSION.toString()));
        Assert.assertNotNull((Object)database.getProperty(JdbcMetadataLexicon.DATABASE_MAJOR_VERSION.toString()));
        Assert.assertNotNull((Object)database.getProperty(JdbcMetadataLexicon.DATABASE_MINOR_VERSION.toString()));
        this.assertChildrenInclude(database, new String[]{catalogName});
    }
}

