/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.params;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.index.params.DefaultFacetIndexingParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.cache.CategoryListCache;
import org.apache.lucene.facet.search.params.FacetRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetSearchParams {
    protected final FacetIndexingParams indexingParams;
    protected final List<FacetRequest> facetRequests;
    private CategoryListCache clCache = null;

    public FacetSearchParams(FacetIndexingParams indexingParams) {
        this.indexingParams = indexingParams;
        this.facetRequests = new ArrayList<FacetRequest>();
    }

    public FacetSearchParams() {
        this(new DefaultFacetIndexingParams());
    }

    public final FacetIndexingParams getFacetIndexingParams() {
        return this.indexingParams;
    }

    public final List<FacetRequest> getFacetRequests() {
        return this.facetRequests;
    }

    public void addFacetRequest(FacetRequest facetRequest) {
        if (facetRequest == null) {
            throw new IllegalArgumentException("Provided facetRequest must not be null");
        }
        this.facetRequests.add(facetRequest);
    }

    public String toString() {
        int TAB = 9;
        int NEWLINE = 10;
        StringBuilder sb = new StringBuilder("IndexingParams: ");
        sb.append('\n').append('\t').append(this.getFacetIndexingParams());
        sb.append('\n').append("FacetRequests:");
        for (FacetRequest facetRequest : this.getFacetRequests()) {
            sb.append('\n').append('\t').append(facetRequest);
        }
        return sb.toString();
    }

    public CategoryListCache getClCache() {
        return this.clCache;
    }

    public void setClCache(CategoryListCache clCache) {
        this.clCache = clCache;
    }
}

