/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.meta.jdbc.AbstractMetadataRetriever;
import org.modeshape.connector.meta.jdbc.ColumnMetadata;
import org.modeshape.connector.meta.jdbc.JdbcMetadataConnector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.TableRetriever;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.federation.spi.DocumentWriter;

public class ColumnRetriever
extends AbstractMetadataRetriever {
    private static final Pattern COLUMN_PATH_PATTERN = Pattern.compile("/([^/]+)/([^/]+)/([^/]+)/tables/([^/]+)/([^/]+)");
    private static final String COLUMN_PREFIX = "col";
    private static final Pattern COLUMN_ID_PATTERN = Pattern.compile("([^@]+)@([^@]+)@([^@]+)@([^@]+)@col@([^@]+)");

    protected ColumnRetriever(JdbcMetadataConnector connector) {
        super(connector);
    }

    @Override
    protected Document getDocumentById(String id, DocumentWriter writer, Connection connection) {
        String schemaId;
        String schema;
        String columnId = this.columnIdFrom(id);
        String tableId = this.tableIdFrom(id);
        String catalogId = this.catalogIdFrom(id);
        String catalog = catalogId;
        if (catalog.equalsIgnoreCase(this.connector.getDefaultCatalogName())) {
            catalog = null;
        }
        if ((schema = (schemaId = this.schemaIdFrom(id))).equalsIgnoreCase(this.connector.getDefaultSchemaName())) {
            schema = null;
        }
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.COLUMN);
        writer.setParent(TableRetriever.documentId("databaseRoot", catalogId, schemaId, tableId, false));
        List<ColumnMetadata> metadatas = this.connector.getMetadataCollector().getColumns(connection, catalog, schema, tableId, columnId);
        if (!metadatas.isEmpty()) {
            ColumnMetadata columnMetadata = metadatas.get(0);
            writer.addProperty(JdbcMetadataLexicon.JDBC_DATA_TYPE, (Object)columnMetadata.getJdbcDataType());
            writer.addProperty(JdbcMetadataLexicon.TYPE_NAME, (Object)columnMetadata.getTypeName());
            writer.addProperty(JdbcMetadataLexicon.COLUMN_SIZE, (Object)columnMetadata.getColumnSize());
            writer.addProperty(JdbcMetadataLexicon.DECIMAL_DIGITS, (Object)columnMetadata.getDecimalDigits());
            writer.addProperty(JdbcMetadataLexicon.RADIX, (Object)columnMetadata.getRadix());
            writer.addProperty(JdbcMetadataLexicon.NULLABLE, (Object)columnMetadata.getNullable());
            writer.addProperty(JdbcMetadataLexicon.DESCRIPTION, (Object)columnMetadata.getDescription());
            writer.addProperty(JdbcMetadataLexicon.LENGTH, (Object)columnMetadata.getLength());
            writer.addProperty(JdbcMetadataLexicon.ORDINAL_POSITION, (Object)columnMetadata.getOrdinalPosition());
            writer.addProperty(JdbcMetadataLexicon.SCOPE_CATALOG_NAME, (Object)columnMetadata.getScopeCatalogName());
            writer.addProperty(JdbcMetadataLexicon.SCOPE_SCHEMA_NAME, (Object)columnMetadata.getScopeSchemaName());
            writer.addProperty(JdbcMetadataLexicon.SCOPE_TABLE_NAME, (Object)columnMetadata.getScopeTableName());
            writer.addProperty(JdbcMetadataLexicon.SCOPE_SCHEMA_NAME, (Object)columnMetadata.getScopeSchemaName());
            writer.addProperty(JdbcMetadataLexicon.SOURCE_JDBC_DATA_TYPE, (Object)columnMetadata.getSourceJdbcDataType());
            writer.addProperty(JdbcMetadataLexicon.DEFAULT_VALUE, (Object)columnMetadata.getDefaultValue());
        }
        return writer.document();
    }

    private String columnIdFrom(String id) {
        Matcher matcher = COLUMN_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(5) : null;
    }

    private String tableIdFrom(String id) {
        Matcher matcher = COLUMN_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(4) : null;
    }

    private String schemaIdFrom(String id) {
        Matcher matcher = COLUMN_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(3) : null;
    }

    private String catalogIdFrom(String id) {
        Matcher matcher = COLUMN_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(2) : null;
    }

    @Override
    protected String idFrom(String path) {
        Matcher columnNameMatcher = COLUMN_PATH_PATTERN.matcher(path);
        if (columnNameMatcher.matches() && !TableRetriever.FKS_PATH_PATTERN.matcher(path).matches()) {
            return ColumnRetriever.documentId(columnNameMatcher.group(1), columnNameMatcher.group(2), columnNameMatcher.group(3), columnNameMatcher.group(4), columnNameMatcher.group(5));
        }
        return null;
    }

    @Override
    protected boolean canHandle(String id) {
        return COLUMN_ID_PATTERN.matcher(id).matches();
    }

    static String documentId(String databaseId, String catalogId, String schemaId, String tableId, String columnId) {
        return ColumnRetriever.generateId(databaseId, catalogId, schemaId, tableId, COLUMN_PREFIX, columnId);
    }
}

