/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.meta.jdbc.AbstractMetadataRetriever;
import org.modeshape.connector.meta.jdbc.JdbcMetadataConnector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.ProcedureMetadata;
import org.modeshape.connector.meta.jdbc.SchemaRetriever;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.federation.spi.DocumentWriter;

public class ProcedureRetriever
extends AbstractMetadataRetriever {
    private static final Pattern PROCEDURE_PATH_PATTERN = Pattern.compile("/([^/]+)/([^/]+)/([^/]+)/procedures/([^/]+)");
    private static final String PROCEDURE_PREFIX = "proc";
    private static final Pattern PROCEDURE_ID_PATTERN = Pattern.compile("([^@]+)@([^@]+)@([^@]+)@proc@([^@]+)");

    protected ProcedureRetriever(JdbcMetadataConnector connector) {
        super(connector);
    }

    @Override
    protected Document getDocumentById(String id, DocumentWriter writer, Connection connection) {
        String schemaId;
        String schema;
        String procedureId = this.procedureIdFrom(id);
        String catalogId = this.catalogIdFrom(id);
        String catalog = catalogId;
        if (catalog.equalsIgnoreCase(this.connector.getDefaultCatalogName())) {
            catalog = null;
        }
        if ((schema = (schemaId = this.schemaIdFrom(id))).equalsIgnoreCase(this.connector.getDefaultSchemaName())) {
            schema = null;
        }
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.PROCEDURE);
        writer.setParent(SchemaRetriever.documentId("databaseRoot", catalogId, schemaId, false, true));
        List<ProcedureMetadata> metadatas = this.connector.getMetadataCollector().getProcedures(connection, catalog, schema, procedureId);
        if (!metadatas.isEmpty()) {
            ProcedureMetadata metadata = metadatas.get(0);
            writer.addProperty(JdbcMetadataLexicon.DESCRIPTION, (Object)metadata.getDescription());
            writer.addProperty(JdbcMetadataLexicon.PROCEDURE_RETURN_TYPE, (Object)metadata.getType());
        }
        return null;
    }

    private String procedureIdFrom(String id) {
        Matcher matcher = PROCEDURE_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(4) : null;
    }

    private String schemaIdFrom(String id) {
        Matcher matcher = PROCEDURE_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(3) : null;
    }

    private String catalogIdFrom(String id) {
        Matcher matcher = PROCEDURE_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(2) : null;
    }

    @Override
    protected String idFrom(String path) {
        Matcher matcher = PROCEDURE_PATH_PATTERN.matcher(path);
        if (matcher.matches()) {
            return ProcedureRetriever.documentId(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
        }
        return null;
    }

    @Override
    protected boolean canHandle(String id) {
        return PROCEDURE_ID_PATTERN.matcher(id).matches();
    }

    static String documentId(String databaseId, String catalogId, String schemaId, String procedureId) {
        return ProcedureRetriever.generateId(databaseId, catalogId, schemaId, PROCEDURE_PREFIX, procedureId);
    }
}

