/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.modeshape.jcr.store.DataSourceConfig;

public class DatasourceHelper {
    private static final DataSourceConfig DATA_SOURCE_CONFIG = new DataSourceConfig();
    private static HikariDataSource dataSource;
    private static boolean print;

    public static void setPrint(boolean print) {
        DatasourceHelper.print = print;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeDdl(String fileName) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        InputStream istream = null;
        BufferedReader reader = null;
        try {
            String line;
            conn = dataSource.getConnection();
            stmt = conn.createStatement();
            String filePath = "/" + DATA_SOURCE_CONFIG.getDatabase() + "/" + fileName;
            istream = DatasourceHelper.class.getResourceAsStream(filePath);
            Assert.assertThat((String)(filePath + " cannot be found"), (Object)istream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            reader = new BufferedReader(new InputStreamReader(istream));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("--")) continue;
                if (print) {
                    System.out.println("Executing: " + line);
                }
                stmt.execute(line);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static DataSource getDataSource() {
        if (dataSource == null) {
            dataSource = new HikariDataSource();
            dataSource.setDriverClassName(DATA_SOURCE_CONFIG.getDriverClassName());
            dataSource.setJdbcUrl(DATA_SOURCE_CONFIG.getUrl());
            dataSource.setUsername(DATA_SOURCE_CONFIG.getUsername());
            dataSource.setPassword(DATA_SOURCE_CONFIG.getPassword());
            dataSource.setIdleTimeout((long)(DATA_SOURCE_CONFIG.getMaximumConnectionIdleTimeInSeconds() * 1000));
            dataSource.setMaximumPoolSize(DATA_SOURCE_CONFIG.getMaximumConnectionsInPool().intValue());
        }
        return dataSource;
    }

    public static void bindInJNDI(String name) throws NamingException {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
        InitialContext ic = new InitialContext();
        ic.createSubcontext("java:");
        ic.bind("java:/" + name, (Object)dataSource);
    }

    public static void closeDataSource() {
        dataSource.close();
    }

    static {
        print = false;
    }
}

