/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.connector.svn.SvnConnectorTestUtil;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrMixLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.property.PathNotFoundException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnRepositoryConnectorWritableTest
extends AbstractConnectorTest {
    protected static final String EMPTY_CONTENT = "";
    protected static final String TEST_CONTENT = "Test content";
    protected SVNRepository remoteRepos = null;
    protected String url;
    protected SVNNodeKind kind = null;
    protected SVNProperties fileProperties = null;
    protected ByteArrayOutputStream baos = null;

    protected RepositorySource setUpSource() throws Exception {
        this.url = SvnConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
        String[] predefinedWorkspaceNames = new String[]{"trunk", "tags"};
        SvnRepositorySource source = new SvnRepositorySource();
        source.setName("Test Repository");
        source.setUsername("sp");
        source.setPassword(EMPTY_CONTENT);
        source.setRepositoryRootUrl(this.url);
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(Boolean.TRUE.booleanValue());
        source.setUpdatesAllowed(true);
        this.remoteRepos = SvnConnectorTestUtil.createRepository(this.url + "/trunk", "sp", EMPTY_CONTENT);
        return source;
    }

    protected void initializeContent(Graph graph) throws Exception {
    }

    public void afterEach() throws Exception {
        this.remoteRepos = null;
        super.afterEach();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldNotBeAbleToCreateInvalidTypeForRepository() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}).orReplace().and();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldNotBeAbleToSetArbitraryProperties() {
        this.graph.create("/testFile").with(JcrLexicon.MIXIN_TYPES, new Object[]{JcrMixLexicon.LOCKABLE}).orReplace().and();
    }

    @Test
    public void shouldBeAbleToCreateNodeFileWithContentLevel1() throws Exception {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.create("/testFile1").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile1/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFile1", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFile1", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.create("/root/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/root/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("root/testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("root/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.create("/root/a/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/root/a/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("root/a/testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("root/a/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
    }

    @Test
    public void shouldRespectConflictBehaviorOnCreate() throws Exception {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Should not overwrite".getBytes()}).ifAbsent().and();
        this.kind = this.remoteRepos.checkPath("testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
    }

    @Test
    public void shouldBeAbleToCreateFileWithNoContent() throws Exception {
        this.graph.create("/testEmptyFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testEmptyFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testEmptyFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, EMPTY_CONTENT);
    }

    @Test
    public void shouldBeAbleToCreateFolder() throws Exception {
        this.graph.create("/testFolder").orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFolder", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.DIR ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.graph.create("/root/testFolder").orReplace().and();
        this.kind = this.remoteRepos.checkPath("root/testFolder", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.DIR ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.graph.create("/root/a/testFolder").orReplace().and();
        this.kind = this.remoteRepos.checkPath("root/a/testFolder", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.DIR ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
    }

    @Test
    public void shouldBeAbleToAddChildrenToFolder() throws Exception {
        this.graph.create("/testFolder").orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFolder", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.DIR ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFolder/testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.create("/root/testFolder").orReplace().and();
        this.kind = this.remoteRepos.checkPath("root/testFolder", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.DIR ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.graph.create("/root/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/root/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("root/testFolder/testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("root/testFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
    }

    @Test
    public void shouldBeAbleToCopyFile() throws Exception {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.copy("/testFile").to("/copiedFile");
        this.kind = this.remoteRepos.checkPath("copiedFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("copiedFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
    }

    @Test
    public void shouldBeAbleToCopyFolder() throws Exception {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFolder/testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.copy("/testFolder").to("/copiedFolder");
        this.kind = this.remoteRepos.checkPath("copiedFolder", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.DIR ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("copiedFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
    }

    @Test
    public void shouldBeAbleToMoveFile() throws Exception {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        ((Graph.Conjunction)((Graph.Into)this.graph.move("/testFile").as("newFile")).into("/")).and();
        this.kind = this.remoteRepos.checkPath("newFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("newFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        try {
            this.graph.getNodeAt("/testFile");
            Assert.fail((String)"Old copy of file still exists at source location");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeAbleToMoveFolder() throws Exception {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFolder/testFile", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.FILE ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        ((Graph.Conjunction)((Graph.Into)this.graph.move("/testFolder").as("newFolder")).into("/")).and();
        this.kind = this.remoteRepos.checkPath("newFolder", -1L);
        Assert.assertThat((Object)(this.kind == SVNNodeKind.DIR ? 1 : 0), (Matcher)Is.is((Object)Boolean.TRUE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("newFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        try {
            this.graph.getNodeAt("/testFolder");
            Assert.fail((String)"Old copy of file still exists at source location");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeAbleToDeleteFolder() throws Exception {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFolder/testFile", -1L);
        Assert.assertThat((Object)this.kind, (Matcher)Is.is((Object)SVNNodeKind.FILE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.getNodeAt("/testFolder");
        this.graph.delete("/testFolder").and();
        try {
            this.graph.getNodeAt("/testFolder");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeAbleToDeleteFile() throws Exception {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFolder/testFile", -1L);
        Assert.assertThat((Object)this.kind, (Matcher)Is.is((Object)SVNNodeKind.FILE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFolder/testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        this.graph.getNodeAt("/testFolder/testFile");
        this.graph.delete("/testFolder/testFile").and();
        try {
            this.graph.getNodeAt("/testFolder/testFile");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeAbleToClearFileByRemovingDataProperty() throws Exception {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        this.kind = this.remoteRepos.checkPath("testFile", -1L);
        Assert.assertThat((Object)this.kind, (Matcher)Is.is((Object)SVNNodeKind.FILE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, TEST_CONTENT);
        ((Graph.Conjunction)this.graph.remove(new String[]{"jcr:data"}).on("/testFile/jcr:content")).and();
        this.kind = this.remoteRepos.checkPath("testFile", -1L);
        Assert.assertThat((Object)this.kind, (Matcher)Is.is((Object)SVNNodeKind.FILE));
        this.fileProperties = new SVNProperties();
        this.baos = new ByteArrayOutputStream();
        this.remoteRepos.getFile("testFile", -1L, this.fileProperties, (OutputStream)this.baos);
        this.assertContents(this.baos, EMPTY_CONTENT);
    }

    @Test
    public void shouldBeAllOrNothing() {
        String badTestFileName = "/missingDirectory/someFile";
        Graph.Batch batch = this.graph.batch();
        batch.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        batch.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{TEST_CONTENT.getBytes()}).orReplace().and();
        batch.create(badTestFileName).and();
        try {
            batch.execute();
            Assert.fail((String)("The invalid test file name (" + badTestFileName + ") did not fail"));
        }
        catch (PathNotFoundException rse) {
            // empty catch block
        }
        try {
            this.graph.getNodeAt("/testFile");
            Assert.fail((String)"Got node at /testFile -- whole transaction should have failed");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void runItTwice() {
        this.shouldBeAllOrNothing();
        this.shouldBeAllOrNothing();
        this.shouldBeAllOrNothing();
    }

    protected void assertContents(ByteArrayOutputStream baos, String contents) {
        Assert.assertThat((Object)baos, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)baos.toString(), (Matcher)Is.is((Object)contents));
    }
}

