/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVLocationsHandler
extends BasicDAVHandler {
    private static final DAVElement LOCATION_REPORT = DAVElement.getElement("svn:", "get-locations-report");
    private static final DAVElement LOCATION = DAVElement.getElement("svn:", "location");
    private ISVNLocationEntryHandler myLocationEntryHandler;
    private int myCount;

    public static StringBuffer generateLocationsRequest(StringBuffer xmlBuffer, String path, long pegRevision, long[] revisions) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "get-locations", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "path", path, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "peg-revision", String.valueOf(pegRevision), xmlBuffer);
        for (int i = 0; i < revisions.length; ++i) {
            SVNXMLUtil.openCDataTag("S", "location-revision", String.valueOf(revisions[i]), xmlBuffer);
        }
        SVNXMLUtil.addXMLFooter("S", "get-locations", xmlBuffer);
        return xmlBuffer;
    }

    public DAVLocationsHandler(ISVNLocationEntryHandler handler) {
        this.myLocationEntryHandler = handler;
        this.init();
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        String path;
        String revStr;
        if (parent == LOCATION_REPORT && element == LOCATION && (revStr = attrs.getValue("rev")) != null && (path = attrs.getValue("path")) != null && this.myLocationEntryHandler != null) {
            path = "/" + path;
            try {
                this.myLocationEntryHandler.handleLocationEntry(new SVNLocationEntry(Long.parseLong(revStr), path));
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
            ++this.myCount;
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
    }

    public int getEntriesCount() {
        return this.myCount;
    }
}

