/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ReadOnly;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.svn.SvnRepository;
import org.modeshape.connector.svn.SvnRepositoryConnectorI18n;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.AbstractRepositorySource;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Connection;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.request.CreateWorkspaceRequest;

@ThreadSafe
public class SvnRepositorySource
extends AbstractRepositorySource
implements ObjectFactory {
    private static final long serialVersionUID = 1L;
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String SVN_REPOSITORY_ROOT_URL = "repositoryRootURL";
    protected static final String SVN_USERNAME = "username";
    protected static final String SVN_PASSWORD = "password";
    protected static final String RETRY_LIMIT = "retryLimit";
    protected static final String ROOT_NODE_UUID = "rootNodeUuid";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = false;
    protected static final boolean DEFAULT_SUPPORTS_CREATING_WORKSPACES = true;
    public static final boolean DEFAULT_SUPPORTS_UPDATES = false;
    public static final String DEFAULT_WORKSPACE_NAME = "trunk";
    protected static final boolean SUPPORTS_REFERENCES = false;
    @Description(i18n=SvnRepositoryConnectorI18n.class, value="repositoryRootUrlPropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="repositoryRootUrlPropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="repositoryRootUrlPropertyCategory")
    private volatile String repositoryRootUrl;
    @Description(i18n=SvnRepositoryConnectorI18n.class, value="usernamePropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="usernamePropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="usernamePropertyCategory")
    private volatile String username;
    @Description(i18n=SvnRepositoryConnectorI18n.class, value="passwordPropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="passwordPropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="passwordPropertyCategory")
    private volatile String password;
    @Description(i18n=SvnRepositoryConnectorI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private volatile String defaultWorkspace = "trunk";
    @Description(i18n=SvnRepositoryConnectorI18n.class, value="predefinedWorkspacesPropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="predefinedWorkspacesPropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="predefinedWorkspacesPropertyCategory")
    private volatile String[] predefinedWorkspaces = new String[0];
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(false, false, true, true, false);
    private transient SvnRepository repository;
    private ExecutionContext defaultContext = new ExecutionContext();

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public String getRepositoryRootUrl() {
        return this.repositoryRootUrl;
    }

    public synchronized void setRepositoryRootUrl(String url) {
        CheckArg.isNotEmpty((String)url, (String)"RepositoryRootUrl");
        this.repositoryRootUrl = url;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    @Description(i18n=SvnRepositoryConnectorI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="updatesAllowedPropertyCategory")
    @ReadOnly
    public boolean getSupportsUpdates() {
        return this.capabilities.supportsUpdates();
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public synchronized void setDefaultWorkspaceName(String pathToDirectoryForDefaultWorkspace) {
        this.defaultWorkspace = pathToDirectoryForDefaultWorkspace;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    @Description(i18n=SvnRepositoryConnectorI18n.class, value="creatingWorkspacesAllowedPropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="creatingWorkspacesAllowedPropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="creatingWorkspacesAllowedPropertyCategory")
    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), this.capabilities.supportsUpdates(), this.capabilities.supportsEvents(), allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    @Description(i18n=SvnRepositoryConnectorI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=SvnRepositoryConnectorI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=SvnRepositoryConnectorI18n.class, value="updatesAllowedPropertyCategory")
    public boolean areUpdatesAllowed() {
        return this.capabilities.supportsUpdates();
    }

    public synchronized void setUpdatesAllowed(boolean allowUpdates) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), allowUpdates, this.capabilities.supportsEvents(), this.capabilities.supportsCreatingWorkspaces(), this.capabilities.supportsReferences());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SvnRepositorySource) {
            SvnRepositorySource that = (SvnRepositorySource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        if (this.getRepositoryRootUrl() != null) {
            ref.add(new StringRefAddr(SVN_REPOSITORY_ROOT_URL, this.getRepositoryRootUrl()));
        }
        if (this.getUsername() != null) {
            ref.add(new StringRefAddr(SVN_USERNAME, this.getUsername()));
        }
        if (this.getPassword() != null) {
            ref.add(new StringRefAddr(SVN_PASSWORD, this.getPassword()));
        }
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuidObject().toString()));
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Map values = this.valuesFrom((Reference)obj);
        String sourceName = (String)values.get(SOURCE_NAME);
        String repositoryRootUrl = (String)values.get(SVN_REPOSITORY_ROOT_URL);
        String username = (String)values.get(SVN_USERNAME);
        String password = (String)values.get(SVN_PASSWORD);
        String retryLimit = (String)values.get(RETRY_LIMIT);
        String rootNodeUuid = (String)values.get(ROOT_NODE_UUID);
        String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
        String createWorkspaces = (String)values.get(ALLOW_CREATING_WORKSPACES);
        String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
        String[] workspaceNames = null;
        if (combinedWorkspaceNames != null) {
            List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
            workspaceNames = paths.toArray(new String[paths.size()]);
        }
        SvnRepositorySource source = new SvnRepositorySource();
        if (sourceName != null) {
            source.setName(sourceName);
        }
        if (repositoryRootUrl != null && repositoryRootUrl.length() > 0) {
            source.setRepositoryRootUrl(repositoryRootUrl);
        }
        if (username != null) {
            source.setUsername(username);
        }
        if (password != null) {
            source.setPassword(password);
        }
        if (retryLimit != null) {
            source.setRetryLimit(Integer.parseInt(retryLimit));
        }
        if (rootNodeUuid != null) {
            source.setRootNodeUuidObject(rootNodeUuid);
        }
        if (defaultWorkspace != null) {
            source.setDefaultWorkspaceName(defaultWorkspace);
        }
        if (createWorkspaces != null) {
            source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
        }
        if (workspaceNames != null && workspaceNames.length != 0) {
            source.setPredefinedWorkspaceNames(workspaceNames);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        String sourceName = this.getName();
        if (sourceName == null || sourceName.trim().length() == 0) {
            I18n msg = SvnRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        String sourceUsername = this.getUsername();
        if (sourceUsername == null || sourceUsername.trim().length() == 0) {
            I18n msg = SvnRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getUsername(), msg.text(new Object[]{SVN_USERNAME}));
        }
        String sourcePassword = this.getPassword();
        if (sourcePassword == null) {
            I18n msg = SvnRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getPassword(), msg.text(new Object[]{SVN_PASSWORD}));
        }
        String repositoryRootURL = this.getRepositoryRootUrl();
        if (repositoryRootURL == null || repositoryRootURL.trim().length() == 0) {
            I18n msg = SvnRepositoryConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getRepositoryRootUrl(), msg.text(new Object[]{SVN_REPOSITORY_ROOT_URL}));
        }
        if ((repositoryRootURL = repositoryRootURL.trim()).endsWith("/")) {
            repositoryRootURL = repositoryRootURL + "/";
        }
        if (this.repository == null) {
            this.repository = new SvnRepository(this);
            ExecutionContext context = this.repositoryContext != null ? this.repositoryContext.getExecutionContext() : this.defaultContext;
            SvnRepository.SvnTransaction txn = this.repository.startTransaction(context, false);
            try {
                for (String initialName : this.getPredefinedWorkspaceNames()) {
                    this.repository.createWorkspace((Transaction)txn, initialName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, null);
                }
            }
            finally {
                txn.commit();
            }
        }
        return new Connection((BaseRepositorySource)this, (Repository)this.repository);
    }
}

