/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.connector.svn.SvnConnectorTestUtil;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.BasicCachePolicy;
import org.modeshape.graph.connector.MockRepositoryContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceException;

public class SvnRepositorySourceTest {
    private SvnRepositorySource source;
    private RepositoryConnection connection;
    private String validName;
    private static String url;
    private String username;
    private String password;
    private final ExecutionContext context = new ExecutionContext();

    @BeforeClass
    public static void beforeAny() throws Exception {
        url = SvnConnectorTestUtil.createTestRepoURL();
    }

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.source = new SvnRepositorySource();
        this.source.setName("Test Repository");
        this.source.setUsername("sp");
        this.source.setPassword("");
        this.source.setRepositoryRootUrl(url);
        this.source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldReturnNonNullCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldNotSupportSameNameSiblings() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsSameNameSiblings(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSupportUpdates() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveNullSourceNameUponConstruction() {
        this.source = new SvnRepositorySource();
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowSettingName() {
        this.source.setName("name you like");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"name you like"));
        this.source.setName("name you do not like");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"name you do not like"));
    }

    @Test
    public void shouldAllowSettingNameToNull() {
        this.source.setName("something that can change the world");
        this.source.setName(null);
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldHaveDefaultRetryLimit() {
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullSVNUrl() {
        this.source.setRepositoryRootUrl(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptySVNUrl() {
        this.source.setRepositoryRootUrl("");
    }

    @Test
    public void shouldSetRetryLimitToZeroWhenSetWithNonPositiveValue() {
        this.source.setRetryLimit(0);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-1);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-100);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAllowRetryLimitToBeSet() {
        for (int i = 0; i != 100; ++i) {
            this.source.setRetryLimit(i);
            Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)i));
        }
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoName() {
        this.source.setName(null);
        this.source.getConnection();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoUsername() {
        this.source.setUsername(null);
        this.source.getConnection();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoPassword() {
        this.source.setPassword(null);
        this.source.getConnection();
    }

    @Test
    public void shouldCreateConnection() throws Exception {
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReference() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference(this.validName, url, this.username, this.password, 100);
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReferenceWithNullProperties() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference("some source", "url1", null, null, 100);
        this.convertToAndFromJndiReference(null, "url2", null, null, 100);
    }

    private void convertToAndFromJndiReference(String sourceName, String url, String username, String password, int retryLimit) throws Exception {
        this.source.setRetryLimit(retryLimit);
        this.source.setName(sourceName);
        this.source.setRepositoryRootUrl(url);
        this.source.setUsername(username);
        this.source.setPassword(password);
        Reference ref = this.source.getReference();
        Assert.assertThat((Object)ref.getClassName(), (Matcher)Is.is((Object)SvnRepositorySource.class.getName()));
        Assert.assertThat((Object)ref.getFactoryClassName(), (Matcher)Is.is((Object)SvnRepositorySource.class.getName()));
        HashMap<String, Object> refAttributes = new HashMap<String, Object>();
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr addr = enumeration.nextElement();
            refAttributes.put(addr.getType(), addr.getContent());
        }
        Assert.assertThat((Object)((String)refAttributes.remove("sourceName")), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)((String)refAttributes.remove("repositoryRootURL")), (Matcher)Is.is((Object)this.source.getRepositoryRootUrl()));
        Assert.assertThat((Object)((String)refAttributes.remove("username")), (Matcher)Is.is((Object)this.source.getUsername()));
        Assert.assertThat((Object)((String)refAttributes.remove("password")), (Matcher)Is.is((Object)this.source.getPassword()));
        Assert.assertThat((Object)((String)refAttributes.remove("rootNodeUuid")), (Matcher)Is.is((Object)this.source.getRootNodeUuidObject().toString()));
        Assert.assertThat((Object)((String)refAttributes.remove("retryLimit")), (Matcher)Is.is((Object)Integer.toString(this.source.getRetryLimit())));
        Assert.assertThat((Object)((String)refAttributes.remove("allowCreatingWorkspaces")), (Matcher)Is.is((Object)Boolean.toString(this.source.isCreatingWorkspacesAllowed())));
        Assert.assertThat((Object)((String)refAttributes.remove("defaultWorkspace")), (Matcher)Is.is((Object)this.source.getDefaultWorkspaceName()));
        refAttributes.remove("predefinedWorkspaceNames");
        Assert.assertThat(refAttributes.remove("nodeCachePolicy"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)refAttributes.isEmpty(), (Matcher)Is.is((Object)true));
        SvnRepositorySource factory = new SvnRepositorySource();
        Name name = (Name)Mockito.mock(Name.class);
        Context context = (Context)Mockito.mock(Context.class);
        Hashtable env = new Hashtable();
        SvnRepositorySource recoveredSource = (SvnRepositorySource)factory.getObjectInstance(ref, name, context, env);
        Assert.assertThat((Object)recoveredSource, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)recoveredSource.getName(), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)recoveredSource.getRepositoryRootUrl(), (Matcher)Is.is((Object)this.source.getRepositoryRootUrl()));
        Assert.assertThat((Object)recoveredSource.getUsername(), (Matcher)Is.is((Object)this.source.getUsername()));
        Assert.assertThat((Object)recoveredSource.getPassword(), (Matcher)Is.is((Object)this.source.getPassword()));
        Assert.assertThat((Object)recoveredSource.equals((Object)this.source), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.source.equals((Object)recoveredSource), (Matcher)Is.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowMultipleConnectionsToBeOpenAtTheSameTime() throws Exception {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>();
        try {
            for (int i = 0; i != 10; ++i) {
                RepositoryConnection conn = this.source.getConnection();
                Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                connections.add(conn);
            }
        }
        finally {
            for (RepositoryConnection conn : connections) {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

