/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.TestEnvironment;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.WritableConnectorTest;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.Property;

public class SimpleJpaConnectorWritableTest
extends WritableConnectorTest {
    protected RepositorySource setUpSource() {
        JpaSource source = TestEnvironment.configureJpaSource("Test Repository", (Object)this);
        source.setModel(JpaSource.Models.SIMPLE.getName());
        source.setCompressData(true);
        return source;
    }

    protected void initializeContent(Graph graph) {
    }

    @Test
    @FixFor(value={"MODE-966"})
    public void shouldStoreLargeBinaryValue() throws Exception {
        File file = new File("src/test/resources/testdata/test1.xmi");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        BinaryFactory binaryFactory = this.context.getValueFactories().getBinaryFactory();
        Binary binaryValue = binaryFactory.create(file);
        ((Graph.Batch)((Graph.Batch)this.graph.batch().create("/someFile.xmi").with("jcr:primaryType", new Object[]{"nt:file"}).and()).create("/someFile.xmi/jcr:content").with("jcr:priamryType", new Object[]{"nt:resource"}).and("jcr:data", new Object[]{binaryValue}).and()).execute();
        Property data = (Property)this.graph.getProperty("jcr:data").on("/someFile.xmi/jcr:content");
        Binary readValue = (Binary)binaryFactory.create(data.getFirstValue());
        Assert.assertThat((Object)binaryValue.getHash(), (Matcher)Is.is((Object)readValue.getHash()));
        Assert.assertThat((Object)binaryValue.getBytes(), (Matcher)Is.is((Object)readValue.getBytes()));
    }
}

