/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.util;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hibernate.ejb.Ejb3Configuration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.connector.store.jpa.util.StoreOptionEntity;
import org.modeshape.connector.store.jpa.util.StoreOptions;

public class StoreOptionsTest {
    protected static EntityManagerFactory factory;
    protected static EntityManager manager;
    protected StoreOptions options;

    @BeforeClass
    public static void beforeAll() throws Exception {
        Ejb3Configuration configurator = new Ejb3Configuration();
        configurator.addAnnotatedClass(StoreOptionEntity.class);
        configurator.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        configurator.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        configurator.setProperty("hibernate.connection.username", "sa");
        configurator.setProperty("hibernate.connection.password", "");
        configurator.setProperty("hibernate.connection.url", "jdbc:hsqldb:.");
        configurator.setProperty("hibernate.show_sql", "false");
        configurator.setProperty("hibernate.format_sql", "true");
        configurator.setProperty("hibernate.use_sql_comments", "true");
        configurator.setProperty("hibernate.hbm2ddl.auto", "create");
        factory = configurator.buildEntityManagerFactory();
        manager = factory.createEntityManager();
    }

    @Before
    public void beforeEach() throws Exception {
        this.removeAllOptionEntities();
        this.options = new StoreOptions(manager);
    }

    @After
    public void afterEach() throws Exception {
        this.removeAllOptionEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void afterAll() throws Exception {
        try {
            manager.close();
        }
        finally {
            factory.close();
        }
    }

    protected void removeAllOptionEntities() {
        try {
            manager.getTransaction().begin();
            List<StoreOptionEntity> optionEntities = this.getAllOptionEntities();
            for (StoreOptionEntity entity : optionEntities) {
                manager.remove((Object)entity);
            }
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
    }

    protected List<StoreOptionEntity> getAllOptionEntities() {
        Query query = manager.createNamedQuery("StoreOptionEntity.findAll");
        return query.getResultList();
    }

    protected void assertNoOptions() {
        try {
            manager.getTransaction().begin();
            Assert.assertThat((Object)this.getAllOptionEntities().isEmpty(), (Matcher)Is.is((Object)true));
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
    }

    protected void assertOption(String name, String expectedValue) {
        try {
            manager.getTransaction().begin();
            String actualValue = this.options.getOption(name);
            Assert.assertThat((Object)expectedValue, (Matcher)Is.is((Object)actualValue));
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
    }

    protected void setOptionInTxn(String name, String value) {
        try {
            manager.getTransaction().begin();
            this.options.setOption(name, value);
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
        this.assertOption(name, value);
    }

    @Test
    public void shouldReturnNullForNonExistantOption() {
        this.assertNoOptions();
        Assert.assertThat((Object)this.options.getOption("non-existant name"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnValueForExistingOption() {
        this.setOptionInTxn("name1", "value1");
        try {
            manager.getTransaction().begin();
            Assert.assertThat((Object)this.options.getOption("name1"), (Matcher)Is.is((Object)"value1"));
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
    }

    @Test
    public void shouldSetValueOnExistingOption() {
        this.setOptionInTxn("name1", "value1");
        try {
            manager.getTransaction().begin();
            Assert.assertThat((Object)this.options.getOption("name1"), (Matcher)Is.is((Object)"value1"));
            this.options.setOption("name1", "value2");
            Assert.assertThat((Object)this.options.getOption("name1"), (Matcher)Is.is((Object)"value2"));
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
        this.assertOption("name1", "value2");
    }

    @Test
    public void shouldRemoveOptionWhenSetToNullValue() {
        this.setOptionInTxn("name1", "value1");
        try {
            manager.getTransaction().begin();
            Assert.assertThat((Object)this.options.getOption("name1"), (Matcher)Is.is((Object)"value1"));
            this.options.setOption("name1", null);
            Assert.assertThat((Object)this.options.getOption("name1"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
    }

    @Test
    public void shouldNotRemoveOptionWhenSetToEmptyValue() {
        this.setOptionInTxn("name1", "value1");
        try {
            manager.getTransaction().begin();
            Assert.assertThat((Object)this.options.getOption("name1"), (Matcher)Is.is((Object)"value1"));
            this.options.setOption("name1", "");
            Assert.assertThat((Object)this.options.getOption("name1"), (Matcher)Is.is((Object)""));
            manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            manager.getTransaction().rollback();
            throw t;
        }
    }
}

