/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.web.jcr.webdav.MultiRepositoryRequestResolver;
import org.modeshape.web.jcr.webdav.ResolvedRequest;

public class MultiRepositoryRequestResolverTest {
    private MultiRepositoryRequestResolver resolver;
    private ResolvedRequest resolved;
    @Mock
    private HttpServletRequest request;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"");
        this.resolver = new MultiRepositoryRequestResolver();
    }

    protected void setPath(String path) {
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)path);
    }

    protected void assertResolved(String repositoryName, String workspaceName, String path) {
        Assert.assertThat((Object)this.resolved, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.resolved.getRepositoryName(), (Matcher)Is.is((Object)repositoryName));
        Assert.assertThat((Object)this.resolved.getWorkspaceName(), (Matcher)Is.is((Object)workspaceName));
        Assert.assertThat((Object)this.resolved.getPath(), (Matcher)Is.is((Object)path));
    }

    protected void assertResolved(String urlPath, String repositoryName, String workspaceName, String path) {
        this.setPath(urlPath);
        this.resolved = this.resolver.resolve(this.request, urlPath);
        this.assertResolved(repositoryName, workspaceName, path);
    }

    @Test
    public void shouldResolveNullUrlPath() {
        this.assertResolved(null, null, null, null);
    }

    @Test
    public void shouldResolveEmptyUrlPath() {
        this.assertResolved("", null, null, null);
    }

    @Test
    public void shouldResolveUrlPathWithSlash() {
        this.assertResolved("/", null, null, null);
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepository() {
        this.assertResolved("/rep", "rep", null, null);
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepositoryAndSlash() {
        this.assertResolved("/rep/", "rep", null, null);
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepositoryAndWorkspace() {
        this.assertResolved("/rep/ws", "rep", "ws", "/");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepositoryAndWorkspaceAndSlash() {
        this.assertResolved("/rep/ws/", "rep", "ws", "/");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepositoryAndWorkspaceAndSingleSegmentPath() {
        this.assertResolved("/rep/ws/a", "rep", "ws", "/a");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepositoryAndWorkspaceAndMultipleSegmentPath() {
        this.assertResolved("/rep/ws/a/b/c", "rep", "ws", "/a/b/c");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepositoryAndBlankWorkspaceAndMultipleSegmentPath() {
        this.assertResolved("/rep//a/b/c", "rep", "", "/a/b/c");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndRepositoryAndBlankWorkspaceAndSlash() {
        this.assertResolved("/rep//", "rep", "", "/");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndBlankRepositoryAndBlankWorkspaceAndSlash() {
        this.assertResolved("///", "", "", "/");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndBlankRepositoryAndBlankWorkspaceAndSingleSegmentPath() {
        this.assertResolved("///a", "", "", "/a");
    }

    @Test
    public void shouldResolveUrlPathWithSlashAndBlankRepositoryAndBlankWorkspaceAndMultipleSegmentPath() {
        this.assertResolved("///a/b/c", "", "", "/a/b/c");
    }
}

