/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.util.Version;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryEngine;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.optimize.Optimizer;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.optimize.RuleBasedOptimizer;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.Planner;
import org.modeshape.graph.query.process.AbstractAccessComponent;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.Processor;
import org.modeshape.graph.query.process.QueryProcessor;
import org.modeshape.graph.query.process.QueryResults;
import org.modeshape.graph.query.process.SelectComponent;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.processor.RequestProcessor;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineIndexer;
import org.modeshape.graph.search.SearchEngineProcessor;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.query.RewritePseudoColumns;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneConfigurations;
import org.modeshape.search.lucene.LuceneSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RepositoryQueryManager {
    protected final String sourceName;
    protected final String repositoryName;

    RepositoryQueryManager(String repositoryName, String sourceName) {
        this.sourceName = sourceName;
        this.repositoryName = repositoryName;
    }

    public abstract org.modeshape.graph.query.QueryResults query(String var1, QueryCommand var2, Schemata var3, PlanHints var4, Map<String, Object> var5) throws InvalidQueryException;

    public abstract org.modeshape.graph.query.QueryResults search(String var1, String var2, int var3, int var4) throws InvalidQueryException;

    public void reindexContent() {
    }

    public void reindexContent(JcrWorkspace workspace) {
    }

    public void reindexContent(JcrWorkspace workspace, String path, int depth) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SelfContained
    extends RepositoryQueryManager {
        private static final Logger LOGGER = Logger.getLogger(RepositoryQueryManager.class);
        private final ExecutionContext context;
        private final String sourceName;
        private final LuceneConfiguration configuration;
        private final SearchEngine searchEngine;
        private final Observer searchObserver;
        private final ExecutorService service;
        private final QueryEngine queryEngine;
        private final RepositoryConnectionFactory connectionFactory;
        private final int maxDepthPerRead;

        SelfContained(String repositoryName, ExecutionContext context, String nameOfSourceToBeSearchable, RepositoryConnectionFactory connectionFactory, Observable observable, final RepositoryNodeTypeManager nodeTypeManager, String indexDirectory, boolean updateIndexesSynchronously, final boolean forceIndexRebuild, boolean rebuildIndexSynchronously, int maxDepthPerRead, ExecutorService backgrounder) throws RepositoryException {
            super(repositoryName, nameOfSourceToBeSearchable);
            this.context = context;
            this.sourceName = nameOfSourceToBeSearchable;
            this.connectionFactory = connectionFactory;
            this.maxDepthPerRead = maxDepthPerRead;
            UrlEncoder encoder = new UrlEncoder();
            if (indexDirectory != null) {
                File indexDir = new File(indexDirectory);
                if (indexDir.exists()) {
                    if (!indexDir.isDirectory()) {
                        I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesFileNotDirectory;
                        throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                    }
                    if (!indexDir.canWrite()) {
                        I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesDirectoryThatCannotBeWrittenTo;
                        throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                    }
                    if (!indexDir.canRead()) {
                        I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesDirectoryThatCannotBeRead;
                        throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                    }
                } else if (!indexDir.mkdirs()) {
                    I18n msg = JcrI18n.searchIndexDirectoryOptionSpecifiesDirectoryThatCannotBeCreated;
                    throw new RepositoryException(msg.text(new Object[]{indexDirectory, this.sourceName}));
                }
                this.configuration = LuceneConfigurations.using((File)indexDir, (TextEncoder)encoder, (TextEncoder)encoder);
            } else {
                this.configuration = LuceneConfigurations.inMemory();
            }
            assert (this.configuration != null);
            IndexRules.Factory indexRulesFactory = new IndexRules.Factory(){

                public IndexRules getRules() {
                    return nodeTypeManager.getRepositorySchemata().getIndexRules();
                }
            };
            EnglishAnalyzer analyzer = new EnglishAnalyzer(Version.LUCENE_30);
            boolean verifyWorkspaces = false;
            this.searchEngine = new LuceneSearchEngine(nameOfSourceToBeSearchable, connectionFactory, verifyWorkspaces, maxDepthPerRead, this.configuration, indexRulesFactory, (Analyzer)analyzer);
            if (updateIndexesSynchronously) {
                this.service = null;
                this.searchObserver = new Observer(){

                    public void notify(Changes changes) {
                        if (changes.getSourceName().equals(SelfContained.this.sourceName)) {
                            SelfContained.this.process(changes);
                        }
                    }
                };
            } else {
                ThreadFactory threadFactory = new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "modeshape-indexing");
                        thread.setPriority(8);
                        return thread;
                    }
                };
                this.service = Executors.newSingleThreadExecutor(threadFactory);
                this.searchObserver = new Observer(){

                    public void notify(final Changes changes) {
                        if (changes.getSourceName().equals(SelfContained.this.sourceName)) {
                            SelfContained.this.service.submit(new Runnable(){

                                public void run() {
                                    SelfContained.this.process(changes);
                                }
                            });
                        }
                    }
                };
            }
            observable.register(this.searchObserver);
            CanonicalPlanner planner = new CanonicalPlanner();
            RuleBasedOptimizer optimizer = new RuleBasedOptimizer(){

                protected void populateRuleStack(LinkedList<OptimizerRule> ruleStack, PlanHints hints) {
                    super.populateRuleStack(ruleStack, hints);
                    ruleStack.addFirst(RewritePseudoColumns.INSTANCE);
                }
            };
            QueryProcessor processor = new QueryProcessor(){

                protected ProcessingComponent createAccessComponent(QueryCommand originalQuery, QueryContext context, PlanNode accessNode, QueryResults.Columns resultColumns, SelectComponent.Analyzer analyzer) {
                    return new AccessQueryProcessor((GraphQueryContext)context, resultColumns, accessNode);
                }
            };
            this.queryEngine = new QueryEngine((Planner)planner, (Optimizer)optimizer, (Processor)processor);
            if (rebuildIndexSynchronously) {
                if (forceIndexRebuild) {
                    LOGGER.debug("Reindexing synchronously", new Object[0]);
                } else {
                    LOGGER.debug("Reindexing synchronously (if missing)", new Object[0]);
                }
                this.doReindexContent(forceIndexRebuild);
            } else {
                if (forceIndexRebuild) {
                    LOGGER.debug("Beginning to asynchronously reindex content", new Object[0]);
                } else {
                    LOGGER.debug("Beginning to asynchronously reindex content (if missing)", new Object[0]);
                }
                backgrounder.submit(new Runnable(){

                    public void run() {
                        SelfContained.this.doReindexContent(forceIndexRebuild);
                    }
                });
                LOGGER.trace("Returning after beginning to asynchrnously reindex content", new Object[0]);
            }
        }

        protected void process(Changes changes) {
            try {
                this.searchEngine.index(this.context, (Iterable)changes.getChangeRequests());
            }
            catch (RuntimeException e) {
                LOGGER.error((Throwable)e, JcrI18n.errorUpdatingQueryIndexes, new Object[]{e.getLocalizedMessage()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public org.modeshape.graph.query.QueryResults query(String workspaceName, QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) {
            TypeSystem typeSystem = this.context.getValueFactories().getTypeSystem();
            SearchEngineProcessor processor = this.searchEngine.createProcessor(this.context, null, true);
            try {
                GraphQueryContext context = new GraphQueryContext(schemata, typeSystem, hints, (Problems)new SimpleProblems(), variables, (RequestProcessor)processor, workspaceName);
                org.modeshape.graph.query.QueryResults queryResults = this.queryEngine.execute((QueryContext)context, query);
                return queryResults;
            }
            finally {
                processor.close();
            }
        }

        @Override
        public org.modeshape.graph.query.QueryResults search(String workspaceName, String searchExpression, int maxRowCount, int offset) {
            SearchEngineProcessor processor = this.searchEngine.createProcessor(this.context, null, true);
            FullTextSearchRequest request = new FullTextSearchRequest(searchExpression, workspaceName, maxRowCount, offset);
            processor.process(request);
            return new QueryResults(request.getResultColumns(), request.getStatistics(), request.getTuples());
        }

        @Override
        public void reindexContent() {
            this.doReindexContent(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doReindexContent(boolean force) {
            LOGGER.info(JcrI18n.indexRebuildingStarted, new Object[]{this.repositoryName});
            Set workspaces = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context).getWorkspaces();
            SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.searchEngine, this.connectionFactory, this.maxDepthPerRead);
            try {
                for (String workspace : workspaces) {
                    indexer.reindex(workspace, force);
                }
            }
            catch (Throwable throwable) {
                try {
                    indexer.close();
                }
                catch (Throwable throwable2) {
                    LOGGER.info(JcrI18n.indexRebuildingComplete, new Object[]{this.repositoryName});
                    throw throwable2;
                }
                LOGGER.info(JcrI18n.indexRebuildingComplete, new Object[]{this.repositoryName});
                throw throwable;
            }
            try {
                indexer.close();
            }
            catch (Throwable throwable) {
                LOGGER.info(JcrI18n.indexRebuildingComplete, new Object[]{this.repositoryName});
                throw throwable;
            }
            LOGGER.info(JcrI18n.indexRebuildingComplete, new Object[]{this.repositoryName});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reindexContent(JcrWorkspace workspace) {
            LOGGER.info(JcrI18n.indexRebuildingOfWorkspaceStarted, new Object[]{this.repositoryName, workspace.getName()});
            SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.searchEngine, this.connectionFactory, this.maxDepthPerRead);
            try {
                indexer.index(workspace.getName());
            }
            catch (Throwable throwable) {
                try {
                    indexer.close();
                }
                catch (Throwable throwable2) {
                    LOGGER.info(JcrI18n.indexRebuildingOfWorkspaceComplete, new Object[]{this.repositoryName, workspace.getName()});
                    throw throwable2;
                }
                LOGGER.info(JcrI18n.indexRebuildingOfWorkspaceComplete, new Object[]{this.repositoryName, workspace.getName()});
                throw throwable;
            }
            try {
                indexer.close();
            }
            catch (Throwable throwable) {
                LOGGER.info(JcrI18n.indexRebuildingOfWorkspaceComplete, new Object[]{this.repositoryName, workspace.getName()});
                throw throwable;
            }
            LOGGER.info(JcrI18n.indexRebuildingOfWorkspaceComplete, new Object[]{this.repositoryName, workspace.getName()});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reindexContent(JcrWorkspace workspace, String path, int depth) {
            Path at = (Path)workspace.context().getValueFactories().getPathFactory().create(path);
            SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.searchEngine, this.connectionFactory, this.maxDepthPerRead);
            try {
                indexer.index(workspace.getName(), at, depth);
            }
            finally {
                indexer.close();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class AccessQueryProcessor
        extends AbstractAccessComponent {
            private final AccessQueryRequest accessRequest;

            protected AccessQueryProcessor(GraphQueryContext context, QueryResults.Columns columns, PlanNode accessNode) {
                super((QueryContext)context, columns, accessNode);
                this.accessRequest = new AccessQueryRequest(context.getWorkspaceName(), this.sourceName, this.getColumns(), this.andedConstraints, this.limit, context.getSchemata(), context.getVariables());
            }

            public AccessQueryRequest getAccessRequest() {
                return this.accessRequest;
            }

            public List<Object[]> execute() {
                GraphQueryContext context = (GraphQueryContext)this.getContext();
                context.getProcessor().process(this.accessRequest);
                if (this.accessRequest.getError() != null) {
                    I18n msg = GraphI18n.errorWhilePerformingQuery;
                    this.getContext().getProblems().addError(this.accessRequest.getError(), msg, new Object[]{this.accessNode.getString(), this.accessRequest.workspace(), this.sourceName, this.accessRequest.getError().getLocalizedMessage()});
                    return this.emptyTuples();
                }
                return this.accessRequest.getTuples();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class GraphQueryContext
        extends QueryContext {
            private final RequestProcessor processor;
            private final String workspaceName;

            protected GraphQueryContext(Schemata schemata, TypeSystem typeSystem, PlanHints hints, Problems problems, Map<String, Object> variables, RequestProcessor processor, String workspaceName) {
                super(schemata, typeSystem, hints, problems, variables);
                this.processor = processor;
                this.workspaceName = workspaceName;
            }

            public RequestProcessor getProcessor() {
                return this.processor;
            }

            public String getWorkspaceName() {
                return this.workspaceName;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Disabled
    extends RepositoryQueryManager {
        Disabled(String repositoryName, String sourceName) {
            super(repositoryName, sourceName);
        }

        @Override
        public org.modeshape.graph.query.QueryResults query(String workspaceName, QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) throws InvalidQueryException {
            throw new InvalidQueryException(JcrI18n.queryIsDisabledInRepository.text(new Object[]{this.sourceName}));
        }

        @Override
        public org.modeshape.graph.query.QueryResults search(String workspaceName, String searchExpression, int maxRowCount, int offset) throws InvalidQueryException {
            throw new InvalidQueryException(JcrI18n.queryIsDisabledInRepository.text(new Object[]{this.sourceName}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PushDown
    extends RepositoryQueryManager {
        private final ExecutionContext context;
        private final RepositoryConnectionFactory connectionFactory;

        PushDown(String repositoryName, String sourceName, ExecutionContext context, RepositoryConnectionFactory connectionFactory) {
            super(repositoryName, sourceName);
            this.context = context;
            this.connectionFactory = connectionFactory;
        }

        private Graph workspaceGraph(String workspaceName) {
            Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context);
            if (workspaceName != null) {
                graph.useWorkspace(workspaceName);
            }
            return graph;
        }

        @Override
        public org.modeshape.graph.query.QueryResults query(String workspaceName, QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) {
            Graph.BuildQuery builder = this.workspaceGraph(workspaceName).query(query, schemata);
            if (variables != null) {
                builder.using(variables);
            }
            if (hints != null) {
                builder.using(hints);
            }
            return builder.execute();
        }

        @Override
        public org.modeshape.graph.query.QueryResults search(String workspaceName, String searchExpression, int maxRowCount, int offset) {
            return this.workspaceGraph(workspaceName).search(searchExpression, maxRowCount, offset);
        }
    }
}

