/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice.powerpoint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.modeshape.sequencer.msoffice.powerpoint.SlideDeckMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.SlideMetadata;

public class PowerPointMetadataReader {
    public static SlideDeckMetadata instance(InputStream stream) throws IOException {
        HSLFSlideShow rawSlideShow = new HSLFSlideShow(stream);
        SlideShow slideshow = new SlideShow(rawSlideShow);
        Slide[] slides = slideshow.getSlides();
        ArrayList<SlideMetadata> slidesMetadata = new ArrayList<SlideMetadata>();
        for (Slide slide : slides) {
            SlideMetadata slideMetadata = new SlideMetadata();
            slideMetadata.setTitle(slide.getTitle());
            for (TextRun textRun : slide.getNotesSheet().getTextRuns()) {
                if (slideMetadata.getNotes() == null) {
                    slideMetadata.setNotes("");
                }
                slideMetadata.setNotes(slideMetadata.getNotes() + textRun.getText());
            }
            for (TextRun textRun : slide.getTextRuns()) {
                if (textRun.getText().equals(slideMetadata.getTitle()) || textRun.getText() == null) continue;
                if (slideMetadata.getText() == null) {
                    slideMetadata.setText("");
                }
                slideMetadata.setText(slideMetadata.getText() + textRun.getText());
            }
            Dimension pgsize = slideshow.getPageSize();
            BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
            slide.draw(graphics);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", out);
            slideMetadata.setThumbnail(out.toByteArray());
            slidesMetadata.add(slideMetadata);
        }
        SlideDeckMetadata deck = new SlideDeckMetadata();
        deck.setHeadings(slidesMetadata);
        deck.setMetadata(rawSlideShow.getSummaryInformation());
        return deck;
    }
}

