/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.sequencer.AbstractStreamSequencerTest;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.sequencer.teiid.VdbSequencer;

public class VdbSequencerTest
extends AbstractStreamSequencerTest {
    protected StreamSequencer createSequencer() {
        return new VdbSequencer();
    }

    @Test
    public void shouldSequenceVdbForQuickEmployees() throws Exception {
        this.sequence("vdb/qe.vdb");
        this.assertNoProblems();
        this.printOutput();
    }

    @Test
    public void shouldSequenceVdbForQuickEmployeesWithVersionSpecifiedInFileName() throws Exception {
        this.sequence("vdb/qe.2.vdb");
        this.assertNoProblems();
        this.printOutput();
    }

    @Test
    public void shouldSequenceVdbForPartsFromXml() throws Exception {
        this.sequence("vdb/PartsFromXml.vdb");
        this.assertNoProblems();
        this.printOutput();
    }

    @Test
    public void shouldSequenceVdbForYahooUdfTest() throws Exception {
        this.sequence("vdb/YahooUdfTest.vdb");
        this.assertNoProblems();
        this.printOutput();
    }

    @Test
    public void shouldExtractVersionInformation() {
        this.assertVersionInfo("something", "something", 1);
        this.assertVersionInfo("something.else", "something.else", 1);
        this.assertVersionInfo("something else", "something else", 1);
        this.assertVersionInfo("something.", "something", 1);
        this.assertVersionInfo("something.1", "something", 1);
        this.assertVersionInfo("something.12", "something", 12);
        this.assertVersionInfo("something.123", "something", 123);
        this.assertVersionInfo("something.4", "something", 4);
        this.assertVersionInfo("something.-4", "something", 4);
        this.assertVersionInfo("something.+4", "something", 4);
        this.assertVersionInfo("something. 4", "something", 4);
        this.assertVersionInfo("something.  4", "something", 4);
        this.assertVersionInfo("something.  -4", "something", 4);
        this.assertVersionInfo("something.  -1234  ", "something", 1234);
    }

    protected void assertVersionInfo(String fileNameWithoutExtension, String expectedName, int expectedVersion) {
        AtomicInteger actual = new AtomicInteger(1);
        Name name = VdbSequencer.extractVersionInfomation((ExecutionContext)this.context, (String)fileNameWithoutExtension, (AtomicInteger)actual);
        Assert.assertThat((Object)name, (Matcher)Is.is((Object)this.context.getValueFactories().getNameFactory().create(expectedName)));
        Assert.assertThat((Object)actual.get(), (Matcher)Is.is((Object)expectedVersion));
    }
}

