/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.process.AbstractQueryResultsTest;
import org.modeshape.graph.query.process.QueryResultColumns;
import org.modeshape.graph.query.process.QueryResults;
import org.modeshape.graph.query.validate.Schemata;

public class QueryResultColumnsTest
extends AbstractQueryResultsTest {
    private QueryContext context;
    private List<Column> columnList;
    private List<String> columnTypes;
    private QueryResults.Columns columns;
    private QueryResults results;
    private List<Object[]> tuples;
    @Mock
    private Schemata schemata;
    @Mock
    private QueryResults.Statistics statistics;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new QueryContext(this.schemata, this.typeSystem);
        this.columnList = new ArrayList<Column>();
        this.columnList.add(new Column(this.selector("table1"), "colA", "colA"));
        this.columnList.add(new Column(this.selector("table1"), "colB", "colB"));
        this.columnList.add(new Column(this.selector("table1"), "colC", "colC"));
        this.columnList.add(new Column(this.selector("table2"), "colA", "colA2"));
        this.columnList.add(new Column(this.selector("table2"), "colB", "colB2"));
        this.columnList.add(new Column(this.selector("table2"), "colX", "colX"));
        this.columnTypes = new ArrayList<String>();
        for (int i = 0; i != this.columnList.size(); ++i) {
            this.columnTypes.add(PropertyType.STRING.getName());
        }
        this.columns = new QueryResultColumns(this.columnList, this.columnTypes, false);
        this.tuples = new ArrayList<Object[]>();
        this.tuples.add(this.tuple(this.columns, new String[]{"/a/b/c", "/a/x/y"}, 1, 2, 3, "2a", "2b", "x"));
        this.tuples.add(this.tuple(this.columns, new String[]{"/a/b/d", "/a/x/y"}, 4, 5, 6, "2a", "2b", "x"));
        this.results = new QueryResults(this.columns, this.statistics, this.context.getProblems());
    }

    @Test
    public void shouldReturnSameColumnsPassedIntoConstructor() {
        Assert.assertThat((Object)this.results.getColumns(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.columns)));
    }

    @Test
    public void shouldReturnSameStatisticsPassedIntoConstructor() {
        Assert.assertThat((Object)this.results.getStatistics(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.statistics)));
    }

    @Test
    public void shouldReturnSameProblemsObjectAsInQueryContext() {
        Assert.assertThat((Object)this.results.getProblems(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.context.getProblems())));
    }

    @Test
    public void shouldReturnSameTuplesListPassedIntoConstructor() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        Assert.assertThat((Object)this.results.getTuples(), (Matcher)Is.is((Matcher)IsSame.sameInstance(this.tuples)));
    }

    @Test
    public void shouldHaveNoTuplesIfConstructedWithNoTuples() {
        Assert.assertThat((Object)this.results.getTuples().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.results.getCursor().hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveNoTuplesIfConstructedWithEmptyTuplesList() {
        this.tuples.clear();
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        Assert.assertThat((Object)this.results.getTuples().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.results.getCursor().hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnMutableTuplesList() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        Assert.assertThat((Object)this.results.getTuples().isEmpty(), (Matcher)Is.is((Object)false));
        this.results.getTuples().clear();
        Assert.assertThat((Object)this.results.getTuples().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tuples.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnCursorThatAccessesTuples() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        QueryResults.Cursor cursor = this.results.getCursor();
        Iterator<Object[]> expectedIter = this.tuples.iterator();
        int rowNumber = 0;
        while (cursor.hasNext() && expectedIter.hasNext()) {
            cursor.next();
            Object[] tuple = expectedIter.next();
            for (Column column : this.results.getColumns().getColumns()) {
                String columnName = column.columnName();
                int columnIndex = this.columns.getColumnIndexForName(columnName);
                Assert.assertThat((Object)cursor.getValue(columnName), (Matcher)Is.is((Object)tuple[columnIndex]));
                Assert.assertThat((Object)cursor.getValue(columnIndex), (Matcher)Is.is((Object)tuple[columnIndex]));
                int locationIndex = this.columns.getLocationIndex(column.selectorName().name());
                Location location = (Location)tuple[locationIndex];
                Assert.assertThat((Object)cursor.getLocation(columnIndex), (Matcher)Is.is((Object)location));
            }
            for (String selectorName : this.results.getColumns().getSelectorNames()) {
                int locationIndex = this.columns.getLocationIndex(selectorName);
                Location location = (Location)tuple[locationIndex];
                Assert.assertThat((Object)cursor.getLocation(selectorName), (Matcher)Is.is((Object)location));
                Assert.assertThat((Object)location.hasPath(), (Matcher)Is.is((Object)true));
            }
            Assert.assertThat((Object)cursor.getRowIndex(), (Matcher)Is.is((Object)rowNumber++));
        }
        Assert.assertThat((Object)cursor.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)expectedIter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireNextOnCursorToBeCalledBeforeGettingValueUsingColumnIndex() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        QueryResults.Cursor cursor = this.results.getCursor();
        Assert.assertThat((Object)cursor.hasNext(), (Matcher)Is.is((Object)true));
        cursor.getValue(0);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireNextOnCursorToBeCalledBeforeGettingValueUsingColumnName() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        QueryResults.Cursor cursor = this.results.getCursor();
        Assert.assertThat((Object)cursor.hasNext(), (Matcher)Is.is((Object)true));
        cursor.getValue("colA");
    }

    @Test
    public void shouldPrintToStringAllResults() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        List lines = StringUtil.splitLines((String)this.results.toString());
        Assert.assertThat((Object)lines.size(), (Matcher)Is.is((Object)(this.tuples.size() + 4)));
    }

    @Test
    public void shouldPrintToStringBuilderAllResults() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        StringBuilder sb = new StringBuilder();
        this.results.toString(this.typeSystem, sb);
        List lines = StringUtil.splitLines((String)sb.toString());
        Assert.assertThat((Object)lines.size(), (Matcher)Is.is((Object)(this.tuples.size() + 4)));
    }

    @Test
    public void shouldPrintToStringBuilderAllResultsEvenWhenNoTuples() {
        this.tuples.clear();
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        StringBuilder sb = new StringBuilder();
        this.results.toString(this.typeSystem, sb);
        List lines = StringUtil.splitLines((String)sb.toString());
        Assert.assertThat((Object)lines.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldPrintToStringBuilderOnlyFirstLinesOfResults() {
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        StringBuilder sb = new StringBuilder();
        this.results.toString(this.typeSystem, sb, 1);
        List lines = StringUtil.splitLines((String)sb.toString());
        Assert.assertThat((Object)lines.size(), (Matcher)Is.is((Object)5));
    }

    @Test
    public void shouldPrintToStringBuilderOnlyFirstLinesOfResultsEvenWhenNoTuples() {
        this.tuples.clear();
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        StringBuilder sb = new StringBuilder();
        this.results.toString(this.typeSystem, sb, 3);
        List lines = StringUtil.splitLines((String)sb.toString());
        Assert.assertThat((Object)lines.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldPrintToStringBuilderAllResultsWhenMaxRowParameterIsLargerThanNumberOfTuples() {
        this.tuples.clear();
        this.results = new QueryResults(this.columns, this.statistics, this.tuples, this.context.getProblems(), null);
        StringBuilder sb = new StringBuilder();
        this.results.toString(this.typeSystem, sb, 3);
        List lines = StringUtil.splitLines((String)sb.toString());
        Assert.assertThat((Object)lines.size(), (Matcher)Is.is((Object)(this.tuples.size() + 4)));
    }
}

