/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriInfoImpl
implements UriInfo {
    private String path;
    private String encodedPath;
    private MultivaluedMap<String, String> queryParameters;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> pathParameters;
    private MultivaluedMap<String, String> encodedPathParameters;
    private MultivaluedMap<String, PathSegment[]> pathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
    private MultivaluedMap<String, PathSegment[]> encodedPathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
    private List<PathSegment> pathSegments;
    private List<PathSegment> encodedPathSegments;
    private URI absolutePath;
    private URI absolutePathWithQueryString;
    private URI baseURI;
    private String queryString;
    private List<String> matchedUris;
    private List<String> encodedMatchedUris;
    private List<Object> ancestors;

    public UriInfoImpl(URI absolutePath, URI baseUri, String encodedPath, String queryString, List<PathSegment> encodedPathSegments) {
        this.encodedPath = encodedPath;
        try {
            this.path = URLDecoder.decode(encodedPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.absolutePath = absolutePath;
        this.queryParameters = new MultivaluedMapImpl<String, String>();
        this.encodedQueryParameters = new MultivaluedMapImpl<String, String>();
        this.extractParameters(queryString);
        this.encodedPathParameters = new MultivaluedMapImpl<String, String>();
        this.pathParameters = new MultivaluedMapImpl<String, String>();
        this.encodedPathSegments = encodedPathSegments;
        this.pathSegments = new ArrayList<PathSegment>(encodedPathSegments.size());
        this.baseURI = baseUri;
        for (PathSegment segment : encodedPathSegments) {
            try {
                this.pathSegments.add(new PathSegmentImpl(URLDecoder.decode(((PathSegmentImpl)segment).getOriginal(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        this.queryString = queryString;
        this.absolutePathWithQueryString = queryString == null ? absolutePath : URI.create(absolutePath.toString() + "?" + queryString);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPath(boolean decode) {
        if (decode) {
            return this.getPath();
        }
        return this.encodedPath;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        if (this.pathSegments != null) {
            return this.pathSegments;
        }
        this.pathSegments = PathSegmentImpl.parseSegments(this.getPath());
        return this.pathSegments;
    }

    @Override
    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.getPathSegments();
        }
        return this.encodedPathSegments;
    }

    @Override
    public URI getRequestUri() {
        return this.absolutePathWithQueryString;
    }

    @Override
    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri(this.absolutePathWithQueryString);
    }

    @Override
    public URI getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri(this.absolutePath);
    }

    @Override
    public URI getBaseUri() {
        return this.baseURI;
    }

    @Override
    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri(this.baseURI);
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public void addEncodedPathParameter(String name, String value) {
        this.encodedPathParameters.add(name, value);
        try {
            String value1 = URLDecoder.decode(value, "UTF-8");
            this.pathParameters.add(name, value1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public MultivaluedMap<String, PathSegment[]> getEncodedPathParameterPathSegments() {
        return this.encodedPathParameterPathSegments;
    }

    public MultivaluedMap<String, PathSegment[]> getPathParameterPathSegments() {
        return this.pathParameterPathSegments;
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            return this.getPathParameters();
        }
        return this.encodedPathParameters;
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.queryParameters;
        }
        return this.encodedQueryParameters;
    }

    protected void extractParameters(String queryString) {
        String[] params;
        if (queryString == null || queryString.equals("")) {
            return;
        }
        for (String param : params = queryString.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=");
                try {
                    String name = URLDecoder.decode(nv[0], "UTF-8");
                    String val = nv.length > 1 ? nv[1] : "";
                    this.encodedQueryParameters.add(name, val);
                    this.queryParameters.add(name, URLDecoder.decode(val, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String name = URLDecoder.decode(param, "UTF-8");
                this.encodedQueryParameters.add(name, "");
                this.queryParameters.add(name, "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<String> getMatchedURIs(boolean decode) {
        if (decode) {
            if (this.matchedUris == null) {
                this.matchedUris = new ArrayList<String>();
            }
            return this.matchedUris;
        }
        if (this.encodedMatchedUris == null) {
            this.encodedMatchedUris = new ArrayList<String>();
        }
        return this.encodedMatchedUris;
    }

    @Override
    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    @Override
    public List<Object> getMatchedResources() {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<Object>();
        }
        return this.ancestors;
    }

    public void pushCurrentResource(Object resource) {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<Object>();
        }
        this.ancestors.add(0, resource);
    }

    public void popCurrentResource() {
        if (this.ancestors != null && this.ancestors.size() > 0) {
            this.ancestors.remove(0);
        }
    }

    public void pushMatchedURI(String encoded, String decoded) {
        if (this.encodedMatchedUris == null) {
            this.encodedMatchedUris = new ArrayList<String>();
        }
        this.encodedMatchedUris.add(0, encoded);
        if (this.matchedUris == null) {
            this.matchedUris = new ArrayList<String>();
        }
        this.matchedUris.add(0, decoded);
    }

    public void popMatchedURI() {
        if (this.encodedMatchedUris != null && this.encodedMatchedUris.size() > 0) {
            this.encodedMatchedUris.remove(0);
        }
        if (this.matchedUris != null && this.matchedUris.size() > 0) {
            this.matchedUris.remove(0);
        }
    }

    public String getConnegExtension() {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }
}

