/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.i18n.I18n;

public abstract class AbstractI18nTest {
    private Class<?> i18nClass;
    protected static final String[] ANNOTATION_NAMES = new String[]{"Description", "Category", "Label"};

    protected AbstractI18nTest(Class<?> i18nClass) {
        this.i18nClass = i18nClass;
    }

    @Test
    public void shouldNotHaveProblems() throws Exception {
        for (Field fld : this.i18nClass.getDeclaredFields()) {
            I18n i18n;
            if (fld.getType() != I18n.class || (fld.getModifiers() & 1) != 1 || (fld.getModifiers() & 8) != 8 || (fld.getModifiers() & 0x10) == 16 || !(i18n = (I18n)fld.get(null)).hasProblem()) continue;
            Assert.fail((String)i18n.problem());
        }
        Set locales = I18n.getLocalizationProblemLocales(this.i18nClass);
        if (!locales.isEmpty()) {
            for (Locale locale : locales) {
                Set problems = I18n.getLocalizationProblems(this.i18nClass, (Locale)locale);
                try {
                    Assert.assertThat((Object)problems.isEmpty(), (Matcher)Is.is((Object)true));
                }
                catch (AssertionError error) {
                    Assert.fail((String)((String)problems.iterator().next()));
                }
            }
        }
    }

    protected void verifyI18nForAnnotationsOnObject(Object annotated) throws Exception {
        Class<?> clazz = annotated.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                this.verifyI18nForAnnotation(annotation, field);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            for (Annotation annotation : accessibleObject.getAnnotations()) {
                this.verifyI18nForAnnotation(annotation, accessibleObject);
            }
        }
    }

    protected void verifyI18nForAnnotation(Annotation annotation, Object annotatedObject) throws Exception {
        String i18nIdentifier;
        Class i18nClass;
        if (annotation instanceof Category) {
            Category cat = (Category)annotation;
            i18nClass = cat.i18n();
            i18nIdentifier = cat.value();
        } else if (annotation instanceof Description) {
            Description desc = (Description)annotation;
            i18nClass = desc.i18n();
            i18nIdentifier = desc.value();
        } else if (annotation instanceof Label) {
            Label label = (Label)annotation;
            i18nClass = label.i18n();
            i18nIdentifier = label.value();
        } else {
            return;
        }
        Assert.assertThat((Object)i18nClass, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)i18nIdentifier, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            I18n i18n;
            Field fld = i18nClass.getField(i18nIdentifier);
            Assert.assertThat((Object)fld, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            if (fld.getType() == I18n.class && (fld.getModifiers() & 1) == 1 && (fld.getModifiers() & 8) == 8 && (fld.getModifiers() & 0x10) != 16 && (i18n = (I18n)fld.get(null)).hasProblem()) {
                Assert.fail((String)i18n.problem());
            }
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Missing I18n field on " + i18nClass.getName() + " for " + annotation + " on " + annotatedObject));
        }
    }
}

