/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.query.RowIterator;
import org.mockito.Mockito;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.QueryResultNodeIterator;
import org.modeshape.jdbc.QueryResultRowIterator;

public class TestUtil {
    public static final String STRING = PropertyType.nameFromValue((int)1).toUpperCase();
    public static final String DOUBLE = PropertyType.nameFromValue((int)4).toUpperCase();
    public static final String LONG = PropertyType.nameFromValue((int)3).toUpperCase();
    public static final String BOOLEAN = PropertyType.nameFromValue((int)6).toUpperCase();
    public static final String DATE = PropertyType.nameFromValue((int)5).toUpperCase();
    public static final String PATH = PropertyType.nameFromValue((int)1).toUpperCase();
    public static final String BINARY = PropertyType.nameFromValue((int)2).toUpperCase();
    public static final String REFERENCE = PropertyType.nameFromValue((int)9).toUpperCase();
    public static String[] COLUMN_NAMES;
    public static String TIME_ZONE;
    public static DateFormat DATETIME_FORMAT;
    public static DateFormat DATE_FORMAT;
    public static DateFormat TIME_FORMAT;
    public static String USE_TIMESTAMP_FOR_SOURCE;
    public static String USE_TIME_FOR_SOURCE;
    public static String USE_DATE_FOR_SOURCE;
    public static String EXPECTED_TIMESTAMP_FOR_TARGET;
    public static String EXPECTED_TIME_FOR_TARGET;
    public static String EXPECTED_DATE_FOR_TARGET;
    public static String EXPECTED_TIMEZONE;
    public static String[] TABLE_NAMES;
    public static String[] TYPE_NAMES;
    public static String[] NODE_NAMES;
    public static List<Object[]> TUPLES;
    public static final String SQL_SELECT = "Select propA FROM typeA";
    public static final String DRIVER_VERSION;

    private static Calendar createTestCalendar() {
        GregorianCalendar cal_instance = new GregorianCalendar();
        cal_instance.clear();
        ((Calendar)cal_instance).setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        cal_instance.set(2, 5);
        cal_instance.set(5, 30);
        cal_instance.set(1, 2004);
        cal_instance.set(11, 2);
        cal_instance.set(12, 39);
        cal_instance.set(13, 10);
        cal_instance.set(14, 201);
        cal_instance.set(9, 0);
        return cal_instance;
    }

    static Node[] createNodes() {
        Node[] nodes = new Node[NODE_NAMES.length];
        for (int i = 0; i < NODE_NAMES.length; ++i) {
            Node n = (Node)Mockito.mock(Node.class);
            try {
                Mockito.when((Object)n.getName()).thenReturn((Object)NODE_NAMES[i]);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            nodes[i] = n;
        }
        return nodes;
    }

    public static int minorVersion() {
        String[] coords = DRIVER_VERSION.split("[.-]");
        int major = Integer.parseInt(coords[0]);
        int minor = Integer.parseInt(coords[1]);
        return minor;
    }

    public static int majorVersion() {
        String[] coords = DRIVER_VERSION.split("[.-]");
        int major = Integer.parseInt(coords[0]);
        return major;
    }

    public static javax.jcr.query.QueryResult createQueryResult() {
        final Node[] nodes = TestUtil.createNodes();
        QueryResult qr = new QueryResult(){

            public String[] getColumnNames() {
                String[] cns = new String[COLUMN_NAMES.length];
                System.arraycopy(COLUMN_NAMES, 0, cns, 0, COLUMN_NAMES.length);
                return cns;
            }

            public NodeIterator getNodes() {
                ArrayList<Node> nodeArray = new ArrayList<Node>();
                for (int i = 0; i < nodes.length; ++i) {
                    nodeArray.add(nodes[i]);
                }
                return new QueryResultNodeIterator(nodeArray);
            }

            public RowIterator getRows() {
                ArrayList<Object[]> tuplesArray = new ArrayList<Object[]>(TUPLES);
                QueryResultRowIterator ri = new QueryResultRowIterator(nodes, TestUtil.SQL_SELECT, tuplesArray.iterator(), tuplesArray.size());
                return ri;
            }

            public String[] getColumnTypes() {
                return null;
            }

            public String[] getSelectorNames() {
                return null;
            }
        };
        return qr;
    }

    static {
        TIME_ZONE = "Europe/London";
        DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        TIME_FORMAT = new SimpleDateFormat("HH:mm:ss a");
        USE_TIMESTAMP_FOR_SOURCE = "2004-06-30 02:39:10.201";
        USE_TIME_FOR_SOURCE = "02:39:10";
        USE_DATE_FOR_SOURCE = "2004-06-30";
        EXPECTED_TIMESTAMP_FOR_TARGET = "2004-06-29 20:39:10.201";
        EXPECTED_TIME_FOR_TARGET = "20:39:10";
        EXPECTED_DATE_FOR_TARGET = "2004-06-29";
        EXPECTED_TIMEZONE = "America/Chicago";
        DRIVER_VERSION = JdbcLocalI18n.driverVersion.text(new Object[0]);
        Calendar cal_instance = TestUtil.createTestCalendar();
        COLUMN_NAMES = new String[]{"propA", "propB", "propC", "propD", "propE", "propF", "propG", "propH", "propI"};
        TABLE_NAMES = new String[]{"typeA", "typeB", "typeA", "", "typeA"};
        TYPE_NAMES = new String[]{STRING, LONG, PATH, REFERENCE, DOUBLE, BOOLEAN, DATE, BINARY, LONG};
        NODE_NAMES = new String[]{"node1", "node2"};
        TUPLES = new ArrayList<Object[]>();
        TUPLES.add(new Object[]{"r1c1", new Long(1L), null, null, new Double(1.0), new Boolean(true), cal_instance, new String("Heres my data at r1").getBytes(), null});
        cal_instance = TestUtil.createTestCalendar();
        TUPLES.add(new Object[]{"r2c1", new Long(2L), null, null, new Double(2.0), new Boolean(false), cal_instance, new String("Heres my data r2   ").getBytes(), null});
        cal_instance = TestUtil.createTestCalendar();
        TUPLES.add(new Object[]{"r3c1", new Long(3L), null, null, new Double(3.0), new Boolean(true), cal_instance, new String("Heres my data at r3  ").getBytes(), null});
        cal_instance = TestUtil.createTestCalendar();
        TUPLES.add(new Object[]{"r4c1", 4L, null, null, 4.0, (boolean)new Boolean(true), cal_instance, new String("Heres  my  data    r4  ").getBytes(), null});
    }

    public static interface COLUMN_NAME_PROPERTIES {
        public static final String PROP_A = "propA";
        public static final String PROP_B = "propB";
        public static final String PROP_C = "propC";
        public static final String PROP_D = "propD";
        public static final String PROP_E = "propE";
        public static final String PROP_F = "propF";
        public static final String PROP_G = "propG";
        public static final String PROP_H = "propH";
        public static final String PROP_I = "propI";
    }
}

