/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.map;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.map.MapRepository;
import org.modeshape.graph.connector.map.MapRepositorySource;
import org.modeshape.graph.connector.map.MapRepositoryTransaction;
import org.modeshape.graph.connector.map.MapRequestProcessor;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.Request;

public class MapRepositoryConnection
implements RepositoryConnection {
    private final MapRepositorySource source;
    private final MapRepository repository;

    public MapRepositoryConnection(MapRepositorySource source, MapRepository repository) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Stopwatch sw;
        Logger logger;
        block46: {
            MapRepositoryTransaction txn;
            boolean commit;
            MapRequestProcessor processor;
            block42: {
                RepositoryContext repositoryContext;
                logger = context.getLogger(this.getClass());
                sw = null;
                if (logger.isTraceEnabled()) {
                    sw = new Stopwatch();
                    sw.start();
                }
                Observer observer = (repositoryContext = this.source.getRepositoryContext()) != null ? repositoryContext.getObserver() : null;
                processor = new MapRequestProcessor(context, this.repository, observer, this.source.areUpdatesAllowed());
                commit = true;
                txn = this.repository.startTransaction(request.isReadOnly());
                processor.process(request);
                if (!request.hasError() || request.isReadOnly()) break block42;
                commit = false;
            }
            Object var12_10 = null;
            try {
                processor.close();
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    if (commit && !request.hasError() && !request.isFrozen()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
                throw throwable;
            }
            try {
                if (commit) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (Throwable commitOrRollbackError) {
                if (commit && !request.hasError() && !request.isFrozen()) {
                    request.setError(commitOrRollbackError);
                }
                commit = false;
            }
            if (commit) {
                processor.notifyObserverOfChanges();
            }
            break block46;
            {
                catch (Throwable error) {
                    commit = false;
                    Object var12_11 = null;
                    try {
                        processor.close();
                        Object var14_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        try {
                            if (commit) {
                                txn.commit();
                            } else {
                                txn.rollback();
                            }
                        }
                        catch (Throwable commitOrRollbackError) {
                            if (commit && !request.hasError() && !request.isFrozen()) {
                                request.setError(commitOrRollbackError);
                            }
                            commit = false;
                        }
                        if (commit) {
                            processor.notifyObserverOfChanges();
                        }
                        throw throwable;
                    }
                    try {
                        if (commit) {
                            txn.commit();
                        } else {
                            txn.rollback();
                        }
                    }
                    catch (Throwable commitOrRollbackError) {
                        if (commit && !request.hasError() && !request.isFrozen()) {
                            request.setError(commitOrRollbackError);
                        }
                        commit = false;
                    }
                    if (commit) {
                        processor.notifyObserverOfChanges();
                    }
                    break block46;
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    processor.close();
                    Object var14_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_18 = null;
                    try {
                        if (commit) {
                            txn.commit();
                        } else {
                            txn.rollback();
                        }
                    }
                    catch (Throwable commitOrRollbackError) {
                        if (commit && !request.hasError() && !request.isFrozen()) {
                            request.setError(commitOrRollbackError);
                        }
                        commit = false;
                    }
                    if (commit) {
                        processor.notifyObserverOfChanges();
                    }
                    throw throwable2;
                }
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    if (commit && !request.hasError() && !request.isFrozen()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
                throw throwable;
            }
        }
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace("MapRepositoryConnection.execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public String toString() {
        return "Connection to the \"" + this.getSourceName() + "\" " + this.repository.getClass().getSimpleName();
    }
}

