/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.UUID;
import java.util.regex.Pattern;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractValueFactory;
import org.modeshape.graph.property.basic.BasicPath;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.ChildPath;
import org.modeshape.graph.property.basic.IdentifierPath;
import org.modeshape.graph.property.basic.IdentifierPathSegment;
import org.modeshape.graph.property.basic.RootPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class PathValueFactory
extends AbstractValueFactory<Path>
implements PathFactory {
    protected static final Pattern DELIMITER_PATTERN = Pattern.compile("/");
    protected static final Pattern SEGMENT_PATTERN = Pattern.compile("([^:/]+)(:([^/\\[\\]]+))?(\\[(\\d+)])?");
    private final ValueFactory<Name> nameValueFactory;

    public PathValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory, ValueFactory<Name> nameValueFactory) {
        super(PropertyType.PATH, decoder, stringValueFactory);
        CheckArg.isNotNull(nameValueFactory, (String)"nameValueFactory");
        this.nameValueFactory = nameValueFactory;
    }

    protected ValueFactory<Name> getNameValueFactory() {
        return this.nameValueFactory;
    }

    @Override
    public Path createRootPath() {
        return RootPath.INSTANCE;
    }

    @Override
    public Path create(String value) {
        return this.create(value, this.getDecoder());
    }

    @Override
    public Path create(String value, TextDecoder decoder) {
        char firstChar;
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        int length = trimmedValue.length();
        boolean absolute = false;
        if (length == 0) {
            return BasicPath.EMPTY_RELATIVE;
        }
        if (length == 1) {
            if (Path.DELIMITER_STR.equals(trimmedValue)) {
                return RootPath.INSTANCE;
            }
            if (".".equals(trimmedValue)) {
                return BasicPath.SELF_PATH;
            }
        } else if (length == 2 && "..".equals(trimmedValue)) {
            return BasicPath.PARENT_PATH;
        }
        if ((firstChar = trimmedValue.charAt(0)) == '[' && trimmedValue.charAt(length - 1) == ']') {
            String id = trimmedValue.substring(1, length - 1);
            Name idName = this.nameValueFactory.create(id);
            return new IdentifierPath(new IdentifierPathSegment(idName));
        }
        if (firstChar == '/') {
            trimmedValue = length > 1 ? trimmedValue.substring(1) : "";
            --length;
            absolute = true;
        }
        if (length > 0 && trimmedValue.charAt(length - 1) == '/') {
            trimmedValue = length > 1 ? trimmedValue.substring(0, length - 1) : "";
            length = trimmedValue.length();
        }
        if (length == 0) {
            return RootPath.INSTANCE;
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        String[] pathSegments = this.splitPath(trimmedValue);
        if (pathSegments.length == 0) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.validPathMayNotContainEmptySegment.text(new Object[]{value}));
        }
        if (decoder == null) {
            decoder = this.getDecoder();
        }
        assert (pathSegments.length != 0);
        assert (decoder != null);
        for (String segment : pathSegments) {
            assert (segment != null);
            if ((segment = segment.trim()).length() == 0) {
                throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.validPathMayNotContainEmptySegment.text(new Object[]{value}));
            }
            segments.add(this.createSegment(segment, decoder));
        }
        if (absolute && segments.size() == 1) {
            return new ChildPath(RootPath.INSTANCE, (Path.Segment)segments.get(0));
        }
        return new BasicPath(segments, absolute);
    }

    String[] splitPath(String rawPath) {
        LinkedList<String> segments = new LinkedList<String>();
        int curr = 0;
        int nextBrace = rawPath.indexOf(123);
        int nextSlash = rawPath.indexOf(47);
        while (true) {
            if (nextSlash == -1 && nextBrace > -1 || nextBrace > -1 && nextBrace < nextSlash) {
                int nextClosingBrace = rawPath.indexOf(125, nextBrace);
                if (nextClosingBrace == -1) {
                    throw new ValueFormatException((Object)rawPath, this.getPropertyType(), GraphI18n.missingClosingBrace.text(new Object[]{rawPath}));
                }
                nextSlash = rawPath.indexOf(47, nextClosingBrace + 1);
                nextBrace = rawPath.indexOf(123, nextClosingBrace + 1);
                continue;
            }
            if ((nextBrace != -1 || nextSlash <= -1) && (nextSlash <= -1 || nextSlash >= nextBrace)) break;
            if (nextSlash > 0) {
                segments.add(rawPath.substring(curr, nextSlash));
            }
            curr = nextSlash + 1;
            nextSlash = rawPath.indexOf(47, curr);
        }
        segments.add(rawPath.substring(curr));
        return segments.toArray(new String[segments.size()]);
    }

    @Override
    public Path create(int value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public Path create(long value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public Path create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public Path create(float value) {
        throw new ValueFormatException((Object)Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public Path create(double value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public Path create(BigDecimal value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public Path create(Calendar value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public Path create(Date value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public Path create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public Path create(Name value) {
        if (value == null) {
            return null;
        }
        try {
            return new ChildPath(RootPath.INSTANCE, new BasicPathSegment(value));
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), e);
        }
    }

    @Override
    public Path create(Path value) {
        return value;
    }

    @Override
    public Path create(Path.Segment value) {
        return this.createAbsolutePath(value);
    }

    @Override
    public Path createAbsolutePath(Name ... segmentNames) {
        if (segmentNames == null || segmentNames.length == 0) {
            return RootPath.INSTANCE;
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(segmentNames.length);
        for (Name segmentName : segmentNames) {
            if (segmentName == null) {
                CheckArg.containsNoNulls((Object[])segmentNames, (String)"segment names");
            }
            segments.add(new BasicPathSegment(segmentName));
        }
        if (segments.size() == 1) {
            return new ChildPath(RootPath.INSTANCE, (Path.Segment)segments.get(0));
        }
        return new BasicPath(segments, true);
    }

    @Override
    public Path createAbsolutePath(Path.Segment ... segments) {
        if (segments == null || segments.length == 0) {
            return RootPath.INSTANCE;
        }
        ArrayList<Path.Segment> segmentsList = new ArrayList<Path.Segment>(segments.length);
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls((Object[])segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        if (segmentsList.size() == 1) {
            return new ChildPath(RootPath.INSTANCE, (Path.Segment)segmentsList.get(0));
        }
        return new BasicPath(segmentsList, true);
    }

    @Override
    public Path createAbsolutePath(Iterable<Path.Segment> segments) {
        LinkedList<Path.Segment> segmentsList = new LinkedList<Path.Segment>();
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls(segments, (String)"segments");
            }
            segmentsList.add(segment);
        }
        if (segmentsList.isEmpty()) {
            return RootPath.INSTANCE;
        }
        if (segmentsList.size() == 1) {
            return new ChildPath(RootPath.INSTANCE, (Path.Segment)segmentsList.get(0));
        }
        return new BasicPath(segmentsList, true);
    }

    @Override
    public Path createRelativePath() {
        return BasicPath.EMPTY_RELATIVE;
    }

    @Override
    public Path createRelativePath(Name ... segmentNames) {
        if (segmentNames == null || segmentNames.length == 0) {
            return BasicPath.EMPTY_RELATIVE;
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(segmentNames.length);
        for (Name segmentName : segmentNames) {
            if (segmentName == null) {
                CheckArg.containsNoNulls((Object[])segmentNames, (String)"segment names");
            }
            segments.add(new BasicPathSegment(segmentName));
        }
        return new BasicPath(segments, false);
    }

    @Override
    public Path createRelativePath(Path.Segment ... segments) {
        if (segments == null || segments.length == 0) {
            return BasicPath.EMPTY_RELATIVE;
        }
        ArrayList<Path.Segment> segmentsList = new ArrayList<Path.Segment>(segments.length);
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls((Object[])segments, (String)"segments");
            }
            assert (segment != null);
            if (segment.isIdentifier()) {
                throw new InvalidPathException(GraphI18n.unableToCreateRelativePathWithIdentifierSegment.text(new Object[]{segments.toString()}));
            }
            segmentsList.add(segment);
        }
        return new BasicPath(segmentsList, false);
    }

    @Override
    public Path createRelativePath(Iterable<Path.Segment> segments) {
        LinkedList<Path.Segment> segmentsList = new LinkedList<Path.Segment>();
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls(segments, (String)"segments");
            }
            assert (segment != null);
            if (segment.isIdentifier()) {
                throw new InvalidPathException(GraphI18n.unableToCreateRelativePathWithIdentifierSegment.text(new Object[]{segments.toString()}));
            }
            segmentsList.add(segment);
        }
        if (segmentsList.isEmpty()) {
            return BasicPath.EMPTY_RELATIVE;
        }
        return new BasicPath(segmentsList, false);
    }

    @Override
    public Path create(Path parentPath, Path childPath) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        CheckArg.isNotNull((Object)childPath, (String)"child path");
        if (childPath.size() == 0) {
            return parentPath;
        }
        if (parentPath.size() == 0) {
            if (childPath.isAbsolute() == parentPath.isAbsolute()) {
                return childPath;
            }
            return new BasicPath(childPath.getSegmentsList(), parentPath.isAbsolute());
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(parentPath.size() + childPath.size());
        for (Path.Segment seg : parentPath) {
            segments.add(seg);
        }
        for (Path.Segment seg : childPath) {
            segments.add(seg);
        }
        return new BasicPath(segments, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, Name segmentName, int index) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        return new ChildPath(parentPath, new BasicPathSegment(segmentName, index));
    }

    @Override
    public Path create(Path parentPath, String segmentName, int index) {
        return this.create(parentPath, this.nameValueFactory.create(segmentName), index);
    }

    @Override
    public Path create(Path parentPath, Name ... segmentNames) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        if (segmentNames == null || segmentNames.length == 0) {
            return parentPath;
        }
        if (segmentNames.length == 1 && segmentNames[0] != null) {
            return new ChildPath(parentPath, new BasicPathSegment(segmentNames[0]));
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(parentPath.size() + 1);
        segments.addAll(parentPath.getSegmentsList());
        for (Name segmentName : segmentNames) {
            if (segmentName == null) {
                CheckArg.containsNoNulls((Object[])segmentNames, (String)"segment names");
            }
            segments.add(new BasicPathSegment(segmentName));
        }
        return new BasicPath(segments, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, Path.Segment ... segments) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        if (segments == null || segments.length == 0) {
            return RootPath.INSTANCE;
        }
        if (segments.length == 1 && segments[0] != null) {
            if (parentPath.isIdentifier()) {
                throw new InvalidPathException(GraphI18n.unableToCreatePathBasedUponIdentifierPath.text(new Object[]{parentPath, segments.toString()}));
            }
            if (segments[0].isIdentifier()) {
                throw new InvalidPathException(GraphI18n.unableToCreatePathUsingIdentifierPathAndAnotherPath.text(new Object[]{parentPath, segments.toString()}));
            }
            return new ChildPath(parentPath, segments[0]);
        }
        ArrayList<Path.Segment> segmentsList = new ArrayList<Path.Segment>(parentPath.size() + 1);
        segmentsList.addAll(parentPath.getSegmentsList());
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls((Object[])segments, (String)"segments");
            }
            assert (segment != null);
            if (segment.isIdentifier()) {
                throw new InvalidPathException(GraphI18n.unableToCreatePathUsingIdentifierPathAndAnotherPath.text(new Object[]{parentPath, segments.toString()}));
            }
            segmentsList.add(segment);
        }
        return new BasicPath(segmentsList, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, Iterable<Path.Segment> segments) {
        CheckArg.isNotNull((Object)parentPath, (String)"parent path");
        if (parentPath.isIdentifier()) {
            throw new InvalidPathException(GraphI18n.unableToCreatePathBasedUponIdentifierPath.text(new Object[]{parentPath, segments.toString()}));
        }
        LinkedList<Path.Segment> segmentsList = new LinkedList<Path.Segment>();
        segmentsList.addAll(parentPath.getSegmentsList());
        for (Path.Segment segment : segments) {
            if (segment == null) {
                CheckArg.containsNoNulls(segments, (String)"segments");
            }
            assert (segment != null);
            if (segment.isIdentifier()) {
                throw new InvalidPathException(GraphI18n.unableToCreatePathUsingIdentifierPathAndAnotherPath.text(new Object[]{parentPath, segments.toString()}));
            }
            segmentsList.add(segment);
        }
        if (segmentsList.isEmpty()) {
            return RootPath.INSTANCE;
        }
        if (segmentsList.size() == 0) {
            return new ChildPath(parentPath, (Path.Segment)segmentsList.get(0));
        }
        return new BasicPath(segmentsList, parentPath.isAbsolute());
    }

    @Override
    public Path create(Path parentPath, String subpath) {
        boolean singleChild;
        CheckArg.isNotNull((Object)parentPath, (String)"parentPath");
        CheckArg.isNotNull((Object)subpath, (String)"subpath");
        if (parentPath.isIdentifier()) {
            throw new InvalidPathException(GraphI18n.unableToCreatePathBasedUponIdentifierPath.text(new Object[]{parentPath, subpath}));
        }
        boolean bl = singleChild = (subpath = subpath.trim()).indexOf(47) == -1;
        if (!singleChild && subpath.startsWith("./")) {
            if (subpath.length() == 2) {
                return parentPath;
            }
            boolean bl2 = singleChild = (subpath = subpath.substring(2)).indexOf(47) == -1;
        }
        if (singleChild) {
            try {
                Path.Segment childSegment = this.createSegment(subpath);
                if (childSegment.isIdentifier()) {
                    throw new InvalidPathException(GraphI18n.unableToCreatePathUsingIdentifierPathAndAnotherPath.text(new Object[]{parentPath, subpath}));
                }
                return new ChildPath(parentPath, childSegment);
            }
            catch (IllegalArgumentException t) {
                // empty catch block
            }
        }
        Path relativeSubpath = this.create(subpath);
        return this.create(parentPath, relativeSubpath);
    }

    @Override
    public Path.Segment createSegment(Name segmentName) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (Path.SELF_NAME.equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if (Path.PARENT_NAME.equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        return new BasicPathSegment(segmentName);
    }

    @Override
    public Path.Segment createSegment(Name segmentName, int index) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (Path.SELF_NAME.equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if (Path.PARENT_NAME.equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        return new BasicPathSegment(segmentName, index);
    }

    @Override
    public Path.Segment createSegment(String segmentName) {
        return this.createSegment(segmentName, this.getDecoder());
    }

    @Override
    public Path.Segment createSegment(String segmentName, TextDecoder decoder) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (".".equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if ("..".equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        int startBracketNdx = segmentName.indexOf(91);
        if (startBracketNdx < 0) {
            return new BasicPathSegment(this.nameValueFactory.create(segmentName, decoder));
        }
        int endBracketNdx = segmentName.indexOf(93, startBracketNdx);
        if (endBracketNdx < 0) {
            throw new IllegalArgumentException(GraphI18n.missingEndBracketInSegmentName.text(new Object[]{segmentName}));
        }
        if (startBracketNdx == 0 && endBracketNdx == segmentName.length() - 1) {
            Name id = this.nameValueFactory.create(segmentName.substring(1, endBracketNdx));
            return new IdentifierPathSegment(id);
        }
        String ndx = segmentName.substring(startBracketNdx + 1, endBracketNdx);
        try {
            return new BasicPathSegment(this.nameValueFactory.create(segmentName.substring(0, startBracketNdx), decoder), Integer.parseInt(ndx));
        }
        catch (NumberFormatException err) {
            throw new ValueFormatException((Object)segmentName, this.getPropertyType(), GraphI18n.invalidIndexInSegmentName.text(new Object[]{ndx, segmentName}));
        }
    }

    @Override
    public Path.Segment createSegment(String segmentName, int index) {
        CheckArg.isNotNull((Object)segmentName, (String)"segment name");
        if (".".equals(segmentName)) {
            return Path.SELF_SEGMENT;
        }
        if ("..".equals(segmentName)) {
            return Path.PARENT_SEGMENT;
        }
        return new BasicPathSegment(this.nameValueFactory.create(segmentName), index);
    }

    @Override
    public Path create(Reference value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public Path create(URI value) {
        if (value == null) {
            return null;
        }
        String asciiString = value.toASCIIString();
        if (asciiString.startsWith("./") && asciiString.length() > 2) {
            asciiString = asciiString.substring(2);
        }
        if (asciiString.indexOf(47) == -1) {
            return this.create(asciiString);
        }
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{URI.class.getSimpleName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Path create(UUID value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public Path create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Path create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Path create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public Path create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    protected Path[] createEmptyArray(int length) {
        return new Path[length];
    }
}

