/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.example.repository;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.modeshape.common.util.StringUtil;
import org.modeshape.example.repository.RepositoryClient;
import org.modeshape.example.repository.UserInterface;
import org.modeshape.graph.JaasSecurityContext;

public class ConsoleInput
implements UserInterface {
    protected static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    private final RepositoryClient repositoryClient;
    private final Map<Integer, String> selectionToSourceName = new HashMap<Integer, String>();

    public ConsoleInput(final RepositoryClient client, String[] args) {
        assert (client != null);
        this.repositoryClient = client;
        for (String arg : args) {
            if (!(arg = arg.trim().toLowerCase()).equals("--help")) continue;
            System.out.println();
            System.out.println("Usage:   run.sh [options]");
            System.out.println();
            System.out.println("Options:");
            System.out.println("  --api=value    Specify which API should be used to obtain the content.");
            System.out.println("                 The 'value' must be either 'jcr' or 'dna', and defaults");
            System.out.println("                 to 'jcr'.");
            System.out.println("  --jaas         Specify that JAAS should be used to authenticate the user.");
            System.out.println("  --jaas=name    With no 'name', use JAAS with an application context");
            System.out.println("                 named \"modeshape-jcr\".");
            System.out.println("                 If another application context is to be used, then specify");
            System.out.println("                 the name.");
            System.out.println("  --help         Print these instructions and exit.");
            System.out.println();
            return;
        }
        try {
            Thread eventThread = new Thread(new Runnable(){
                private boolean quit = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        System.out.println();
                        System.out.print("Starting repositories ... ");
                        client.startRepositories();
                        System.out.println("done.");
                        System.out.println();
                        ConsoleInput.this.displayMainMenu();
                        while (!this.quit) {
                            System.out.print(">");
                            try {
                                String input = in.readLine().trim();
                                if ("?".equals(input) || "h".equals(input)) {
                                    ConsoleInput.this.displayMainMenu();
                                    continue;
                                }
                                if ("q".equals(input)) {
                                    this.quit = true;
                                    continue;
                                }
                                try {
                                    int selection = Integer.parseInt(input);
                                    String sourceName = (String)ConsoleInput.this.selectionToSourceName.get(selection);
                                    ConsoleInput.this.displayNavigationMenu(sourceName);
                                    ConsoleInput.this.displayMainMenu();
                                }
                                catch (NumberFormatException e) {
                                    System.out.println("Invalid option.");
                                    ConsoleInput.this.displayMainMenu();
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid integer " + e.getMessage());
                            }
                            catch (IllegalArgumentException e) {
                                System.out.println(e.getMessage());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception err) {
                        System.out.println("Error: " + err.getLocalizedMessage());
                        err.printStackTrace(System.err);
                    }
                    finally {
                        try {
                            System.out.println();
                            System.out.print("done.\nShutting down repositories ... ");
                            client.shutdown();
                            System.out.print("done.");
                            System.out.println();
                            System.out.println();
                        }
                        catch (Exception err) {
                            System.out.println("Error shutting down repository: " + err.getLocalizedMessage());
                            err.printStackTrace(System.err);
                        }
                    }
                }
            });
            eventThread.start();
        }
        catch (Exception err) {
            System.out.println("Error: " + err.getLocalizedMessage());
            err.printStackTrace(System.err);
        }
    }

    protected void displayMainMenu() {
        this.selectionToSourceName.clear();
        System.out.println("-----------------------------------");
        System.out.println("Menu:");
        System.out.println();
        System.out.println("Select a repository to view:");
        int selection = 1;
        for (String sourceName : this.repositoryClient.getNamesOfRepositories()) {
            this.selectionToSourceName.put(selection, sourceName);
            System.out.println(StringUtil.justifyRight((String)("" + selection++), (int)3, (char)' ') + ") " + sourceName);
        }
        System.out.println("or");
        System.out.println("  ?) Show this menu");
        System.out.println("  q) Quit");
    }

    protected void displayNavigationMenu(String sourceName) {
        assert (sourceName != null);
        String currentPath = "/";
        System.out.println();
        System.out.println("Entering the \"" + sourceName + "\" repository.");
        this.displayNavigationHelp();
        while (true) {
            try {
                while (true) {
                    System.out.print(sourceName + "> ");
                    String input = in.readLine().trim();
                    if (input.length() == 0) continue;
                    if ("?".equals(input) || "help".equals(input) || "h".equals(input)) {
                        this.displayNavigationHelp();
                        continue;
                    }
                    if ("pwd".equals(input)) {
                        System.out.println(currentPath);
                        continue;
                    }
                    if ("exit".equals(input)) {
                        return;
                    }
                    if (input.startsWith("ls") || input.startsWith("ll")) {
                        input = input.substring(2).trim();
                        String path = this.repositoryClient.buildPath(currentPath, input);
                        this.displayNode(sourceName, path);
                        continue;
                    }
                    if (!input.startsWith("cd ") || (input = input.substring("cd ".length()).trim()).length() == 0) continue;
                    String oldPath = currentPath;
                    if (!this.repositoryClient.getNodeInfo(sourceName, currentPath = this.repositoryClient.buildPath(currentPath, input), null, null)) {
                        System.out.println("\"" + currentPath + "\" does not exist");
                        currentPath = oldPath;
                        continue;
                    }
                    System.out.println(currentPath);
                }
            }
            catch (Throwable e) {
                this.displayError(" processing your command", e);
                continue;
            }
            break;
        }
    }

    protected void displayNavigationHelp() {
        System.out.println();
        System.out.println("Enter one of the following commands followed by RETURN:");
        System.out.println("      pwd          print the current node's path");
        System.out.println("      ls [path]    to list the details of the node at the specified absolute or relative path");
        System.out.println("                   (or the current path if none is supplied)");
        System.out.println("      cd path      to change to the node at the specified absolute or relative path");
        System.out.println("      exit         to exit this repository and return to the main menu");
        System.out.println();
    }

    protected void displayNode(String sourceName, String path) {
        assert (sourceName != null);
        assert (path != null);
        HashMap<String, Object[]> properties = new HashMap<String, Object[]>();
        ArrayList<String> children = new ArrayList<String>();
        try {
            this.repositoryClient.getNodeInfo(sourceName, path, properties, children);
        }
        catch (Throwable t) {
            this.displayError(" displaying node \"" + path + "\"", t);
        }
        System.out.println(" ./");
        System.out.println(" ../");
        for (String childName : children) {
            System.out.println(" " + childName + "/");
        }
        int maxLength = 5;
        for (String string : properties.keySet()) {
            maxLength = Math.max(maxLength, string.length());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String name = StringUtil.justifyLeft((String)((String)entry.getKey()), (int)maxLength, (char)' ');
            Object[] values = (Object[])entry.getValue();
            String valueStr = values.length == 1 ? values[0].toString() : Arrays.asList(values).toString();
            System.out.println(" " + name + " = " + valueStr);
        }
    }

    @Override
    public void displayError(String activity, Throwable t) {
        assert (activity != null);
        assert (t != null);
        System.err.println();
        System.err.println("There has been an error" + activity);
        System.err.println("  " + t.getMessage());
        t.printStackTrace(System.err);
        System.err.println();
        System.err.println("Press any key to continue:");
        try {
            in.readLine();
        }
        catch (IOException err) {
            err.printStackTrace(System.err);
        }
    }

    @Override
    public String getLocationOfRepositoryFiles() {
        return new File("").getAbsolutePath();
    }

    @Override
    public File getRepositoryConfiguration() {
        return new File("configRepository.xml");
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return new JaasSecurityContext.UserPasswordCallbackHandler("jsmith", "secret".toCharArray());
    }
}

