/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jbosscache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.ConfigurationException;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.jbosscache.JBossCacheConnectorI18n;
import org.modeshape.connector.jbosscache.JBossCacheNode;
import org.modeshape.connector.jbosscache.JBossCacheRepository;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Connection;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.observe.Observer;

@ThreadSafe
public class JBossCacheSource
implements BaseRepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 2L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_UUID_PROPERTY_NAME = ModeShapeLexicon.UUID.getString();
    public static final String DEFAULT_NAME_OF_DEFAULT_WORKSPACE = "default";
    public static final boolean DEFAULT_UPDATES_ALLOWED = true;
    protected static final String ROOT_NODE_UUID = "rootNodeUuid";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String DEFAULT_CACHE_POLICY = "defaultCachePolicy";
    protected static final String CACHE_CONFIGURATION_NAME = "cacheConfigurationName";
    protected static final String CACHE_FACTORY_JNDI_NAME = "cacheFactoryJndiName";
    protected static final String CACHE_JNDI_NAME = "cacheJndiName";
    protected static final String RETRY_LIMIT = "retryLimit";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    protected static final String UPDATES_ALLOWED = "updatesAllowed";
    @Description(i18n=JBossCacheConnectorI18n.class, value="namePropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="namePropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="namePropertyCategory")
    private volatile String name;
    @Description(i18n=JBossCacheConnectorI18n.class, value="rootNodeUuidPropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="rootNodeUuidPropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="rootNodeUuidPropertyCategory")
    private volatile UUID rootNodeUuid = UUID.randomUUID();
    @Description(i18n=JBossCacheConnectorI18n.class, value="cacheConfigurationNamePropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="cacheConfigurationNamePropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="cacheConfigurationNamePropertyCategory")
    private volatile String cacheConfigurationName;
    @Description(i18n=JBossCacheConnectorI18n.class, value="cacheFactoryJndiNamePropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="cacheFactoryJndiNamePropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="cacheFactoryJndiNamePropertyCategory")
    private volatile String cacheFactoryJndiName;
    @Description(i18n=JBossCacheConnectorI18n.class, value="cacheJndiNamePropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="cacheJndiNamePropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="cacheJndiNamePropertyCategory")
    private volatile String cacheJndiName;
    @Description(i18n=JBossCacheConnectorI18n.class, value="retryLimitPropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="retryLimitPropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="retryLimitPropertyCategory")
    private volatile int retryLimit = 0;
    @Description(i18n=JBossCacheConnectorI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private volatile String defaultWorkspace;
    @Description(i18n=JBossCacheConnectorI18n.class, value="predefinedWorkspaceNamesPropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="predefinedWorkspaceNamesPropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="predefinedWorkspaceNamesPropertyCategory")
    private volatile String[] predefinedWorkspaces = new String[0];
    @Description(i18n=JBossCacheConnectorI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="updatesAllowedPropertyCategory")
    private volatile boolean updatesAllowed = true;
    private volatile CachePolicy defaultCachePolicy;
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, true, false, true, false);
    private transient JBossCacheRepository repository;
    private transient Context jndiContext;
    private transient RepositoryContext repositoryContext;
    private final Set<String> repositoryNamesForConfigurationNameProblems = new HashSet<String>();

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public String getName() {
        return this.name;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public synchronized void setRetryLimit(int limit) {
        this.retryLimit = limit < 0 ? 0 : limit;
    }

    public synchronized void setName(String name) {
        if (this.name == name || this.name != null && this.name.equals(name)) {
            return;
        }
        this.name = name;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public synchronized void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        if (this.defaultCachePolicy == defaultCachePolicy || this.defaultCachePolicy != null && this.defaultCachePolicy.equals(defaultCachePolicy)) {
            return;
        }
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public String getCacheJndiName() {
        return this.cacheJndiName;
    }

    public synchronized void setCacheJndiName(String cacheJndiName) {
        if (this.cacheJndiName == cacheJndiName || this.cacheJndiName != null && this.cacheJndiName.equals(cacheJndiName)) {
            return;
        }
        this.cacheJndiName = cacheJndiName;
    }

    public String getCacheFactoryJndiName() {
        return this.cacheFactoryJndiName;
    }

    public synchronized void setCacheFactoryJndiName(String jndiName) {
        if (this.cacheFactoryJndiName == jndiName || this.cacheFactoryJndiName != null && this.cacheFactoryJndiName.equals(jndiName)) {
            return;
        }
        this.cacheFactoryJndiName = jndiName;
    }

    public String getCacheConfigurationName() {
        return this.cacheConfigurationName;
    }

    public synchronized void setCacheConfigurationName(String cacheConfigurationName) {
        if (this.cacheConfigurationName == cacheConfigurationName || this.cacheConfigurationName != null && this.cacheConfigurationName.equals(cacheConfigurationName)) {
            return;
        }
        this.cacheConfigurationName = cacheConfigurationName;
    }

    public String getRootNodeUuid() {
        return this.rootNodeUuid.toString();
    }

    public UUID getRootNodeUuidObject() {
        return this.rootNodeUuid;
    }

    public synchronized void setRootNodeUuid(String rootNodeUuid) {
        UUID uuid = null;
        uuid = rootNodeUuid == null ? UUID.randomUUID() : UUID.fromString(rootNodeUuid);
        if (this.rootNodeUuid.equals(uuid)) {
            return;
        }
        this.rootNodeUuid = uuid;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public synchronized void setDefaultWorkspaceName(String nameOfDefaultWorkspace) {
        this.defaultWorkspace = nameOfDefaultWorkspace != null ? nameOfDefaultWorkspace : DEFAULT_NAME_OF_DEFAULT_WORKSPACE;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    @Description(i18n=JBossCacheConnectorI18n.class, value="creatingWorkspacesAllowedPropertyDescription")
    @Label(i18n=JBossCacheConnectorI18n.class, value="creatingWorkspacesAllowedPropertyLabel")
    @Category(i18n=JBossCacheConnectorI18n.class, value="creatingWorkspacesAllowedPropertyCategory")
    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(true, this.capabilities.supportsUpdates(), false, allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.getName() == null) {
            I18n msg = JBossCacheConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.repository == null) {
            Context context = this.getContext();
            if (context == null) {
                try {
                    context = new InitialContext();
                }
                catch (NamingException err) {
                    throw new RepositorySourceException(this.name, (Throwable)err);
                }
            }
            DefaultCacheFactory cacheFactory = null;
            String jndiName = this.getCacheFactoryJndiName();
            if (jndiName != null && jndiName.trim().length() != 0) {
                Object object = null;
                try {
                    object = context.lookup(jndiName);
                    if (object != null) {
                        cacheFactory = (CacheFactory)object;
                    }
                }
                catch (ClassCastException err) {
                    I18n msg = JBossCacheConnectorI18n.objectFoundInJndiWasNotCacheFactory;
                    String className = object != null ? object.getClass().getName() : "null";
                    throw new RepositorySourceException(this.getName(), msg.text(new Object[]{jndiName, this.getName(), className}), (Throwable)err);
                }
                catch (Throwable err) {
                    if (err instanceof RuntimeException) {
                        throw (RuntimeException)err;
                    }
                    throw new RepositorySourceException(this.getName(), err);
                }
            }
            if (cacheFactory == null) {
                cacheFactory = new DefaultCacheFactory();
            }
            Cache<UUID, JBossCacheNode> cache = this.createNewCache((CacheFactory<UUID, JBossCacheNode>)cacheFactory, this.getName());
            this.repository = new JBossCacheRepository(this, cache);
        }
        return new Connection((BaseRepositorySource)this, (Repository)this.repository);
    }

    public synchronized void close() {
        this.repository = null;
    }

    protected Cache<UUID, JBossCacheNode> createNewCache(CacheFactory<UUID, JBossCacheNode> cacheFactory, String repositoryName) {
        assert (repositoryName != null);
        if (cacheFactory == null) {
            return null;
        }
        try {
            return cacheFactory.createCache(repositoryName);
        }
        catch (ConfigurationException error) {
            block7: {
                I18n msg = JBossCacheConnectorI18n.workspaceNameWasNotValidConfiguration;
                Logger.getLogger(this.getClass()).debug(msg.text(new Object[]{repositoryName, error.getMessage()}), new Object[0]);
                if (this.cacheConfigurationName != null) {
                    try {
                        return cacheFactory.createCache(this.getCacheConfigurationName());
                    }
                    catch (ConfigurationException error2) {
                        if (!this.repositoryNamesForConfigurationNameProblems.add(repositoryName)) break block7;
                        msg = JBossCacheConnectorI18n.defaultCacheFactoryConfigurationNameWasNotValidConfiguration;
                        Logger.getLogger(this.getClass()).debug(msg.text(new Object[]{repositoryName}), new Object[0]);
                    }
                }
            }
            return cacheFactory.createCache();
        }
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    protected Observer getObserver() {
        return this.repositoryContext != null ? this.repositoryContext.getObserver() : null;
    }

    protected Context getContext() {
        return this.jndiContext;
    }

    protected synchronized void setContext(Context context) {
        this.jndiContext = context;
    }

    public boolean areUpdatesAllowed() {
        return this.updatesAllowed;
    }

    public void setUpdatesAllowed(boolean updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JBossCacheSource) {
            JBossCacheSource that = (JBossCacheSource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.getName()});
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuid().toString()));
        ref.add(new StringRefAddr(CACHE_JNDI_NAME, this.getCacheJndiName()));
        ref.add(new StringRefAddr(CACHE_FACTORY_JNDI_NAME, this.getCacheFactoryJndiName()));
        ref.add(new StringRefAddr(CACHE_CONFIGURATION_NAME, this.getCacheConfigurationName()));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(UPDATES_ALLOWED, String.valueOf(this.areUpdatesAllowed())));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = JBossCacheConnectorI18n.errorSerializingCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String rootNodeUuidString = (String)values.get(ROOT_NODE_UUID);
            String cacheJndiName = (String)values.get(CACHE_JNDI_NAME);
            String cacheFactoryJndiName = (String)values.get(CACHE_FACTORY_JNDI_NAME);
            String cacheConfigurationName = (String)values.get(CACHE_CONFIGURATION_NAME);
            Object defaultCachePolicy = values.get(DEFAULT_CACHE_POLICY);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
            String createWorkspaces = (String)values.get(ALLOW_CREATING_WORKSPACES);
            String updatesAllowed = (String)values.get(UPDATES_ALLOWED);
            String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            JBossCacheSource source = new JBossCacheSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuidString != null) {
                source.setRootNodeUuid(rootNodeUuidString);
            }
            if (cacheJndiName != null) {
                source.setCacheJndiName(cacheJndiName);
            }
            if (cacheFactoryJndiName != null) {
                source.setCacheFactoryJndiName(cacheFactoryJndiName);
            }
            if (cacheConfigurationName != null) {
                source.setCacheConfigurationName(cacheConfigurationName);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            if (defaultWorkspace != null) {
                source.setDefaultWorkspaceName(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (updatesAllowed != null) {
                source.setUpdatesAllowed(Boolean.valueOf(updatesAllowed));
            }
            return source;
        }
        return null;
    }
}

