/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.AbstractI18nTest;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.federation.FederatedRepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.connector.xmlfile.XmlFileRepositorySource;

public class GraphI18nTest
extends AbstractI18nTest {
    public GraphI18nTest() {
        super(GraphI18n.class);
    }

    @Test
    public void shouldHaveI18nConstantsAndPropertiesForInMemoryRepositorySource() throws Exception {
        this.verifyI18nForAnnotationsOnObject(new InMemoryRepositorySource());
    }

    @Test
    public void shouldHaveI18nConstantsAndPropertiesForFederatedRepositorySource() throws Exception {
        this.verifyI18nForAnnotationsOnObject(new FederatedRepositorySource());
    }

    @Test
    public void shouldHaveI18nConstantsAndPropertiesForXmlFileRepositorySource() throws Exception {
        this.verifyI18nForAnnotationsOnObject(new XmlFileRepositorySource());
    }

    @Test
    public void shouldHaveI18nConstantsAndPropertiesForRepositoryConnectionPool() throws Exception {
        RepositorySource source = (RepositorySource)Mockito.mock(RepositorySource.class);
        this.verifyI18nForAnnotationsOnObject(new RepositoryConnectionPool(source));
    }
}

