/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Results;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.request.FunctionRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.function.Function;
import org.modeshape.graph.request.function.FunctionContext;
import org.xml.sax.SAXException;

public class GraphIntegrationTest {
    private ExecutionContext context;
    private InMemoryRepositorySource graphSource;
    private Graph graph;
    private boolean print = false;

    @Before
    public void beforeEaach() throws SAXException, IOException {
        this.context = new ExecutionContext();
        this.graphSource = new InMemoryRepositorySource();
        this.graphSource.setName("Graph source");
        this.graph = Graph.create((RepositorySource)this.graphSource, (ExecutionContext)this.context);
        this.graph.importXmlFrom(this.resourceUrl("aircraft.xml")).into("/");
    }

    @Test
    public void shouldHaveNonEmptyInitialContent() {
        this.assertNodeExists(this.graph, "Aircraft");
    }

    @Test
    public void shouldSuccessfullyApplyFunction() {
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(100).at("/");
        int count = this.countNodes(subgraph);
        Map output = (Map)this.graph.applyFunction((Function)new CountNodesFunction()).to("/");
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat(output.get("nodeCount"), (Matcher)Is.is((Object)new Integer(count)));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldResultInExceptionIfFunctionResultsInError() {
        this.graph.applyFunction((Function)new SetErrorFunction()).to("/");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldResultInExceptionIfFunctionThrowsException() {
        this.graph.applyFunction((Function)new ThrowErrorFunction()).to("/");
    }

    @Test
    public void shouldAllowSpecifyingOneInputParametersWhenApplyingFunction() {
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(100).at("/");
        int count = this.countNodes(subgraph);
        CountNodesFunction function = new CountNodesFunction();
        Map output = (Map)this.graph.applyFunction((Function)function).withInput("a", (Object)"value").to("/");
        Assert.assertThat(output.get("nodeCount"), (Matcher)Is.is((Object)new Integer(count)));
    }

    @Test
    public void shouldAllowSpecifyingMultipleInputParametersWhenApplyingFunction() {
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(100).at("/");
        int count = this.countNodes(subgraph);
        CountNodesFunction function = new CountNodesFunction();
        Map output = (Map)this.graph.applyFunction((Function)function).withInput("a", (Object)"value").and("b", (Object)"foo").to("/");
        Assert.assertThat(output.get("nodeCount"), (Matcher)Is.is((Object)new Integer(count)));
    }

    @Test
    public void shouldSuccessfullyApplyFunctionUsingBatch() {
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(100).at("/");
        int count = this.countNodes(subgraph);
        Results results = ((Graph.Batch)this.graph.batch().applyFunction((Function)new CountNodesFunction()).to("/")).execute();
        Assert.assertThat((Object)results, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)results.getRequests().size(), (Matcher)Is.is((Object)1));
        FunctionRequest request = (FunctionRequest)results.getRequests().get(0);
        Assert.assertThat((Object)request.output("nodeCount", PropertyType.LONG, (Object)null, this.context), (Matcher)Is.is((Object)new Long(count)));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldResultInExceptionIfFunctionResultsInErrorUsingBatch() {
        ((Graph.Batch)this.graph.batch().applyFunction((Function)new SetErrorFunction()).to("/")).execute();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldResultInExceptionIfFunctionThrowsExceptionUsingBatch() {
        ((Graph.Batch)this.graph.batch().applyFunction((Function)new ThrowErrorFunction()).to("/")).execute();
    }

    @Test
    public void shouldAllowSpecifyingOneInputParametersWhenApplyingFunctionUsingBatch() {
        ThrowErrorFunction function = new ThrowErrorFunction();
        Graph.Batch batch = (Graph.Batch)this.graph.batch().applyFunction((Function)function).withInput("a", (Object)"value").to("/");
        Assert.assertThat((Object)batch.isExecuteRequired(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSpecifyingMultipleInputParametersWhenApplyingFunctionUsingBatch() {
        ThrowErrorFunction function = new ThrowErrorFunction();
        Graph.Batch batch = (Graph.Batch)this.graph.batch().applyFunction((Function)function).withInput("a", (Object)"value").and("b", (Object)"foo").to("/");
        Assert.assertThat((Object)batch.isExecuteRequired(), (Matcher)Is.is((Object)true));
    }

    protected int countNodes(Subgraph subgraph) {
        return this.countNodes(subgraph.getRoot(), subgraph);
    }

    protected int countNodes(SubgraphNode node, Subgraph subgraph) {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        int count = 1;
        for (Location child : node.getChildren()) {
            count += this.countNodes((SubgraphNode)subgraph.getNode(child), subgraph);
        }
        return count;
    }

    protected void assertNoChildren(Graph graph, String path) {
        this.assertNodeExists(graph, path);
        List children = (List)graph.getChildren().of(path);
        Assert.assertThat((Object)children.isEmpty(), (Matcher)Is.is((Object)true));
    }

    protected Node assertNodeExists(Graph graph, String path) {
        Node node = graph.getNodeAt(path);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return node;
    }

    protected void assertNodeDoesNotExist(Graph graph, String path) {
        try {
            graph.getNodeAt(path);
            Assert.fail((String)("Node does exist at \"" + path + "\""));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    protected void printSubgraph(Graph graph, String path) {
        if (this.print) {
            Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(Integer.MAX_VALUE).at(path);
            System.out.println(subgraph);
        }
    }

    protected String resourceUrl(String path) {
        URL url = this.getClass().getClassLoader().getResource(path);
        return url != null ? url.toExternalForm() : path;
    }

    protected static class ThrowErrorFunction
    extends Function {
        private static final long serialVersionUID = 1L;

        protected ThrowErrorFunction() {
        }

        public void run(FunctionContext context) {
            throw new IllegalStateException("Bogus exceptions");
        }
    }

    protected static class SetErrorFunction
    extends Function {
        private static final long serialVersionUID = 1L;

        protected SetErrorFunction() {
        }

        public void run(FunctionContext context) {
            context.setError((Throwable)new IllegalStateException("Bogus exceptions"));
        }
    }

    protected static class CountNodesFunction
    extends Function {
        private static final long serialVersionUID = 1L;

        protected CountNodesFunction() {
        }

        public void run(FunctionContext context) {
            int maxDepth = ((Long)context.input("maxDepth", PropertyType.LONG, (Object)new Long(Integer.MAX_VALUE))).intValue();
            ReadBranchRequest readSubgraph = context.builder().readBranch(context.appliedAt(), context.workspace(), maxDepth);
            if (readSubgraph.hasError()) {
                readSubgraph.getError().printStackTrace();
                context.setError(readSubgraph.getError());
            } else {
                int counter = 0;
                for (Location location : readSubgraph) {
                    if (location == null) continue;
                    ++counter;
                }
                context.setOutput("nodeCount", (Serializable)Integer.valueOf(counter));
            }
        }
    }
}

