/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.federation.AbstractFederatedRepositorySourceIntegrationTest;

public class FederatedRepositorySourceUsingMirrorProjectionTest
extends AbstractFederatedRepositorySourceIntegrationTest {
    private String mirrorSourceName;
    private String mirrorWorkspaceName;

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.mirrorSourceName = "Mirror Source";
        this.mirrorWorkspaceName = "Mirror Workspace";
        this.addProjection("fedSpace", "Mirror Projection", this.mirrorSourceName, this.mirrorWorkspaceName, "/ => /");
        Graph source = this.graphFor(this.mirrorSourceName, this.mirrorWorkspaceName);
        source.importXmlFrom(this.getClass().getClassLoader().getResource("cars.xml").toURI()).into("/");
    }

    protected void assertSameNode(String pathToNode) {
        this.assertSameNode(pathToNode, pathToNode, this.mirrorSourceName, this.mirrorWorkspaceName, new String[0]);
    }

    protected void assertNoNode(String pathToNode) {
        this.assertNoNode(pathToNode, pathToNode, this.mirrorSourceName, this.mirrorWorkspaceName);
    }

    @Test
    public void shouldListAllFederatedWorkspaces() {
        Set workspaces = this.federated.getWorkspaces();
        Assert.assertThat((Object)workspaces.contains("fedSpace"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaces.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldFederateNodesInMirrorSource() {
        this.assertSameNode("/");
        this.assertSameNode("/Cars");
        this.assertSameNode("/Cars/Hybrid");
        this.assertSameNode("/Cars/Hybrid/Toyota Prius");
        this.assertSameNode("/Cars/Hybrid/Toyota Highlander");
        this.assertSameNode("/Cars/Hybrid/Nissan Altima");
        this.assertSameNode("/Cars/Sports/Aston Martin DB9");
        this.assertSameNode("/Cars/Sports/Infiniti G37");
        this.assertSameNode("/Cars/Luxury/Cadillac DTS");
        this.assertSameNode("/Cars/Luxury/Bentley Continental");
        this.assertSameNode("/Cars/Luxury/Lexus IS350");
        this.assertSameNode("/Cars/Utility/Land Rover LR2");
        this.assertSameNode("/Cars/Utility/Land Rover LR3");
        this.assertSameNode("/Cars/Utility/Hummer H3");
        this.assertSameNode("/Cars/Utility/Ford F-150");
    }

    @Test
    public void shouldCreateNodeUnderRootInMirrorSource() {
        this.federated.createAt("/Hovercraft").with("prop1", new Object[]{"value1"}).and();
        this.assertSameNode("/Hovercraft");
        this.assertSameNode("/");
    }

    @Test
    public void shouldCreateNodeWellBelowRootInMirrorSource() {
        this.federated.createAt("/Cars/Hybrid/MyNewHybrid").with("prop1", new Object[]{"value1"}).and();
        this.assertSameNode("/Cars/Hybrid/MyNewHybrid");
        this.assertSameNode("/Cars/Hybrid");
    }

    @Test
    public void shouldDeleteNodeUnderRootFromMirrorSource() {
        this.federated.createAt("/Hovercraft").with("prop1", new Object[]{"value1"}).and();
        this.assertSameNode("/Hovercraft");
        this.federated.delete("/Hovercraft");
        this.assertNoNode("/Hovercraft");
        this.assertSameNode("/");
        this.federated.delete("/Cars");
        this.assertSameNode("/");
    }

    @Test
    public void shouldDeleteNodeWellBelowRootFromMirrorSource() {
        this.federated.delete("/Cars/Luxury/Cadillac DTS");
        this.assertNoNode("/Cars/Luxury/Cadillac DTS");
        this.assertSameNode("/Cars/Luxury");
    }
}

