/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.federation.PlaceholderNode;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProjectorWithPlaceholders;
import org.modeshape.graph.property.Path;

public class ProjectorWithPlaceholdersTest {
    protected ExecutionContext context;
    protected List<Projection> projections;
    protected Collection<PlaceholderNode> placeholders;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.projections = new ArrayList<Projection>();
        this.placeholders = new ArrayList<PlaceholderNode>();
    }

    protected Projection.Rule[] rule(String ... rule) {
        Projection.Rule[] rules = new Projection.Rule[rule.length];
        for (int i = 0; i != rule.length; ++i) {
            rules[i] = Projection.fromString((String)rule[i], (ExecutionContext)this.context);
        }
        return rules;
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Path path(Path parent, String relativePath) {
        return this.context.getValueFactories().getPathFactory().create(parent, relativePath);
    }

    protected void addProjection(String sourceName, String workspaceName, String ... rules) {
        this.projections.add(new Projection(sourceName, workspaceName, false, this.rule(rules)));
    }

    protected PlaceholderNode getPlaceholder(Path path) {
        for (PlaceholderNode placeholder : this.placeholders) {
            if (!placeholder.location().getPath().equals(path)) continue;
            return placeholder;
        }
        return null;
    }

    protected void assertPlacholderHasChildren(String parent, String ... childSegments) {
        Path parentPath = this.path(parent);
        PlaceholderNode node = this.getPlaceholder(parentPath);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.isPlaceholder(), (Matcher)Is.is((Object)true));
        PlaceholderNode placeholder = node.asPlaceholder();
        ArrayList<Path> locations = new ArrayList<Path>();
        for (String childSegment : childSegments) {
            Path childPath = this.path(parentPath, childSegment);
            locations.add(childPath);
        }
        ArrayList<Path> actual = new ArrayList<Path>();
        for (ProjectedNode child : placeholder.children()) {
            if (child.isPlaceholder()) {
                actual.add(child.location().getPath());
                continue;
            }
            actual.add(child.asProxy().federatedLocation().getPath());
        }
        Assert.assertThat(actual, (Matcher)Is.is(locations));
    }

    protected void assertNoPlacholder(String parent) {
        Assert.assertThat((Object)this.getPlaceholder(this.path(parent)), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldLoadPlaceholderNodesForWorkspaceWithOneProjectionNotAtRoot() {
        this.addProjection("source1", "workspace1", "/a/b => /c/d");
        ProjectorWithPlaceholders.loadPlaceholderNodes((ExecutionContext)this.context, this.projections, this.placeholders);
        this.assertPlacholderHasChildren("/", "a");
        this.assertPlacholderHasChildren("/a", "b");
        Assert.assertThat((Object)this.placeholders.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldLoadPlaceholderNodesForWorkspaceWithOneProjectionAtRoot() {
        this.addProjection("source1", "workspace1", "/ => /");
        ProjectorWithPlaceholders.loadPlaceholderNodes((ExecutionContext)this.context, this.projections, this.placeholders);
        this.assertNoPlacholder("/");
        Assert.assertThat((Object)this.placeholders.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldLoadPlaceholderNodesForWorkspaceWithMultipleProjectionsNotAtRoot() {
        this.addProjection("source1", "workspace1", "/a/b => /a1/b1");
        this.addProjection("source2", "workspace2", "/c/d => /c1/d1");
        ProjectorWithPlaceholders.loadPlaceholderNodes((ExecutionContext)this.context, this.projections, this.placeholders);
        this.assertPlacholderHasChildren("/", "a", "c");
        this.assertPlacholderHasChildren("/a", "b");
        this.assertPlacholderHasChildren("/c", "d");
        Assert.assertThat((Object)this.placeholders.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldLoadPlaceholderNodesForWorkspaceWithMultipleProjectionsAtRoot() {
        this.addProjection("source1", "workspace1", "/ => /");
        this.addProjection("source2", "workspace2", "/ => /");
        ProjectorWithPlaceholders.loadPlaceholderNodes((ExecutionContext)this.context, this.projections, this.placeholders);
        this.assertNoPlacholder("/");
        Assert.assertThat((Object)this.placeholders.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldLoadPlaceholderNodesForWorkspaceWithMirrorAndBranchProjections() {
        this.addProjection("source1", "workspace1", "/ => /");
        this.addProjection("source2", "workspace2", "/a => /a");
        ProjectorWithPlaceholders.loadPlaceholderNodes((ExecutionContext)this.context, this.projections, this.placeholders);
        this.assertPlacholderHasChildren("/", "a");
        Assert.assertThat((Object)this.placeholders.size(), (Matcher)Is.is((Object)1));
        this.assertNoPlacholder("/a");
        this.assertNoPlacholder("/b");
        this.assertNoPlacholder("/c/d");
        this.assertNoPlacholder("/a/e");
    }

    @Test
    public void shouldLoadPlaceholderNodesForWorkspaceWithMirrorAndOffsetBranchProjections() {
        this.addProjection("source1", "workspace1", "/ => /");
        this.addProjection("source2", "workspace2", "/a/b/c => /a/b");
        ProjectorWithPlaceholders.loadPlaceholderNodes((ExecutionContext)this.context, this.projections, this.placeholders);
        this.assertPlacholderHasChildren("/", "a");
        this.assertPlacholderHasChildren("/a", "b");
        this.assertPlacholderHasChildren("/a/b", "c");
        Assert.assertThat((Object)this.placeholders.size(), (Matcher)Is.is((Object)3));
        this.assertNoPlacholder("/x");
        this.assertNoPlacholder("/y/z");
        this.assertNoPlacholder("/a/b/c");
    }

    @Test
    public void shouldLoadPlaceholderNodesForWorkspaceWithOffsetMirrorProjection() {
        this.addProjection("source1", "workspace1", "/a/b/c => /");
        ProjectorWithPlaceholders.loadPlaceholderNodes((ExecutionContext)this.context, this.projections, this.placeholders);
        this.assertPlacholderHasChildren("/", "a");
        this.assertPlacholderHasChildren("/a", "b");
        this.assertPlacholderHasChildren("/a/b", "c");
        Assert.assertThat((Object)this.placeholders.size(), (Matcher)Is.is((Object)3));
        this.assertNoPlacholder("/a[2]");
        this.assertNoPlacholder("/a/b[2]");
        this.assertNoPlacholder("/a/b/c[2]");
    }
}

