/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.util.Reflection;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;

public class InMemoryRepositorySourceTest {
    private ExecutionContext context;
    private RepositoryContext repositoryContext;
    private InMemoryRepositorySource source;
    private String[] predefinedWorkspaces = new String[]{"foo", "bar", "baz"};

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.repositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.source = new InMemoryRepositorySource();
        this.source.setName("In-Memory Repository Source");
        this.source.setPredefinedWorkspaceNames(this.predefinedWorkspaces);
        this.source.setDefaultWorkspaceName(this.predefinedWorkspaces[0]);
        this.source.initialize(this.repositoryContext);
    }

    public Location locationFor(String path) {
        return Location.create((Path)this.pathFor(path));
    }

    public Path pathFor(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    @Test
    public void shouldMakeAvailablePredefinedWorkspaces() {
        RepositoryConnection connection = this.source.getConnection();
        GetWorkspacesRequest request = new GetWorkspacesRequest();
        connection.execute(this.context, (Request)request);
        Set workspaces = request.getAvailableWorkspaceNames();
        HashSet<String> graphWorkspaces = new HashSet<String>(Arrays.asList(this.predefinedWorkspaces));
        Assert.assertThat((Object)workspaces, (Matcher)CoreMatchers.is(graphWorkspaces));
        for (String workspaceName : this.predefinedWorkspaces) {
            ReadNodeRequest readRoot = new ReadNodeRequest(this.locationFor("/"), workspaceName);
            connection.execute(this.context, (Request)readRoot);
            Assert.assertThat((Object)readRoot.getActualLocationOfNode().getPath(), (Matcher)CoreMatchers.is((Object)this.pathFor("/")));
        }
    }

    @Test
    public void shouldHaveProperties() throws Exception {
        Reflection reflection = new Reflection(this.source.getClass());
        Reflection.Property property = reflection.getProperty((Object)this.source, "updatesAllowed");
        Assert.assertThat((Object)property.getDescription(), (Matcher)CoreMatchers.is((Object)GraphI18n.updatesAllowedPropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)property.getLabel(), (Matcher)CoreMatchers.is((Object)GraphI18n.updatesAllowedPropertyLabel.text(new Object[0])));
        Assert.assertThat((Object)property.getCategory(), (Matcher)CoreMatchers.is((Object)GraphI18n.updatesAllowedPropertyCategory.text(new Object[0])));
        Assert.assertThat((Object)property.getCategory(), (Matcher)CoreMatchers.is((Object)"Advanced"));
        Assert.assertThat((Object)property.isInferred(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)property.isBooleanType(), (Matcher)CoreMatchers.is((Object)true));
        property = reflection.getProperty((Object)this.source, "defaultCachePolicy");
        Assert.assertThat((Object)property.getDescription(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)property.getLabel(), (Matcher)CoreMatchers.is((Object)"Default Cache Policy"));
        Assert.assertThat((Object)property.getCategory(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)property.isInferred(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)property.isBooleanType(), (Matcher)CoreMatchers.is((Object)false));
        Map properties = reflection.getAllPropertiesByNameOn((Object)this.source);
        Assert.assertThat((Object)properties.containsKey("name"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)properties.containsKey("jndiName"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)properties.containsKey("defaultWorkspaceName"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)properties.containsKey("predefinedWorkspaceNames"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)properties.containsKey("updatesAllowed"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)properties.containsKey("defaultCachePolicy"), (Matcher)CoreMatchers.is((Object)true));
    }
}

