/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.io;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;

public class GraphSequencerOutput
implements SequencerOutput {
    private final Graph.Batch batch;
    private final PathFactory pathFactory;
    private final Set<Path> paths = new HashSet<Path>();
    private final Path startingPath;

    public GraphSequencerOutput(Graph.Batch batch) {
        this.batch = batch;
        ExecutionContext context = batch.getGraph().getContext();
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.startingPath = this.pathFactory.createRootPath();
    }

    public GraphSequencerOutput(Graph graph) {
        this(graph.batch());
    }

    public void setProperty(String nodePath, String propertyName, Object ... values) {
        assert (this.valuesAreNotIterators(values));
        Path path = (Path)this.pathFactory.create(nodePath);
        if (this.paths.add(path = this.absolute(path))) {
            this.batch.create(path).and();
        }
        ((Graph.SetValuesTo)this.batch.set(propertyName).on(path)).to(values);
    }

    public void setProperty(Path nodePath, Name propertyName, Object ... values) {
        assert (this.valuesAreNotIterators(values));
        if (this.paths.add(nodePath = this.absolute(nodePath))) {
            this.batch.create(nodePath).and();
        }
        ((Graph.SetValuesTo)this.batch.set(propertyName).on(nodePath)).to(values);
    }

    private final Path absolute(Path path) {
        return path.isAbsolute() ? path : path.resolveAgainst(this.startingPath);
    }

    public void setReference(String nodePath, String propertyName, String ... paths) {
        Path path = (Path)this.pathFactory.create(nodePath);
        if (this.paths.add(path = this.absolute(path))) {
            this.batch.create(path).and();
        }
        ((Graph.SetValuesTo)this.batch.set(propertyName).on(nodePath)).to((Object[])paths);
    }

    public void close() {
        this.batch.execute();
    }

    private final boolean valuesAreNotIterators(Object ... values) {
        for (Object value : values) {
            if (!(value instanceof Iterator)) continue;
            return false;
        }
        return true;
    }
}

