/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.InvalidPathExpressionException;
import org.modeshape.graph.property.PathExpression;

public class PathExpressionTest {
    private PathExpression expr;

    @Before
    public void beforeEach() throws Exception {
        this.expr = new PathExpression(".*");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCompileNullExpression() {
        PathExpression.compile(null);
    }

    @Test(expected=InvalidPathExpressionException.class)
    public void shouldNotCompileZeroLengthExpression() {
        PathExpression.compile((String)"");
    }

    @Test(expected=InvalidPathExpressionException.class)
    public void shouldNotCompileBlankExpression() {
        PathExpression.compile((String)"    ");
    }

    @Test
    public void shouldCompileExpressionWithAnyNode() {
        this.expr = PathExpression.compile((String)"/*");
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/*"));
        Assert.assertThat((Object)this.expr.matcher("/a").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a").getInputPath(), (Matcher)Is.is((Object)"/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").getSelectedNodePath(), (Matcher)Is.is((Object)"/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").groupCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCompileExpressionWithAnySequenceOfNodes() {
        this.expr = PathExpression.compile((String)"//");
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"//"));
        Assert.assertThat((Object)this.expr.matcher("/a").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a").getInputPath(), (Matcher)Is.is((Object)"/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").getSelectedNodePath(), (Matcher)Is.is((Object)"/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b").getInputPath(), (Matcher)Is.is((Object)"/a/b"));
        Assert.assertThat((Object)this.expr.matcher("/a/b").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b"));
        Assert.assertThat((Object)this.expr.matcher("/a/b").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getInputPath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").groupCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCompileExpressionWithExtraWhitespace() {
        this.expr = PathExpression.compile((String)" /a/b/c ");
        Assert.assertThat((Object)this.expr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/a/b/c"));
        this.expr = PathExpression.compile((String)"  /a/b/c ");
        Assert.assertThat((Object)this.expr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/a/b/c"));
    }

    @Test
    public void shouldCompileExpressionWithIndexes() {
        Assert.assertThat((Object)PathExpression.compile((String)"/a/b[0]/c[1]/d/e"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)PathExpression.compile((String)"/a/b[0]/c[1]/d/e[2]"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCompileExpressionWithRepositoryAndWorkspaceNames() {
        Assert.assertThat((Object)PathExpression.compile((String)"repo:ws:/a/b/c"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCompileExpressionWithRepositoryAndNoWorkspaceNames() {
        Assert.assertThat((Object)PathExpression.compile((String)"repo::/a/b/c"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCompileExpressionWithNoRepositoryAndNoWorkspaceNames() {
        Assert.assertThat((Object)PathExpression.compile((String)"::/a/b/c"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldNotRemoveUsedPredicates() {
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b/c"), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[0]/c"), (Matcher)Is.is((Object)"/a/b[0]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1]/c"), (Matcher)Is.is((Object)"/a/b[1]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[10]/c"), (Matcher)Is.is((Object)"/a/b[10]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[100]/c"), (Matcher)Is.is((Object)"/a/b[100]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1000]/c"), (Matcher)Is.is((Object)"/a/b[1000]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[]/c"), (Matcher)Is.is((Object)"/a/b[]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[*]/c"), (Matcher)Is.is((Object)"/a/b[*]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1,2]/c"), (Matcher)Is.is((Object)"/a/b[1,2]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1,2,3,4,5]/c"), (Matcher)Is.is((Object)"/a/b[1,2,3,4,5]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b/c[@title]"), (Matcher)Is.is((Object)"/a/b/c[@title]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b/c[d/e/@title]"), (Matcher)Is.is((Object)"/a/b/c[d/e/@title]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/(b/c)[(d|e)/(f|g)/@something]"), (Matcher)Is.is((Object)"/a/(b/c)[(d|e)/(f|g)/@something]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/*"), (Matcher)Is.is((Object)"/*"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/*[]"), (Matcher)Is.is((Object)"/*[]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/*[3]"), (Matcher)Is.is((Object)"/*[3]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1][2][3]/c"), (Matcher)Is.is((Object)"/a/b[1][2][3]/c"));
    }

    @Test
    public void shouldRemoveUnusedPredicates() {
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[-1]/c"), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[@name='wacky']/c"), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[3][@name='wacky']/c"), (Matcher)Is.is((Object)"/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[3][@name]/c"), (Matcher)Is.is((Object)"/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[length(@name)=3]/c"), (Matcher)Is.is((Object)"/a/b/c"));
    }

    @Test
    public void shouldRemoveAllPredicates() {
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b/c"), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[0]/c"), (Matcher)Is.is((Object)"/a/b[0]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[1]/c"), (Matcher)Is.is((Object)"/a/b[1]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[10]/c"), (Matcher)Is.is((Object)"/a/b[10]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[100]/c"), (Matcher)Is.is((Object)"/a/b[100]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[1000]/c"), (Matcher)Is.is((Object)"/a/b[1000]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[]/c"), (Matcher)Is.is((Object)"/a/b[]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[*]/c"), (Matcher)Is.is((Object)"/a/b[*]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b/c[@title]"), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[1][2][3]/c"), (Matcher)Is.is((Object)"/a/b[1][2][3]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[-1]/c"), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[@name='wacky']/c"), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[3][@name='wacky']/c"), (Matcher)Is.is((Object)"/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[3][@name]/c"), (Matcher)Is.is((Object)"/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[length(@name)=3]/c"), (Matcher)Is.is((Object)"/a/b/c"));
    }

    @Test
    public void shouldReplaceAllXPathPatterns() {
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[3]/c"), (Matcher)Is.is((Object)"/a/b\\[3\\]/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[*]/c"), (Matcher)Is.is((Object)"/a/b(?:\\[\\d+\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[]/c"), (Matcher)Is.is((Object)"/a/b(?:\\[\\d+\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[0]/c"), (Matcher)Is.is((Object)"/a/b(?:\\[0\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[0,1,2,4]/c"), (Matcher)Is.is((Object)"/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[1,2,4,0]/c"), (Matcher)Is.is((Object)"/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[1,2,0,4]/c"), (Matcher)Is.is((Object)"/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[0,1,2,0,4,0]/c"), (Matcher)Is.is((Object)"/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[1,2,4]/c"), (Matcher)Is.is((Object)"/a/b\\[(?:1|2|4)\\]/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[@param]"), (Matcher)Is.is((Object)"/a/b/@param"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[3][@param]"), (Matcher)Is.is((Object)"/a/b\\[3\\]/@param"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[c/d/@param]"), (Matcher)Is.is((Object)"/a/b/c/d/@param"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c|d)/e"), (Matcher)Is.is((Object)"/a/(b|c|d)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b||c|d)/e"), (Matcher)Is.is((Object)"/a/(b|c|d)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|||c|d)/e"), (Matcher)Is.is((Object)"/a/(b|c|d)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(|b|c|d)/e"), (Matcher)Is.is((Object)"/a(?:/(b|c|d))?/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c|d|)/e"), (Matcher)Is.is((Object)"/a(?:/(b|c|d))?/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c|d)[]/e"), (Matcher)Is.is((Object)"/a/(b|c|d)(?:\\[\\d+\\])?/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c[2]|d[])/e"), (Matcher)Is.is((Object)"/a/(b|c\\[2\\]|d(?:\\[\\d+\\])?)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c/d|e)/f"), (Matcher)Is.is((Object)"/a/(b|c/d|e)/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b/c)[(d|e)/(f|g)/@something]"), (Matcher)Is.is((Object)"/a/(b/c)/(d|e)/(f|g)/@something"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/*/f"), (Matcher)Is.is((Object)"/a/[^/]*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a//f"), (Matcher)Is.is((Object)"/a(?:/[^/]*)*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a///f"), (Matcher)Is.is((Object)"/a(?:/[^/]*)*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/////f"), (Matcher)Is.is((Object)"/a(?:/[^/]*)*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/*"), (Matcher)Is.is((Object)"/[^/]*"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/*[]"), (Matcher)Is.is((Object)"/[^/]*(?:\\[\\d+\\])?"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/*[3]"), (Matcher)Is.is((Object)"/[^/]*\\[3\\]"));
    }

    @Test
    public void shouldDetermineIfPatternMatchesAnything() {
        Assert.assertThat((Object)PathExpression.compile((String)"/.").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"//").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"///").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"///").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"/*").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"*").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"*[*]").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"*[]").matchesAnything(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)PathExpression.compile((String)"/a").matchesAnything(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)PathExpression.compile((String)"/*[3]").matchesAnything(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)PathExpression.compile((String)"/a/b/c").matchesAnything(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchExpressionsWithoutRegardToCase() {
        this.expr = PathExpression.compile((String)"/a/b/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/E/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d/E"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").groupCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldMatchExpressionsWithExactFullPath() {
        this.expr = PathExpression.compile((String)"/a/b/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something2").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/ex/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchExpressionsWithExactFullPathAndExtraPathInsideMatch() {
        this.expr = PathExpression.compile((String)"/a/b/c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something2").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/ex/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchExpressionsWithWildcardSelection() {
        this.expr = PathExpression.compile((String)"/a/*/c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[2]/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/rt/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/rt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/ac/d/e/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/b2/b3/d/e/@something").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchExpressionsWithFilenameLikeWildcardSelection() {
        this.expr = PathExpression.compile((String)"/a/*.txt[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b.txt/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b.txt"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b.tx/@something").matches(), (Matcher)Is.is((Object)false));
        this.expr = PathExpression.compile((String)"/a/*.txt/c[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b.txt/c/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b.txt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b.tx/c/@something").matches(), (Matcher)Is.is((Object)false));
        this.expr = PathExpression.compile((String)"//*.txt[*]/c[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b.txt/c/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b.txt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b.tx/c/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").getInputPath(), (Matcher)Is.is((Object)"/z/a/b.txt/c/@something"));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/z/a/b.txt/c"));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").groupCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldMatchExpressionsWithSegmentWildcardSelection() {
        this.expr = PathExpression.compile((String)"/a//c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[2]/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/rt/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/rt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/r/s/t/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/r/s/t/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/r[1]/s[2]/t[33]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/r[1]/s[2]/t[33]/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a[3]/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchExpressionsWithSegmentWildcardAtEnd() {
        this.expr = PathExpression.compile((String)"/a/b/c//");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getInputPath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/a"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/a"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/f/g/h"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d/e/f/g/h"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/d").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchExpressionsWithExtraLargeSegmentWildcardAtEnd() {
        this.expr = PathExpression.compile((String)"/a/b/c////");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getInputPath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").groupCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldMatchExpressionsWithIndexesInSelectionPaths() {
        this.expr = PathExpression.compile((String)"/a/b[2,3,4,5]/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[3]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[3]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[4]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[4]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[5]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[5]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a[1]/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
        this.expr = PathExpression.compile((String)"/a/b[0,2,3,4,5]/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[3]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[3]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[4]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[4]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[5]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[5]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[0]/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("/a[1]/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchExpressionsWithAnyIndexesInSelectionPaths() {
        this.expr = PathExpression.compile((String)"/a/b[*]/c[]/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[2]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[3]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[3]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[4]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[4]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[5]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[5]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[1]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[1]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[6]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[6]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b[6]/c[1]/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b[6]/c[1]/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldMatchExpressionsWithRepositoryInSelectionPath() {
        this.expr = PathExpression.compile((String)"reposA::/a/b/c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("reposA::/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldMatchExpressionsWithNamedGroups() {
        this.expr = PathExpression.compile((String)"/a(//c)[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").group(0), (Matcher)Is.is((Object)"/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").group(1), (Matcher)Is.is((Object)"/b/c"));
        this.expr = PathExpression.compile((String)"/a(/(b|c|d|)/e)[f/g/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").groupCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").group(0), (Matcher)Is.is((Object)"/a/b/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").group(1), (Matcher)Is.is((Object)"/b/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").group(2), (Matcher)Is.is((Object)"b"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").getInputPath(), (Matcher)Is.is((Object)"/a/c/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/c/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").groupCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").group(0), (Matcher)Is.is((Object)"/a/c/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").group(1), (Matcher)Is.is((Object)"/c/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").group(2), (Matcher)Is.is((Object)"c"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").getInputPath(), (Matcher)Is.is((Object)"/a/d/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").groupCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").group(0), (Matcher)Is.is((Object)"/a/d/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").group(1), (Matcher)Is.is((Object)"/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").group(2), (Matcher)Is.is((Object)"d"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").getInputPath(), (Matcher)Is.is((Object)"/a/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").groupCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").group(0), (Matcher)Is.is((Object)"/a/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").group(1), (Matcher)Is.is((Object)"/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").group(2), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.expr.matcher("/a/t/e/f/g/@something").matches(), (Matcher)Is.is((Object)false));
        this.expr = PathExpression.compile((String)"/a/(b/c)[(d|e)/(f|g)/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").groupCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(0), (Matcher)Is.is((Object)"/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(1), (Matcher)Is.is((Object)"b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(2), (Matcher)Is.is((Object)"d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(3), (Matcher)Is.is((Object)"f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/e/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").groupCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(0), (Matcher)Is.is((Object)"/a/b/c/e/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(1), (Matcher)Is.is((Object)"b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(2), (Matcher)Is.is((Object)"e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(3), (Matcher)Is.is((Object)"f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").groupCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(0), (Matcher)Is.is((Object)"/a/b/c/d/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(1), (Matcher)Is.is((Object)"b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(2), (Matcher)Is.is((Object)"d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(3), (Matcher)Is.is((Object)"g"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/e/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").groupCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(0), (Matcher)Is.is((Object)"/a/b/c/e/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(1), (Matcher)Is.is((Object)"b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(2), (Matcher)Is.is((Object)"e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(3), (Matcher)Is.is((Object)"g"));
        this.expr = PathExpression.compile((String)"/a/(b/c)/(d|e)/(f|g)/@something");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getInputPath(), (Matcher)Is.is((Object)"/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getSelectedNodePath(), (Matcher)Is.is((Object)"/a/b/c/d/f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").groupCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(0), (Matcher)Is.is((Object)"/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(1), (Matcher)Is.is((Object)"b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(2), (Matcher)Is.is((Object)"d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(3), (Matcher)Is.is((Object)"f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").matches(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldMatchExpressionWithFilenamePatternAndChildProperty() {
        this.expr = PathExpression.compile((String)"//(*.(jpeg|gif|bmp|pcx|png|iff|ras|pbm|pgm|ppm|psd))[*]/jcr:content[@jcr:data]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/caution.png/jcr:content/@jcr:data").matches(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldMatchStringWithRepositoryAndWorkspaceUsingExpressionWithoutRepositoryOrWorkspace() {
        this.expr = PathExpression.compile((String)"//a/b");
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldMatchStringWithRepositoryAndWorkspaceUsingExpressionWithBlankRepositoryAndBlankWorkspace() {
        this.expr = PathExpression.compile((String)":://a/b");
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldMatchStringWithRepositoryAndWorkspaceUsingExpressionWithRepositoryAndBlankWorkspace() {
        this.expr = PathExpression.compile((String)"repo:://a/b");
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/y/a/b").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchStringWithRepositoryAndWorkspaceUsingExpressionWithRepositoryAndWorkspace() {
        this.expr = PathExpression.compile((String)"repo:workspace://a/b");
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/x/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/x/y/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace2:/x/y/a/b").matches(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMatchStringWithRepositoryAndWorkspaceUsingExpressionWithBlankRepositoryAndWorkspace() {
        this.expr = PathExpression.compile((String)":workspace://a/b");
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/x/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo:workspace2:/x/y/a/b").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace:/a").matches(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace:/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace:/x/a/b").matches(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.expr.matcher("repo1:workspace:/x/y/a/b").matches(), (Matcher)Is.is((Object)true));
    }
}

