/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;

public class PropertyTypeTest {
    @Test
    public void shouldDiscoverPropertyTypeGivenPrimitiveClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(Integer.TYPE), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(Long.TYPE), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(Short.TYPE), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(Boolean.TYPE), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(Double.TYPE), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(Float.TYPE), (Matcher)Is.is((Object)PropertyType.DOUBLE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenNumberClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(Integer.class), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(Long.class), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(Short.class), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(Boolean.class), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(Double.class), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(Float.class), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(BigDecimal.class), (Matcher)Is.is((Object)PropertyType.DECIMAL));
    }

    @Test
    public void shouldNotDiscoverPropertyTypeOfByteClass() {
        Assert.assertThat((Object)PropertyType.discoverType(Byte.class), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotDiscoverPropertyTypeOfBigIntegerClass() {
        Assert.assertThat((Object)PropertyType.discoverType(BigInteger.class), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotDiscoverPropertyTypeOfVoidClass() {
        Assert.assertThat((Object)PropertyType.discoverType(Void.TYPE), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenPrimitiveArrayClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new int[0].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new long[0].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new short[0].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new boolean[0].getClass()), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(new double[0].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(new float[0].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArrayOfPrimitiveArrayClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new int[0][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new long[0][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new short[0][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new boolean[0][].getClass()), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(new double[0][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(new float[0][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArrayOfArrayOfPrimitiveArrayClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new int[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new long[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new short[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new boolean[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(new double[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(new float[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenNumberArrayClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new Integer[0].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Long[0].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Short[0].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Boolean[0].getClass()), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(new Double[0].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(new Float[0].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArrayOfNumberArrayClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new Integer[0][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Long[0][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Short[0][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Boolean[0][].getClass()), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(new Double[0][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(new Float[0][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArrayOfArrayOfNumberArrayClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new Integer[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Long[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Short[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.LONG));
        Assert.assertThat((Object)PropertyType.discoverType(new Boolean[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.BOOLEAN));
        Assert.assertThat((Object)PropertyType.discoverType(new Double[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
        Assert.assertThat((Object)PropertyType.discoverType(new Float[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.DOUBLE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenStringClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(String.class), (Matcher)Is.is((Object)PropertyType.STRING));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenPathClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(Path.class), (Matcher)Is.is((Object)PropertyType.PATH));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenNameClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(Name.class), (Matcher)Is.is((Object)PropertyType.NAME));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenReferenceClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(Reference.class), (Matcher)Is.is((Object)PropertyType.REFERENCE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenDateTimeClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(DateTime.class), (Matcher)Is.is((Object)PropertyType.DATE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenUriClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(URI.class), (Matcher)Is.is((Object)PropertyType.URI));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenUuidClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(UUID.class), (Matcher)Is.is((Object)PropertyType.UUID));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArraysOfStringClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new String[0].getClass()), (Matcher)Is.is((Object)PropertyType.STRING));
        Assert.assertThat((Object)PropertyType.discoverType(new String[0][].getClass()), (Matcher)Is.is((Object)PropertyType.STRING));
        Assert.assertThat((Object)PropertyType.discoverType(new String[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.STRING));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArraysOfPathClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new Path[0].getClass()), (Matcher)Is.is((Object)PropertyType.PATH));
        Assert.assertThat((Object)PropertyType.discoverType(new Path[0][].getClass()), (Matcher)Is.is((Object)PropertyType.PATH));
        Assert.assertThat((Object)PropertyType.discoverType(new Path[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.PATH));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArraysOfNameClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new Name[0].getClass()), (Matcher)Is.is((Object)PropertyType.NAME));
        Assert.assertThat((Object)PropertyType.discoverType(new Name[0][].getClass()), (Matcher)Is.is((Object)PropertyType.NAME));
        Assert.assertThat((Object)PropertyType.discoverType(new Name[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.NAME));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArraysOfReferenceClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new Reference[0].getClass()), (Matcher)Is.is((Object)PropertyType.REFERENCE));
        Assert.assertThat((Object)PropertyType.discoverType(new Reference[0][].getClass()), (Matcher)Is.is((Object)PropertyType.REFERENCE));
        Assert.assertThat((Object)PropertyType.discoverType(new Reference[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.REFERENCE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArraysOfDateTimeClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new DateTime[0].getClass()), (Matcher)Is.is((Object)PropertyType.DATE));
        Assert.assertThat((Object)PropertyType.discoverType(new DateTime[0][].getClass()), (Matcher)Is.is((Object)PropertyType.DATE));
        Assert.assertThat((Object)PropertyType.discoverType(new DateTime[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.DATE));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArraysOfUriClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new URI[0].getClass()), (Matcher)Is.is((Object)PropertyType.URI));
        Assert.assertThat((Object)PropertyType.discoverType(new URI[0][].getClass()), (Matcher)Is.is((Object)PropertyType.URI));
        Assert.assertThat((Object)PropertyType.discoverType(new URI[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.URI));
    }

    @Test
    public void shouldDiscoverPropertyTypeGivenArraysOfUuidClass() throws Exception {
        Assert.assertThat((Object)PropertyType.discoverType(new UUID[0].getClass()), (Matcher)Is.is((Object)PropertyType.UUID));
        Assert.assertThat((Object)PropertyType.discoverType(new UUID[0][].getClass()), (Matcher)Is.is((Object)PropertyType.UUID));
        Assert.assertThat((Object)PropertyType.discoverType(new UUID[0][][].getClass()), (Matcher)Is.is((Object)PropertyType.UUID));
    }
}

