/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.basic.BasicNamespace;

public class BasicNamespaceTest {
    private BasicNamespace ns1;
    private BasicNamespace ns2;
    private BasicNamespace ns3;
    private BasicNamespace ns4;
    private BasicNamespace ns5;
    private String validUri1;
    private String validUri2;
    private String validUri3;
    private String validPrefix1;
    private String validPrefix2;
    private String validPrefix3;

    @Before
    public void beforeEach() {
        this.validUri1 = "";
        this.validUri2 = "http://www.example.com";
        this.validUri3 = "http://www.acme.com";
        this.validPrefix1 = "";
        this.validPrefix2 = "a";
        this.validPrefix3 = "b";
        this.ns1 = new BasicNamespace(this.validPrefix1, this.validUri1);
        this.ns2 = new BasicNamespace(this.validPrefix1, this.validUri2);
        this.ns3 = new BasicNamespace(this.validPrefix2, this.validUri1);
        this.ns4 = new BasicNamespace(this.validPrefix2, this.validUri2);
        this.ns5 = new BasicNamespace(this.validPrefix3, this.validUri3);
    }

    @Test
    public void shouldHaveSamePrefixPassedIntoConstructor() {
        Assert.assertThat((Object)this.ns1.getPrefix(), (Matcher)Is.is((Object)this.validPrefix1));
        Assert.assertThat((Object)this.ns2.getPrefix(), (Matcher)Is.is((Object)this.validPrefix1));
        Assert.assertThat((Object)this.ns3.getPrefix(), (Matcher)Is.is((Object)this.validPrefix2));
        Assert.assertThat((Object)this.ns4.getPrefix(), (Matcher)Is.is((Object)this.validPrefix2));
        Assert.assertThat((Object)this.ns5.getPrefix(), (Matcher)Is.is((Object)this.validPrefix3));
    }

    @Test
    public void shouldHaveSameNamespaceUriPassedIntoConstructor() {
        Assert.assertThat((Object)this.ns1.getNamespaceUri(), (Matcher)Is.is((Object)this.validUri1));
        Assert.assertThat((Object)this.ns2.getNamespaceUri(), (Matcher)Is.is((Object)this.validUri2));
        Assert.assertThat((Object)this.ns3.getNamespaceUri(), (Matcher)Is.is((Object)this.validUri1));
        Assert.assertThat((Object)this.ns4.getNamespaceUri(), (Matcher)Is.is((Object)this.validUri2));
        Assert.assertThat((Object)this.ns5.getNamespaceUri(), (Matcher)Is.is((Object)this.validUri3));
    }

    @Test
    public void shouldConsiderAsEqualAnyNamespacesWithSameUri() {
        Assert.assertThat((Object)this.ns1.equals((Object)this.ns3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ns3.equals((Object)this.ns1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ns2.equals((Object)this.ns4), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ns4.equals((Object)this.ns2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ns5.equals((Object)this.ns5), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotConsiderAsEqualAnyNamespacesWithDifferentUris() {
        Assert.assertThat((Object)this.ns1.equals((Object)this.ns2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.ns2.equals((Object)this.ns1), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.ns3.equals((Object)this.ns4), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.ns4.equals((Object)this.ns3), (Matcher)Is.is((Object)false));
    }
}

