/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.AbstractPathTest;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.BasicPath;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.RootPath;

public class RootPathTest
extends AbstractPathTest {
    protected Path root;

    @Before
    public void beforeEach() {
        super.beforeEach();
        this.path = RootPath.INSTANCE;
        this.root = this.path;
    }

    @Test
    public void shouldReturnRootForLowestCommonAncestorWithAnyNodePath() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isRoot()).thenReturn((Object)true);
        Assert.assertThat((Object)this.root.getCommonAncestor(other).isRoot(), (Matcher)Is.is((Object)true));
        Mockito.when((Object)other.isRoot()).thenReturn((Object)false);
        Assert.assertThat((Object)this.root.getCommonAncestor(other).isRoot(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderRootToBeAncestorOfEveryNodeExceptRoot() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.size()).thenReturn((Object)1);
        Assert.assertThat((Object)this.root.isAncestorOf(other), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.root.isAncestorOf(this.root), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotConsiderRootNodeToBeDecendantOfAnyNode() {
        Path other = (Path)Mockito.mock(Path.class);
        Assert.assertThat((Object)this.root.isDecendantOf(other), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.root.isDecendantOf(this.root), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderTwoRootNodesToHaveSameAncestor() {
        Assert.assertThat((Object)this.root.hasSameAncestor(this.root), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBeNormalized() {
        Assert.assertThat((Object)this.root.isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnSelfForGetNormalized() {
        Assert.assertThat((Object)this.root.getNormalizedPath(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.root)));
    }

    @Test
    public void shouldReturnSelfForGetCanonicalPath() {
        Assert.assertThat((Object)this.root.getCanonicalPath(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.root)));
    }

    @Test
    public void shouldReturnSizeOfZero() {
        Assert.assertThat((Object)this.root.size(), (Matcher)Is.is((Object)0));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldReturnImmutableSegmentsIterator() {
        this.root.iterator().remove();
    }

    @Test
    public void shouldReturnEmptyIteratorOverSegments() {
        Assert.assertThat((Object)this.root.iterator(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.root.iterator().hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSegmentAtIndexZero() {
        this.root.getSegment(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSegmentAtPositiveIndex() {
        this.root.getSegment(1);
    }

    @Test
    public void shouldReturnEmptySegmentsArray() {
        Assert.assertThat((Object)this.root.getSegmentsArray(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.root.getSegmentsArray().length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnEmptySegmentsList() {
        Assert.assertThat((Object)this.root.getSegmentsList(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.root.getSegmentsList().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAlwaysReturnPathWithSingleSlashForGetString() {
        NamespaceRegistry registry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        TextEncoder encoder = (TextEncoder)Mockito.mock(TextEncoder.class);
        Mockito.when((Object)encoder.encode("/")).thenReturn((Object)"/");
        Assert.assertThat((Object)this.root.getString(), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)this.root.getString(registry), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)this.root.getString(registry, encoder), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)this.root.getString(registry, encoder, encoder), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)this.root.getString(encoder), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldAllowNullNamespaceRegistryWithNonNullTextEncodersSinceRegistryIsNotNeeded() {
        TextEncoder encoder = (TextEncoder)Mockito.mock(TextEncoder.class);
        Mockito.when((Object)encoder.encode("/")).thenReturn((Object)"/");
        Assert.assertThat((Object)this.root.getString((NamespaceRegistry)null, encoder, encoder), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldAllowNullTextEncoder() {
        Assert.assertThat((Object)this.root.getString((TextEncoder)null), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldNotAllowNullTextEncoderWithNonNullNamespaceRegistry() {
        NamespaceRegistry registry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        Assert.assertThat((Object)this.root.getString(registry, (TextEncoder)null), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldNotAllowNullTextEncoderForDelimiterWithNonNullNamespaceRegistry() {
        NamespaceRegistry registry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        TextEncoder encoder = (TextEncoder)Mockito.mock(TextEncoder.class);
        Assert.assertThat((Object)this.root.getString(registry, encoder, (TextEncoder)null), (Matcher)Is.is((Object)"/"));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathStartingAtOne() {
        this.root.subpath(1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathStartingAtMoreThanOne() {
        this.root.subpath(2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathEndingAtMoreThanZero() {
        this.root.subpath(0, 1);
    }

    @Test
    public void shouldReturnRelativePathConsistingOfSameNumberOfParentReferencesAsSizeOfSuppliedPath() {
        ArrayList<BasicPathSegment> segments = new ArrayList<BasicPathSegment>();
        segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "a")));
        BasicPath other = new BasicPath(segments, true);
        Assert.assertThat((Object)this.root.relativeTo((Path)other).toString(), (Matcher)Is.is((Object)".."));
        segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "b")));
        other = new BasicPath(segments, true);
        Assert.assertThat((Object)this.root.relativeTo((Path)other).toString(), (Matcher)Is.is((Object)"../.."));
        String expected = "..";
        segments.clear();
        for (int i = 1; i != 100; ++i) {
            segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "b" + i)));
            other = new BasicPath(segments, true);
            Assert.assertThat((Object)this.root.relativeTo((Path)other).toString(), (Matcher)Is.is((Object)expected));
            expected = expected + "/..";
        }
    }

    @Test
    public void shouldResolveAllRelativePathsToTheirAbsolutePath() {
        ArrayList<BasicPathSegment> segments = new ArrayList<BasicPathSegment>();
        segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "a")));
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isAbsolute()).thenReturn((Object)false);
        Mockito.when((Object)other.getSegmentsList()).thenReturn(segments);
        Mockito.when((Object)other.getNormalizedPath()).thenReturn((Object)other);
        Path resolved = this.root.resolve(other);
        Assert.assertThat((Object)resolved.getSegmentsList(), (Matcher)Is.is(segments));
        Assert.assertThat((Object)resolved.isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotResolveRelativePathUsingAnAbsolutePath() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isAbsolute()).thenReturn((Object)true);
        this.root.resolve(other);
    }

    @Test
    public void shouldAlwaysConsiderRootAsLessThanAnyPathOtherThanRoot() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isRoot()).thenReturn((Object)false);
        Assert.assertThat((Object)this.root.compareTo((Object)other), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.root.equals(other), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAlwaysConsiderRootAsEqualToAnyOtherRoot() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isRoot()).thenReturn((Object)true);
        Assert.assertThat((Object)this.root.compareTo((Object)other), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.root.equals(other), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.root.equals(this.root), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnIteratorWithRootPathFromPathsFromRoot() {
        Iterator iter = this.root.pathsFromRoot();
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.root));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
    }
}

