/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.plan.PlanNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryTest {
    protected SelectorName selector(String selectorName) {
        return new SelectorName(selectorName);
    }

    protected Column column(SelectorName selector, String property) {
        return new Column(selector, property, property);
    }

    protected Column column(SelectorName selector, String property, String alias) {
        return new Column(selector, property, alias);
    }

    protected List<Column> columns(QueryContext context, SelectorName selector, String ... columnNames) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String columnName : columnNames) {
            columns.add(this.column(selector, columnName));
        }
        return columns;
    }

    protected List<String> columnTypes(QueryContext context, SelectorName selector, String ... columnNames) {
        ArrayList<String> types = new ArrayList<String>();
        for (String columnName : columnNames) {
            types.add(context.getTypeSystem().getDefaultType());
        }
        return types;
    }

    protected PlanNode sourceNode(QueryContext context, PlanNode parent, String selectorName, String ... columnNames) {
        PlanNode node = new PlanNode(PlanNode.Type.SOURCE, parent);
        SelectorName selector = this.selector(selectorName);
        node.addSelector(selector);
        node.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(context, selector, columnNames));
        node.setProperty(PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(context, selector, columnNames));
        return node;
    }

    protected void assertChildren(PlanNode node, PlanNode ... children) {
        Assert.assertThat((Object)node.getChildCount(), (Matcher)Is.is((Object)children.length));
        for (int i = 0; i != node.getChildCount(); ++i) {
            Assert.assertThat((Object)node.getChild(i), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)children[i])));
        }
    }

    protected void assertSameChildren(PlanNode node, PlanNode ... children) {
        Assert.assertThat((Object)node.getChildCount(), (Matcher)Is.is((Object)children.length));
        for (int i = 0; i != node.getChildCount(); ++i) {
            Assert.assertThat((Object)node.getChild(i).isSameAs(children[i]), (Matcher)Is.is((Object)true));
        }
    }

    protected void assertSelectors(PlanNode node, String ... selectors) {
        HashSet<SelectorName> selectorSet = new HashSet<SelectorName>();
        for (String selectorName : selectors) {
            selectorSet.add(new SelectorName(selectorName));
        }
        Assert.assertThat((String)"Selectors don't match", (Object)node.getSelectors(), (Matcher)Is.is(selectorSet));
    }

    protected void assertProperty(PlanNode node, PlanNode.Property name, Object value) {
        Assert.assertThat((String)"Property value doesn't match", (Object)node.getProperty(name), (Matcher)Is.is((Object)value));
    }

    protected <T> void assertPropertyIsList(PlanNode node, PlanNode.Property name, Class<T> valueType, T ... values) {
        Assert.assertThat((String)"Property value doesn't match", (Object)node.getPropertyAsList(name, valueType), (Matcher)Is.is(Arrays.asList(values)));
    }

    protected <T> void assertPropertyIsList(PlanNode node, PlanNode.Property name, Class<T> valueType, List<T> values) {
        Assert.assertThat((String)"Property value doesn't match", (Object)node.getPropertyAsList(name, valueType), (Matcher)Is.is(values));
    }

    protected void assertSortOrderBy(PlanNode sortNode, String ... selectors) {
        ArrayList<SelectorName> expected = new ArrayList<SelectorName>(selectors.length);
        for (String selectorName : selectors) {
            expected.add(new SelectorName(selectorName));
        }
        List actualSortedBy = sortNode.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, SelectorName.class);
        Assert.assertThat((String)"Sort node order-by doesn't match selector name list", (Object)actualSortedBy, (Matcher)Is.is(expected));
    }
}

