/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.optimize.AddJoinConditionColumnsToSources;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.Schemata;

public class AddJoinConditionColumnsToSourcesTest
extends AbstractQueryTest {
    private AddJoinConditionColumnsToSources rule;
    private QueryContext context;

    @Before
    public void beforeEach() {
        this.context = new QueryContext((Schemata)Mockito.mock(Schemata.class), new ExecutionContext().getValueFactories().getTypeSystem());
        this.rule = AddJoinConditionColumnsToSources.INSTANCE;
        this.context.getHints().hasJoin = true;
    }

    @Test
    public void shouldNotAddJoinConditionColumnIfAlreadyUsed() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.LEFT_OUTER);
        joinNode.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("left"), "c2", this.selector("right"), "d2"));
        PlanNode lhs = this.sourceNode(this.context, joinNode, "left", "c1", "c2", "c3");
        PlanNode rhs = this.sourceNode(this.context, joinNode, "right", "d1", "d2", "d3");
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode left = joinNode.getFirstChild();
        PlanNode right = joinNode.getLastChild();
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("left"), "c1", "c2", "c3"));
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("left"), "c1", "c2", "c3"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("right"), "d1", "d2", "d3"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("right"), "d1", "d2", "d3"));
    }

    @Test
    public void shouldNotAddJoinConditionWithChildNodesSwapped() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.LEFT_OUTER);
        joinNode.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("right"), "d2", this.selector("left"), "c2"));
        PlanNode lhs = this.sourceNode(this.context, joinNode, "left", "c1", "c2", "c3");
        PlanNode rhs = this.sourceNode(this.context, joinNode, "right", "d1", "d2", "d3");
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode left = joinNode.getFirstChild();
        PlanNode right = joinNode.getLastChild();
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("left"), "c1", "c2", "c3"));
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("left"), "c1", "c2", "c3"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("right"), "d1", "d2", "d3"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("right"), "d1", "d2", "d3"));
    }

    @Test
    public void shouldAddJoinConditionColumnOnLeftSideIfNotAlreadyUsed() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.LEFT_OUTER);
        joinNode.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("left"), "c4", this.selector("right"), "d2"));
        PlanNode lhs = this.sourceNode(this.context, joinNode, "left", "c1", "c2", "c3");
        PlanNode rhs = this.sourceNode(this.context, joinNode, "right", "d1", "d2", "d3");
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode left = joinNode.getFirstChild();
        PlanNode right = joinNode.getLastChild();
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("left"), "c1", "c2", "c3", "c4"));
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("left"), "c1", "c2", "c3", "c4"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("right"), "d1", "d2", "d3"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("right"), "d1", "d2", "d3"));
    }

    @Test
    public void shouldAddJoinConditionColumnOnRightSideIfNotAlreadyUsed() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.LEFT_OUTER);
        joinNode.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("left"), "c2", this.selector("right"), "d4"));
        PlanNode lhs = this.sourceNode(this.context, joinNode, "left", "c1", "c2", "c3");
        PlanNode rhs = this.sourceNode(this.context, joinNode, "right", "d1", "d2", "d3");
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode left = joinNode.getFirstChild();
        PlanNode right = joinNode.getLastChild();
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("left"), "c1", "c2", "c3"));
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("left"), "c1", "c2", "c3"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("right"), "d1", "d2", "d3", "d4"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("right"), "d1", "d2", "d3", "d4"));
    }

    @Test
    public void shouldAddJoinConditionColumnOnBothSidesIfNotAlreadyUsed() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.LEFT_OUTER);
        joinNode.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("left"), "c4", this.selector("right"), "d4"));
        PlanNode lhs = this.sourceNode(this.context, joinNode, "left", "c1", "c2", "c3");
        PlanNode rhs = this.sourceNode(this.context, joinNode, "right", "d1", "d2", "d3");
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode left = joinNode.getFirstChild();
        PlanNode right = joinNode.getLastChild();
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("left"), "c1", "c2", "c3", "c4"));
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("left"), "c1", "c2", "c3", "c4"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("right"), "d1", "d2", "d3", "d4"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("right"), "d1", "d2", "d3", "d4"));
    }

    @Test
    public void shouldAddJoinConditionColumnOnBothSidesIfChildrenSwappedAndIfNotAlreadyUsed() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.LEFT_OUTER);
        joinNode.setProperty(PlanNode.Property.JOIN_CONDITION, (Object)new EquiJoinCondition(this.selector("right"), "d4", this.selector("left"), "c4"));
        PlanNode lhs = this.sourceNode(this.context, joinNode, "left", "c1", "c2", "c3");
        PlanNode rhs = this.sourceNode(this.context, joinNode, "right", "d1", "d2", "d3");
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), (Matcher)Is.is((Object)JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode left = joinNode.getFirstChild();
        PlanNode right = joinNode.getLastChild();
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("left"), "c1", "c2", "c3", "c4"));
        this.assertProperty(left, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("left"), "c1", "c2", "c3", "c4"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMNS, this.columns(this.context, this.selector("right"), "d1", "d2", "d3", "d4"));
        this.assertProperty(right, PlanNode.Property.PROJECT_COLUMN_TYPES, this.columnTypes(this.context, this.selector("right"), "d1", "d2", "d3", "d4"));
    }
}

